/*     */ package org.jboss.dependency.plugins;
/*     */ 
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ScopeInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.scope.CommonLevels;
/*     */ import org.jboss.metadata.spi.scope.Scope;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ 
/*     */ public class AbstractScopeInfo
/*     */   implements ScopeInfo
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(AbstractScopeInfo.class);
/*     */   private ScopeKey scopeKey;
/*     */   private ScopeKey mutableScopeKey;
/*     */   private ScopeKey installScope;
/*     */   private MutableMetaDataRepository repository;
/*     */ 
/*     */   public AbstractScopeInfo(Object name)
/*     */   {
/*  65 */     this(name, null);
/*     */   }
/*     */ 
/*     */   public AbstractScopeInfo(Object name, String className)
/*     */   {
/*  76 */     if (name == null) {
/*  77 */       throw new IllegalArgumentException("Null scope");
/*     */     }
/*  79 */     ScopeKey scopeKey = ScopeKey.DEFAULT_SCOPE.clone();
/*  80 */     scopeKey.addScope(CommonLevels.INSTANCE, name.toString());
/*  81 */     if (className != null) {
/*  82 */       scopeKey.addScope(CommonLevels.CLASS, className);
/*     */     }
/*  84 */     scopeKey.addScope(CommonLevels.WORK, String.valueOf(hashCode()));
/*  85 */     setScope(scopeKey);
/*  86 */     setMutableScope(new ScopeKey(CommonLevels.INSTANCE, name.toString()));
/*     */   }
/*     */ 
/*     */   public AbstractScopeInfo(ScopeKey key, ScopeKey mutable)
/*     */   {
/*  97 */     setScope(key);
/*  98 */     setMutableScope(mutable);
/*     */   }
/*     */ 
/*     */   public MetaData getMetaData()
/*     */   {
/* 103 */     if (this.repository == null)
/* 104 */       return null;
/* 105 */     return this.repository.getMetaData(getScope());
/*     */   }
/*     */ 
/*     */   public void addMetaData(MutableMetaDataRepository repository, ControllerContext context)
/*     */   {
/* 110 */     this.repository = repository;
/* 111 */     ScopeKey scope = getMutableScope();
/* 112 */     MemoryMetaDataLoader mutable = new MemoryMetaDataLoader(scope);
/* 113 */     repository.addMetaDataRetrieval(mutable);
/* 114 */     addMetaData(repository, context, mutable);
/*     */   }
/*     */ 
/*     */   protected void addMetaData(MutableMetaDataRepository repository, ControllerContext context, MemoryMetaDataLoader mutable)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void removeMetaData(MutableMetaDataRepository repository, ControllerContext context)
/*     */   {
/*     */     try
/*     */     {
/* 134 */       ScopeKey scope = getScope();
/* 135 */       repository.removeMetaDataRetrieval(scope);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 139 */       log.trace("Ignored", e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 144 */       ScopeKey scope = getMutableScope();
/* 145 */       repository.removeMetaDataRetrieval(scope);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 149 */       log.trace("Ignored", e);
/*     */     }
/* 151 */     this.repository = null;
/*     */   }
/*     */ 
/*     */   public MetaDataRetrieval initMetaDataRetrieval(MutableMetaDataRepository repository, ControllerContext context, Scope scope)
/*     */   {
/* 158 */     return null;
/*     */   }
/*     */ 
/*     */   public ScopeKey getScope()
/*     */   {
/* 163 */     return this.scopeKey;
/*     */   }
/*     */ 
/*     */   public void setScope(ScopeKey key)
/*     */   {
/* 168 */     if (key == null)
/* 169 */       throw new IllegalArgumentException("Null scope key");
/* 170 */     this.scopeKey = key;
/*     */   }
/*     */ 
/*     */   public ScopeKey getMutableScope()
/*     */   {
/* 175 */     return this.mutableScopeKey;
/*     */   }
/*     */ 
/*     */   public void setMutableScope(ScopeKey key)
/*     */   {
/* 180 */     if (key == null)
/* 181 */       throw new IllegalArgumentException("Null scope key");
/* 182 */     this.mutableScopeKey = key;
/*     */   }
/*     */ 
/*     */   public ScopeKey getInstallScope()
/*     */   {
/* 187 */     return this.installScope;
/*     */   }
/*     */ 
/*     */   public void setInstallScope(ScopeKey key)
/*     */   {
/* 192 */     this.installScope = key;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.plugins.AbstractScopeInfo
 * JD-Core Version:    0.6.0
 */