/*     */ package org.jboss.dependency.plugins;
/*     */ 
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerMode;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractDependencyItem extends JBossObject
/*     */   implements DependencyItem
/*     */ {
/*  43 */   private static final Logger log = Logger.getLogger(AbstractDependencyItem.class);
/*     */   private Object iDependOn;
/*     */   private Object name;
/*  52 */   private ControllerState whenRequired = ControllerState.DESCRIBED;
/*     */   private ControllerState dependentState;
/*     */   private boolean resolved;
/*     */ 
/*     */   public AbstractDependencyItem()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractDependencyItem(Object name, Object iDependOn, ControllerState whenRequired, ControllerState dependentState)
/*     */   {
/*  77 */     this.name = name;
/*  78 */     setIDependOn(iDependOn);
/*  79 */     this.whenRequired = whenRequired;
/*  80 */     this.dependentState = dependentState;
/*     */   }
/*     */ 
/*     */   public Object getName()
/*     */   {
/*  85 */     return this.name;
/*     */   }
/*     */ 
/*     */   public Object getIDependOn()
/*     */   {
/*  90 */     return this.iDependOn;
/*     */   }
/*     */ 
/*     */   public ControllerState getWhenRequired()
/*     */   {
/*  95 */     return this.whenRequired;
/*     */   }
/*     */ 
/*     */   public ControllerState getDependentState()
/*     */   {
/* 100 */     return this.dependentState;
/*     */   }
/*     */ 
/*     */   public boolean isResolved()
/*     */   {
/* 105 */     return this.resolved;
/*     */   }
/*     */ 
/*     */   public boolean resolve(Controller controller)
/*     */   {
/* 110 */     boolean previous = this.resolved;
/*     */     ControllerContext context;
/*     */     ControllerContext context;
/* 113 */     if (this.dependentState == null) {
/* 114 */       context = controller.getInstalledContext(this.iDependOn);
/*     */     }
/*     */     else {
/* 117 */       context = controller.getContext(this.iDependOn, this.dependentState);
/* 118 */       if (context == null)
/*     */       {
/* 120 */         if (ControllerState.INSTALLED.equals(this.dependentState)) {
/* 121 */           context = controller.getInstalledContext(this.iDependOn);
/*     */         }
/*     */       }
/*     */     }
/* 125 */     if (context == null)
/*     */     {
/* 127 */       this.resolved = false;
/* 128 */       ControllerContext unresolvedContext = controller.getContext(this.iDependOn, null);
/* 129 */       if ((unresolvedContext != null) && (ControllerMode.ON_DEMAND.equals(unresolvedContext.getMode())))
/*     */       {
/*     */         try
/*     */         {
/* 133 */           controller.enableOnDemand(unresolvedContext);
/*     */         }
/*     */         catch (Throwable ignored)
/*     */         {
/* 137 */           if (log.isTraceEnabled())
/* 138 */             log.trace("Unexpected error", ignored);
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 144 */       addDependsOnMe(controller, context);
/* 145 */       this.resolved = true;
/*     */     }
/*     */ 
/* 148 */     if (previous != this.resolved)
/*     */     {
/* 150 */       flushJBossObjectCache();
/* 151 */       if (log.isTraceEnabled())
/*     */       {
/* 153 */         if (this.resolved)
/* 154 */           log.trace("Resolved " + this);
/*     */         else
/* 156 */           log.trace("Unresolved " + this);
/*     */       }
/*     */     }
/* 159 */     return this.resolved;
/*     */   }
/*     */ 
/*     */   public boolean unresolved(Controller controller)
/*     */   {
/* 164 */     if (this.resolved)
/*     */     {
/* 166 */       this.resolved = false;
/* 167 */       flushJBossObjectCache();
/* 168 */       log.trace("Forced unresolved " + this);
/*     */     }
/* 170 */     return true;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 175 */     buffer.append("name=").append(this.name);
/* 176 */     buffer.append(" dependsOn=").append(this.iDependOn);
/* 177 */     if (this.whenRequired != null)
/* 178 */       buffer.append(" whenRequired=").append(this.whenRequired.getStateString());
/* 179 */     if (this.dependentState != null)
/* 180 */       buffer.append(" dependentState=").append(this.dependentState.getStateString());
/* 181 */     buffer.append(" resolved=").append(this.resolved);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 186 */     buffer.append(this.name).append(" dependsOn ").append(this.iDependOn);
/*     */   }
/*     */ 
/*     */   protected void addDependsOnMe(Controller controller, ControllerContext context)
/*     */   {
/* 197 */     DependencyInfo info = context.getDependencyInfo();
/* 198 */     if (info != null)
/* 199 */       info.addDependsOnMe(this);
/*     */   }
/*     */ 
/*     */   protected void setIDependOn(Object iDependOn)
/*     */   {
/* 209 */     this.iDependOn = iDependOn;
/*     */ 
/* 212 */     Object fixup = JMXObjectNameFix.needsAnAlias(iDependOn);
/* 213 */     if (fixup != null) {
/* 214 */       this.iDependOn = fixup;
/*     */     }
/* 216 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   protected void setResolved(boolean resolved)
/*     */   {
/* 226 */     this.resolved = resolved;
/* 227 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public String toHumanReadableString()
/*     */   {
/* 232 */     StringBuilder builder = new StringBuilder();
/* 233 */     builder.append("Depends on '").append(getIDependOn());
/* 234 */     return builder.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.plugins.AbstractDependencyItem
 * JD-Core Version:    0.6.0
 */