/*     */ package org.jboss.crypto.digest;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.security.MessageDigest;
/*     */ import java.security.MessageDigestSpi;
/*     */ import java.security.NoSuchAlgorithmException;
/*     */ import java.security.ProviderException;
/*     */ 
/*     */ public class SHAReverseInterleave extends MessageDigestSpi
/*     */ {
/*     */   private static final int SHA_HASH_LEN = 20;
/*     */   private ByteArrayOutputStream evenBytes;
/*     */   private ByteArrayOutputStream oddBytes;
/*     */   private int count;
/*     */   private boolean skipLeadingZeros;
/*     */   private MessageDigest sha;
/*     */ 
/*     */   public SHAReverseInterleave()
/*     */   {
/*     */     try
/*     */     {
/*  58 */       this.sha = MessageDigest.getInstance("SHA");
/*     */     }
/*     */     catch (NoSuchAlgorithmException e)
/*     */     {
/*  62 */       throw new ProviderException("Failed to obtain SHA MessageDigest");
/*     */     }
/*  64 */     this.evenBytes = new ByteArrayOutputStream();
/*  65 */     this.oddBytes = new ByteArrayOutputStream();
/*  66 */     engineReset();
/*     */   }
/*     */ 
/*     */   protected int engineGetDigestLength()
/*     */   {
/*  71 */     return 40;
/*     */   }
/*     */ 
/*     */   protected byte[] engineDigest()
/*     */   {
/*  86 */     byte[] E = this.evenBytes.toByteArray();
/*     */ 
/*  88 */     int length = E.length;
/*  89 */     if (this.count % 2 == 1) {
/*  90 */       length--;
/*     */     }
/*  92 */     byte[] tmp = new byte[length];
/*  93 */     for (int i = 0; i < length; i++)
/*     */     {
/*  95 */       tmp[i] = E[(E.length - i - 1)];
/*  96 */       System.out.println("E[" + i + "] = " + tmp[i]);
/*     */     }
/*  98 */     E = tmp;
/*  99 */     byte[] G = this.sha.digest(E);
/*     */ 
/* 101 */     byte[] F = this.oddBytes.toByteArray();
/*     */ 
/* 103 */     tmp = new byte[F.length];
/* 104 */     for (int i = 0; i < F.length; i++)
/*     */     {
/* 106 */       tmp[i] = F[(F.length - i - 1)];
/* 107 */       System.out.println("F[" + i + "] = " + tmp[i]);
/*     */     }
/* 109 */     F = tmp;
/* 110 */     this.sha.reset();
/* 111 */     byte[] H = this.sha.digest(F);
/* 112 */     length = G.length + H.length;
/* 113 */     byte[] digest = new byte[length];
/* 114 */     for (int i = 0; i < G.length; i++)
/* 115 */       digest[(2 * i)] = G[i];
/* 116 */     for (int i = 0; i < H.length; i++)
/* 117 */       digest[(2 * i + 1)] = H[i];
/* 118 */     engineReset();
/* 119 */     return digest;
/*     */   }
/*     */ 
/*     */   protected void engineReset()
/*     */   {
/* 127 */     this.skipLeadingZeros = true;
/* 128 */     this.count = 0;
/* 129 */     this.evenBytes.reset();
/* 130 */     this.oddBytes.reset();
/* 131 */     this.sha.reset();
/*     */   }
/*     */ 
/*     */   protected void engineUpdate(byte input)
/*     */   {
/* 141 */     if ((this.skipLeadingZeros == true) && (input == 0))
/* 142 */       return;
/* 143 */     this.skipLeadingZeros = false;
/* 144 */     if (this.count % 2 == 0)
/* 145 */       this.evenBytes.write(input);
/*     */     else
/* 147 */       this.oddBytes.write(input);
/* 148 */     this.count += 1;
/*     */   }
/*     */ 
/*     */   protected void engineUpdate(byte[] input, int offset, int len)
/*     */   {
/* 162 */     for (int i = offset; i < offset + len; i++)
/* 163 */       engineUpdate(input[i]);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.crypto.digest.SHAReverseInterleave
 * JD-Core Version:    0.6.0
 */