/*     */ package org.jboss.crypto.digest;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.security.MessageDigest;
/*     */ import java.security.MessageDigestSpi;
/*     */ import java.security.NoSuchAlgorithmException;
/*     */ import java.security.ProviderException;
/*     */ 
/*     */ public class SHAInterleave extends MessageDigestSpi
/*     */ {
/*     */   private static final int SHA_HASH_LEN = 20;
/*     */   private ByteArrayOutputStream evenBytes;
/*     */   private ByteArrayOutputStream oddBytes;
/*     */   private int count;
/*     */   private boolean skipLeadingZeros;
/*     */   private MessageDigest sha;
/*     */ 
/*     */   public SHAInterleave()
/*     */   {
/*     */     try
/*     */     {
/*  54 */       this.sha = MessageDigest.getInstance("SHA");
/*     */     }
/*     */     catch (NoSuchAlgorithmException e)
/*     */     {
/*  58 */       throw new ProviderException("Failed to obtain SHA MessageDigest");
/*     */     }
/*  60 */     this.evenBytes = new ByteArrayOutputStream();
/*  61 */     this.oddBytes = new ByteArrayOutputStream();
/*  62 */     engineReset();
/*     */   }
/*     */ 
/*     */   protected int engineGetDigestLength()
/*     */   {
/*  67 */     return 40;
/*     */   }
/*     */ 
/*     */   protected byte[] engineDigest()
/*     */   {
/*  82 */     byte[] E = this.evenBytes.toByteArray();
/*  83 */     byte[] G = this.sha.digest(E);
/*     */ 
/*  85 */     byte[] F = this.oddBytes.toByteArray();
/*  86 */     int offset = 0;
/*  87 */     if (this.count % 2 == 1)
/*  88 */       offset = 1;
/*  89 */     this.sha.reset();
/*  90 */     this.sha.update(F, offset, F.length - offset);
/*  91 */     byte[] H = this.sha.digest();
/*  92 */     int length = G.length + H.length;
/*  93 */     byte[] digest = new byte[length];
/*  94 */     for (int i = 0; i < G.length; i++)
/*  95 */       digest[(2 * i)] = G[i];
/*  96 */     for (int i = 0; i < H.length; i++)
/*  97 */       digest[(2 * i + 1)] = H[i];
/*  98 */     engineReset();
/*  99 */     return digest;
/*     */   }
/*     */ 
/*     */   protected void engineReset()
/*     */   {
/* 107 */     this.skipLeadingZeros = true;
/* 108 */     this.count = 0;
/* 109 */     this.evenBytes.reset();
/* 110 */     this.oddBytes.reset();
/* 111 */     this.sha.reset();
/*     */   }
/*     */ 
/*     */   protected void engineUpdate(byte input)
/*     */   {
/* 121 */     if ((this.skipLeadingZeros == true) && (input == 0))
/* 122 */       return;
/* 123 */     this.skipLeadingZeros = false;
/* 124 */     if (this.count % 2 == 0)
/* 125 */       this.evenBytes.write(input);
/*     */     else
/* 127 */       this.oddBytes.write(input);
/* 128 */     this.count += 1;
/*     */   }
/*     */ 
/*     */   protected void engineUpdate(byte[] input, int offset, int len)
/*     */   {
/* 142 */     for (int i = offset; i < offset + len; i++)
/* 143 */       engineUpdate(input[i]);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.crypto.digest.SHAInterleave
 * JD-Core Version:    0.6.0
 */