/*     */ package org.jboss.config.plugins;
/*     */ 
/*     */ import java.lang.reflect.Type;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.BeanInfoFactory;
/*     */ import org.jboss.classadapter.spi.ClassAdapter;
/*     */ import org.jboss.classadapter.spi.ClassAdapterFactory;
/*     */ import org.jboss.classadapter.spi.DependencyBuilder;
/*     */ import org.jboss.config.spi.Configuration;
/*     */ import org.jboss.joinpoint.spi.JoinpointFactoryBuilder;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ 
/*     */ public abstract class AbstractConfiguration
/*     */   implements Configuration
/*     */ {
/*     */   private BeanInfoFactory beanInfoFactory;
/*     */   private ClassAdapterFactory classAdapterFactory;
/*     */   private TypeInfoFactory typeInfoFactory;
/*     */   private JoinpointFactoryBuilder joinpointFactoryBuilder;
/*     */   private DependencyBuilder dependencyBuilder;
/*     */ 
/*     */   public BeanInfo getBeanInfo(String className, ClassLoader cl)
/*     */     throws ClassNotFoundException
/*     */   {
/*  70 */     ClassAdapter classAdapter = getClassAdapterFactory().getClassAdapter(className, cl);
/*  71 */     return getBeanInfoFactory().getBeanInfo(classAdapter);
/*     */   }
/*     */ 
/*     */   public BeanInfo getBeanInfo(Class clazz)
/*     */   {
/*  76 */     ClassAdapter classAdapter = getClassAdapterFactory().getClassAdapter(clazz);
/*  77 */     return getBeanInfoFactory().getBeanInfo(classAdapter);
/*     */   }
/*     */ 
/*     */   public BeanInfo getBeanInfo(TypeInfo typeInfo)
/*     */   {
/*  82 */     ClassAdapter classAdapter = getClassAdapterFactory().getClassAdapter(typeInfo);
/*  83 */     return getBeanInfoFactory().getBeanInfo(classAdapter);
/*     */   }
/*     */ 
/*     */   public ClassInfo getClassInfo(String className, ClassLoader cl) throws ClassNotFoundException
/*     */   {
/*  88 */     ClassAdapter classAdapter = getClassAdapterFactory().getClassAdapter(className, cl);
/*  89 */     return classAdapter.getClassInfo();
/*     */   }
/*     */ 
/*     */   public ClassInfo getClassInfo(Class clazz)
/*     */   {
/*  94 */     ClassAdapter classAdapter = getClassAdapterFactory().getClassAdapter(clazz);
/*  95 */     return classAdapter.getClassInfo();
/*     */   }
/*     */ 
/*     */   public TypeInfo getTypeInfo(Type type)
/*     */   {
/* 100 */     return getTypeInfoFactory().getTypeInfo(type);
/*     */   }
/*     */ 
/*     */   public TypeInfoFactory getTypeInfoFactory()
/*     */   {
/* 105 */     if (this.typeInfoFactory == null)
/*     */     {
/*     */       try
/*     */       {
/* 109 */         this.typeInfoFactory = createDefaultTypeInfoFactory();
/*     */       }
/*     */       catch (RuntimeException e)
/*     */       {
/* 113 */         throw e;
/*     */       }
/*     */       catch (Error e)
/*     */       {
/* 117 */         throw e;
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 121 */         throw new NestedRuntimeException("Cannot create TypeInfoFactory", t);
/*     */       }
/*     */     }
/* 124 */     return this.typeInfoFactory;
/*     */   }
/*     */ 
/*     */   public JoinpointFactoryBuilder getJoinpointFactoryBuilder()
/*     */   {
/* 129 */     if (this.joinpointFactoryBuilder == null)
/*     */     {
/*     */       try
/*     */       {
/* 133 */         this.joinpointFactoryBuilder = createDefaultJoinpointFactoryBuilder();
/*     */       }
/*     */       catch (RuntimeException e)
/*     */       {
/* 137 */         throw e;
/*     */       }
/*     */       catch (Error e)
/*     */       {
/* 141 */         throw e;
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 145 */         throw new NestedRuntimeException("Cannot create JoinpointFactoryBuilder", t);
/*     */       }
/*     */     }
/* 148 */     return this.joinpointFactoryBuilder;
/*     */   }
/*     */ 
/*     */   public DependencyBuilder getDependencyBuilder()
/*     */   {
/* 153 */     if (this.dependencyBuilder == null)
/*     */     {
/*     */       try
/*     */       {
/* 157 */         this.dependencyBuilder = createDefaultDependencyBuilder();
/*     */       }
/*     */       catch (RuntimeException e)
/*     */       {
/* 161 */         throw e;
/*     */       }
/*     */       catch (Error e)
/*     */       {
/* 165 */         throw e;
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 169 */         throw new NestedRuntimeException("Cannot create DependencyBuilder", t);
/*     */       }
/*     */     }
/* 172 */     return this.dependencyBuilder;
/*     */   }
/*     */ 
/*     */   protected BeanInfoFactory getBeanInfoFactory()
/*     */   {
/* 182 */     if (this.beanInfoFactory == null)
/*     */     {
/*     */       try
/*     */       {
/* 186 */         this.beanInfoFactory = createDefaultBeanInfoFactory();
/*     */       }
/*     */       catch (RuntimeException e)
/*     */       {
/* 190 */         throw e;
/*     */       }
/*     */       catch (Error e)
/*     */       {
/* 194 */         throw e;
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 198 */         throw new RuntimeException("Error creating bean info factory");
/*     */       }
/*     */     }
/* 201 */     return this.beanInfoFactory;
/*     */   }
/*     */ 
/*     */   protected ClassAdapterFactory getClassAdapterFactory()
/*     */   {
/* 211 */     if (this.classAdapterFactory == null)
/*     */     {
/*     */       try
/*     */       {
/* 215 */         this.classAdapterFactory = createDefaultClassAdapterFactory();
/*     */       }
/*     */       catch (RuntimeException e)
/*     */       {
/* 219 */         throw e;
/*     */       }
/*     */       catch (Error e)
/*     */       {
/* 223 */         throw e;
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 227 */         throw new RuntimeException("Error creating class adapter");
/*     */       }
/*     */     }
/* 230 */     return this.classAdapterFactory;
/*     */   }
/*     */ 
/*     */   protected abstract BeanInfoFactory createDefaultBeanInfoFactory()
/*     */     throws Throwable;
/*     */ 
/*     */   protected abstract ClassAdapterFactory createDefaultClassAdapterFactory()
/*     */     throws Throwable;
/*     */ 
/*     */   protected abstract TypeInfoFactory createDefaultTypeInfoFactory()
/*     */     throws Throwable;
/*     */ 
/*     */   protected abstract JoinpointFactoryBuilder createDefaultJoinpointFactoryBuilder()
/*     */     throws Throwable;
/*     */ 
/*     */   protected abstract DependencyBuilder createDefaultDependencyBuilder()
/*     */     throws Throwable;
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.config.plugins.AbstractConfiguration
 * JD-Core Version:    0.6.0
 */