/*    */ package org.jboss.client;
/*    */ 
/*    */ import java.lang.reflect.InvocationTargetException;
/*    */ import java.lang.reflect.Method;
/*    */ import java.lang.reflect.Modifier;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class ReflectionLauncher
/*    */   implements AppClientLauncher
/*    */ {
/* 41 */   private static Logger log = Logger.getLogger(ReflectionLauncher.class);
/*    */ 
/*    */   public void launch(String clientClass, String clientName, String[] args)
/*    */     throws Throwable
/*    */   {
/*    */     try
/*    */     {
/* 58 */       System.setProperty("j2ee.clientName", clientName);
/*    */ 
/* 60 */       Class cl = Class.forName(clientClass);
/* 61 */       Method main = cl.getDeclaredMethod("main", new Class[] { [Ljava.lang.String.class });
/* 62 */       Object[] mainArgs = { args };
/* 63 */       if (Modifier.isStatic(main.getModifiers()))
/*    */       {
/* 65 */         main.invoke(null, mainArgs);
/*    */       }
/*    */       else
/*    */       {
/* 69 */         Object client = cl.newInstance();
/* 70 */         main.invoke(client, mainArgs);
/*    */       }
/* 72 */       log.debug("Client invoker success.");
/*    */     }
/*    */     catch (InvocationTargetException e)
/*    */     {
/* 76 */       throw e.getTargetException();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.client.ReflectionLauncher
 * JD-Core Version:    0.6.0
 */