/*     */ package org.jboss.classloader.test.support;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import org.jboss.classloader.plugins.system.DefaultClassLoaderSystem;
/*     */ import org.jboss.classloader.spi.ClassLoaderDomain;
/*     */ import org.jboss.classloader.spi.ClassLoaderSystem;
/*     */ 
/*     */ public class MockClassLoaderHelper
/*     */ {
/*     */   public static ClassLoaderSystem createMockClassLoaderSystem()
/*     */   {
/*  50 */     return new DefaultClassLoaderSystem();
/*     */   }
/*     */ 
/*     */   public static MockClassLoaderPolicy createMockClassLoaderPolicy(String name)
/*     */   {
/*  61 */     return (MockClassLoaderPolicy)AccessController.doPrivileged(new PrivilegedAction(name)
/*     */     {
/*     */       public MockClassLoaderPolicy run()
/*     */       {
/*  65 */         return new MockClassLoaderPolicy(this.val$name);
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public static ClassLoader createAndRegisterMockClassLoader(ClassLoaderSystem system, ClassLoaderDomain domain, String name)
/*     */   {
/*  83 */     return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(name, domain, system)
/*     */     {
/*     */       public ClassLoader run()
/*     */       {
/*  87 */         MockClassLoaderPolicy policy = new MockClassLoaderPolicy(this.val$name);
/*  88 */         if (this.val$domain == null) {
/*  89 */           return this.val$system.registerClassLoaderPolicy(policy);
/*     */         }
/*  91 */         return this.val$system.registerClassLoaderPolicy(this.val$domain, policy);
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public static ClassLoader registerMockClassLoader(ClassLoaderSystem system, ClassLoaderDomain domain, MockClassLoaderPolicy policy)
/*     */   {
/* 109 */     return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(domain, system, policy)
/*     */     {
/*     */       public ClassLoader run()
/*     */       {
/* 113 */         if (this.val$domain == null) {
/* 114 */           return this.val$system.registerClassLoaderPolicy(this.val$policy);
/*     */         }
/* 116 */         return this.val$system.registerClassLoaderPolicy(this.val$domain, this.val$policy);
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public static boolean isExpectedClassLoader(Class<?> clazz, ClassLoader expected)
/*     */   {
/* 130 */     ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(clazz)
/*     */     {
/*     */       public ClassLoader run()
/*     */       {
/* 134 */         return this.val$clazz.getClassLoader();
/*     */       }
/*     */     });
/* 137 */     if (classLoader == null)
/* 138 */       return expected == null;
/* 139 */     return classLoader.equals(expected);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.test.support.MockClassLoaderHelper
 * JD-Core Version:    0.6.0
 */