/*     */ package org.jboss.classloader.spi.filter;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import org.jboss.classloader.plugins.filter.PatternClassFilter;
/*     */ 
/*     */ public class PackageClassFilter extends PatternClassFilter
/*     */ {
/*     */   private String[] packageNames;
/*     */ 
/*     */   private static String[] convertPackageNamesToClassPatterns(String[] packageNames)
/*     */   {
/*  47 */     if (packageNames == null) {
/*  48 */       throw new IllegalArgumentException("Null package names");
/*     */     }
/*  50 */     String[] patterns = new String[packageNames.length];
/*  51 */     for (int i = 0; i < packageNames.length; i++)
/*     */     {
/*  53 */       if (packageNames[i] == null) {
/*  54 */         throw new IllegalArgumentException("Null package name in " + Arrays.asList(packageNames));
/*     */       }
/*  56 */       if (packageNames[i].length() == 0)
/*     */       {
/*  58 */         patterns[i] = "[^.]*";
/*     */       }
/*     */       else
/*  61 */         patterns[i] = (packageNames[i].replace(".", "\\.") + "\\.[^.]+");
/*     */     }
/*  63 */     return patterns;
/*     */   }
/*     */ 
/*     */   private static String[] convertPackageNamesToResourcePatterns(String[] packageNames)
/*     */   {
/*  74 */     if (packageNames == null) {
/*  75 */       throw new IllegalArgumentException("Null package names");
/*     */     }
/*  77 */     String[] patterns = new String[packageNames.length];
/*  78 */     for (int i = 0; i < packageNames.length; i++)
/*     */     {
/*  80 */       if (packageNames[i] == null) {
/*  81 */         throw new IllegalArgumentException("Null package name in " + Arrays.asList(packageNames));
/*     */       }
/*  83 */       if (packageNames[i].length() == 0)
/*     */       {
/*  85 */         patterns[i] = "[^/]*";
/*     */       }
/*     */       else
/*  88 */         patterns[i] = (packageNames[i].replace(".", "/") + "/[^/]+");
/*     */     }
/*  90 */     return patterns;
/*     */   }
/*     */ 
/*     */   public static PackageClassFilter createPackageClassFilter(String[] packageNames)
/*     */   {
/* 102 */     return new PackageClassFilter(packageNames);
/*     */   }
/*     */ 
/*     */   public PackageClassFilter(String[] packageNames)
/*     */   {
/* 113 */     super(convertPackageNamesToClassPatterns(packageNames), convertPackageNamesToResourcePatterns(packageNames));
/* 114 */     this.packageNames = packageNames;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 120 */     StringBuilder builder = new StringBuilder();
/* 121 */     builder.append(Arrays.asList(this.packageNames));
/* 122 */     if (isIncludeJava())
/* 123 */       builder.append(" <INCLUDE_JAVA>");
/* 124 */     return builder.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.spi.filter.PackageClassFilter
 * JD-Core Version:    0.6.0
 */