/*     */ package org.jboss.classloader.spi.base;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.classloader.spi.Loader;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClassLoaderManager
/*     */ {
/*  45 */   private static Logger log = Logger.getLogger("org.jboss.detailed.classloader.ClassLoaderManager");
/*     */ 
/*  48 */   private static Map<BaseClassLoader, Thread> loadClassThreads = new HashMap();
/*     */ 
/*  51 */   private static Map<Thread, List<ClassLoadingTask.ThreadTask>> loadTasksByThread = Collections.synchronizedMap(new WeakHashMap());
/*     */ 
/*     */   static void registerLoaderThread(BaseClassLoader classloader, Thread thread)
/*     */   {
/*  62 */     boolean trace = log.isTraceEnabled();
/*     */ 
/*  64 */     synchronized (loadClassThreads)
/*     */     {
/*  66 */       Object previousThread = loadClassThreads.put(classloader, thread);
/*  67 */       if (trace) {
/*  68 */         log.trace("registerLoaderThread, classloader=" + classloader + " thread=" + thread + " previousThread=" + previousThread);
/*     */       }
/*  70 */       synchronized (loadTasksByThread)
/*     */       {
/*  72 */         List taskList = (List)loadTasksByThread.get(thread);
/*  73 */         if (taskList == null)
/*     */         {
/*  75 */           taskList = Collections.synchronizedList(new LinkedList());
/*  76 */           loadTasksByThread.put(thread, taskList);
/*  77 */           if (trace)
/*  78 */             log.trace("Created new task list for " + thread);
/*     */         }
/*     */       }
/*  81 */       loadClassThreads.notifyAll();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void unregisterLoaderThread(BaseClassLoader classLoader, Thread thread)
/*     */   {
/*  93 */     boolean trace = log.isTraceEnabled();
/*  94 */     if (trace) {
/*  95 */       log.trace("unregisterLoaderThread, classloader=" + classLoader + " thread=" + thread);
/*     */     }
/*     */ 
/*  98 */     synchronized (loadClassThreads)
/*     */     {
/* 100 */       loadClassThreads.remove(classLoader);
/* 101 */       loadClassThreads.notifyAll();
/*     */     }
/*     */ 
/* 105 */     List taskList = (List)loadTasksByThread.get(thread);
/* 106 */     if (taskList != null)
/*     */     {
/* 108 */       synchronized (taskList)
/*     */       {
/* 110 */         while (!taskList.isEmpty())
/*     */         {
/* 112 */           ClassLoadingTask.ThreadTask threadTask = (ClassLoadingTask.ThreadTask)taskList.remove(0);
/* 113 */           ClassLoadingTask loadTask = threadTask.getLoadTask();
/* 114 */           Thread requestingThread = loadTask.getRequestingThread();
/* 115 */           if (trace)
/* 116 */             log.trace("Reassigning task: " + threadTask + " to " + requestingThread);
/* 117 */           threadTask.setThread(null);
/*     */ 
/* 119 */           List toTaskList = (List)loadTasksByThread.get(requestingThread);
/* 120 */           synchronized (toTaskList)
/*     */           {
/* 122 */             toTaskList.add(0, threadTask);
/* 123 */             loadTask.nextEvent();
/* 124 */             toTaskList.notify();
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static Class<?> process(Thread thread, ClassLoadingTask task)
/*     */     throws ClassNotFoundException
/*     */   {
/*     */     while (true) {
/* 141 */       if (task.getThreadTaskCount() != 0)
/*     */       {
/*     */         try
/*     */         {
/* 145 */           nextTask(thread, task);
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/* 149 */           task.setLoadError(e);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 154 */     Class loadedClass = task.getLoadedClass();
/* 155 */     if (loadedClass == null)
/*     */     {
/* 157 */       Throwable loadException = task.getLoadException();
/* 158 */       if ((loadException instanceof ClassNotFoundException))
/* 159 */         throw ((ClassNotFoundException)loadException);
/* 160 */       if ((loadException instanceof NoClassDefFoundError))
/* 161 */         throw ((NoClassDefFoundError)loadException);
/* 162 */       if (loadException != null)
/*     */       {
/* 164 */         log.warn("Unexpected error during load of:" + task.getClassName(), loadException);
/* 165 */         String msg = "Unexpected error during load of: " + task.getClassName() + ", msg=" + loadException.getMessage();
/* 166 */         throw new ClassNotFoundException(msg, loadException);
/*     */       }
/*     */ 
/* 171 */       throw new ClassNotFoundException("Failed to load class " + task.getClassName());
/*     */     }
/*     */ 
/* 174 */     return loadedClass;
/*     */   }
/*     */ 
/*     */   private static void nextTask(Thread thread, ClassLoadingTask task)
/*     */     throws InterruptedException
/*     */   {
/* 186 */     boolean trace = log.isTraceEnabled();
/* 187 */     if (trace) {
/* 188 */       log.trace("Next task thread=" + thread + " task=" + task);
/*     */     }
/* 190 */     List taskList = (List)loadTasksByThread.get(thread);
/* 191 */     synchronized (taskList)
/*     */     {
/* 194 */       while ((taskList.isEmpty()) && (task.getThreadTaskCount() != 0))
/*     */       {
/* 199 */         if (trace)
/* 200 */           log.trace("Begin nextTask(WAIT_ON_EVENT), task=" + task);
/*     */         try
/*     */         {
/* 203 */           task.waitOnEvent();
/* 204 */           taskList.wait();
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/* 208 */           if (trace) {
/* 209 */             log.trace("nextTask(WAIT_ON_EVENT), interrupted, task=" + task, e);
/*     */           }
/* 211 */           throw e;
/*     */         }
/* 213 */         if (trace) {
/* 214 */           log.trace("nextTask(WAIT_ON_EVENT), notified, task=" + task);
/*     */         }
/*     */       }
/* 217 */       if (trace) {
/* 218 */         log.trace("Continue nextTask(" + taskList.size() + "), task=" + task);
/*     */       }
/*     */ 
/* 221 */       if (task.getThreadTaskCount() == 0)
/*     */       {
/* 223 */         task.finish();
/* 224 */         log.trace("End nextTask(FINISHED), task=" + task);
/* 225 */         return;
/*     */       }
/*     */     }
/*     */ 
/* 229 */     ClassLoadingTask.ThreadTask threadTask = (ClassLoadingTask.ThreadTask)taskList.remove(0);
/* 230 */     ClassLoadingTask loadTask = threadTask.getLoadTask();
/* 231 */     if (trace) {
/* 232 */       log.trace("Begin nextTask(" + taskList.size() + "), loadTask=" + loadTask);
/*     */     }
/*     */     try
/*     */     {
/* 236 */       Thread taskThread = threadTask.getThread();
/* 237 */       if (taskThread == null)
/*     */       {
/* 243 */         if (trace)
/* 244 */           log.trace("Rescheduling threadTask=" + threadTask);
/* 245 */         scheduleTask(loadTask, threadTask.getLoader(), true);
/*     */       }
/*     */       else
/*     */       {
/* 249 */         if (trace)
/* 250 */           log.trace("Running threadTask=" + threadTask);
/* 251 */         threadTask.run();
/*     */       }
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 256 */       if (trace)
/* 257 */         log.trace("Run failed with exception", e);
/* 258 */       boolean retry = ((e instanceof ClassCircularityError)) || (e.getClass().equals(LinkageError.class));
/* 259 */       if (retry)
/*     */       {
/*     */         try
/*     */         {
/* 267 */           scheduleTask(loadTask, threadTask.getLoader(), true);
/*     */         }
/*     */         catch (Throwable ex)
/*     */         {
/* 271 */           loadTask.setLoadError(ex);
/* 272 */           log.warn("Failed to reschedule task after CCE", ex);
/*     */         }
/* 274 */         if (trace)
/* 275 */           log.trace("Post CCE state, loadTask=" + loadTask);
/*     */       }
/*     */       else
/*     */       {
/* 279 */         loadTask.setLoadError(e);
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/* 285 */       if (threadTask.isReleaseInNextTask()) {
/* 286 */         threadTask.getClassLoader().unlock();
/*     */       }
/*     */     }
/*     */ 
/* 290 */     if (loadTask.getThreadTaskCount() == 0)
/*     */     {
/* 292 */       List loadTaskThreadTasks = (List)loadTasksByThread.get(loadTask.getRequestingThread());
/* 293 */       synchronized (loadTaskThreadTasks)
/*     */       {
/* 295 */         if (trace)
/* 296 */           log.trace("Notifying task of thread completion, loadTask:" + loadTask);
/* 297 */         task.finish();
/* 298 */         loadTaskThreadTasks.notify();
/*     */       }
/*     */     }
/* 301 */     if (trace)
/* 302 */       log.trace("End nextTask(" + taskList.size() + "), loadTask=" + loadTask);
/*     */   }
/*     */ 
/*     */   static void scheduleTask(ClassLoadingTask task, Loader loader, boolean reschedule)
/*     */   {
/* 315 */     boolean trace = log.isTraceEnabled();
/* 316 */     if (trace) {
/* 317 */       log.trace("ScheduleTask task=" + task + " loader=" + loader + " reschedule=" + reschedule);
/*     */     }
/*     */ 
/* 320 */     boolean releaseInNextTask = false;
/*     */ 
/* 324 */     BaseClassLoader classLoader = null;
/* 325 */     if ((loader instanceof BaseDelegateLoader))
/*     */     {
/* 327 */       BaseDelegateLoader delegateLoader = (BaseDelegateLoader)loader;
/* 328 */       BaseClassLoaderPolicy policy = delegateLoader.getPolicy();
/* 329 */       classLoader = policy.getClassLoader();
/*     */     }
/*     */ 
/* 332 */     synchronized (loadClassThreads)
/*     */     {
/*     */       Thread thread;
/* 335 */       if (classLoader == null)
/*     */       {
/* 337 */         Thread thread = task.getRequestingThread();
/* 338 */         synchronized (loadTasksByThread)
/*     */         {
/* 340 */           List list = (List)loadTasksByThread.get(thread);
/* 341 */           if (list == null)
/*     */           {
/* 343 */             list = Collections.synchronizedList(new LinkedList());
/* 344 */             loadTasksByThread.put(thread, list);
/* 345 */             if (trace)
/* 346 */               log.trace("Created new task list for " + thread);
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 352 */         thread = (Thread)loadClassThreads.get(classLoader);
/*     */       }
/*     */ 
/* 355 */       if (thread == null)
/*     */       {
/* 357 */         boolean interrupted = Thread.interrupted();
/* 358 */         int waits = 0;
/*     */         try
/*     */         {
/* 363 */           while (thread == null)
/*     */           {
/*     */             try
/*     */             {
/* 367 */               boolean gotLock = classLoader.attemptLock();
/* 368 */               if (!gotLock)
/*     */               {
/* 371 */                 if (waits++ == 12) {
/* 372 */                   throw new IllegalStateException("Waiting too long to get the registration lock for classLoader " + classLoader);
/*     */                 }
/* 374 */                 if (trace)
/* 375 */                   log.trace(classLoader + " waiting for lock");
/* 376 */                 loadClassThreads.wait(10000L);
/*     */               }
/*     */               else
/*     */               {
/* 380 */                 releaseInNextTask = true;
/*     */               }
/*     */             }
/*     */             catch (InterruptedException ignored)
/*     */             {
/*     */             }
/* 386 */             thread = (Thread)loadClassThreads.get(classLoader);
/*     */           }
/*     */         }
/*     */         finally
/*     */         {
/* 391 */           if (interrupted) {
/* 392 */             Thread.currentThread().interrupt();
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 397 */       ClassLoadingTask.ThreadTask subtask = task.newThreadTask(loader, thread, reschedule, releaseInNextTask);
/*     */ 
/* 399 */       List taskList = (List)loadTasksByThread.get(thread);
/* 400 */       synchronized (taskList)
/*     */       {
/* 402 */         taskList.add(subtask);
/* 403 */         taskList.notify();
/* 404 */         if (trace)
/* 405 */           log.trace("scheduleTask(" + taskList.size() + "), created subtask: " + subtask);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.spi.base.ClassLoaderManager
 * JD-Core Version:    0.6.0
 */