/*     */ package org.jboss.classloader.spi.base;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import java.util.concurrent.CopyOnWriteArraySet;
/*     */ import org.jboss.classloader.spi.DelegateLoader;
/*     */ import org.jboss.classloader.spi.Loader;
/*     */ 
/*     */ public class ClassLoaderInformation
/*     */ {
/*     */   private BaseClassLoader classLoader;
/*     */   private BaseClassLoaderPolicy policy;
/*     */   private int order;
/*     */   private List<? extends DelegateLoader> delegates;
/*     */   private BaseDelegateLoader exported;
/*     */   private Map<String, Loader> classCache;
/*     */   private Set<String> classBlackList;
/*     */   private Map<String, URL> resourceCache;
/*     */   private Set<String> resourceBlackList;
/*     */ 
/*     */   public ClassLoaderInformation(BaseClassLoader classLoader, BaseClassLoaderPolicy policy, int order)
/*     */   {
/*  79 */     if (classLoader == null)
/*  80 */       throw new IllegalArgumentException("Null classloader");
/*  81 */     if (policy == null)
/*  82 */       throw new IllegalArgumentException("Null policy");
/*  83 */     this.classLoader = classLoader;
/*  84 */     this.policy = policy;
/*  85 */     this.order = order;
/*  86 */     this.exported = policy.getExported();
/*  87 */     this.delegates = policy.getDelegates();
/*     */ 
/*  89 */     boolean canCache = policy.isCachable();
/*  90 */     boolean canBlackList = policy.isBlackListable();
/*  91 */     if ((this.delegates != null) && (!this.delegates.isEmpty()))
/*     */     {
/*  93 */       for (DelegateLoader delegate : this.delegates)
/*     */       {
/*  95 */         BaseDelegateLoader baseDelegate = delegate;
/*  96 */         BaseClassLoaderPolicy delegatePolicy = baseDelegate.getPolicy();
/*  97 */         if (!delegatePolicy.isCachable())
/*  98 */           canCache = false;
/*  99 */         if (!delegatePolicy.isBlackListable()) {
/* 100 */           canBlackList = false;
/*     */         }
/*     */       }
/*     */     }
/* 104 */     if (canCache)
/*     */     {
/* 106 */       this.classCache = new ConcurrentHashMap();
/* 107 */       this.resourceCache = new ConcurrentHashMap();
/*     */     }
/*     */ 
/* 110 */     if (canBlackList)
/*     */     {
/* 112 */       this.classBlackList = new CopyOnWriteArraySet();
/* 113 */       this.resourceBlackList = new CopyOnWriteArraySet();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void flushCaches()
/*     */   {
/* 122 */     if (this.classCache != null)
/* 123 */       this.classCache.clear();
/* 124 */     if (this.classBlackList != null)
/* 125 */       this.classBlackList.clear();
/* 126 */     if (this.resourceCache != null)
/* 127 */       this.resourceCache.clear();
/* 128 */     if (this.resourceBlackList != null)
/* 129 */       this.resourceBlackList.clear();
/*     */   }
/*     */ 
/*     */   public BaseClassLoader getClassLoader()
/*     */   {
/* 139 */     return this.classLoader;
/*     */   }
/*     */ 
/*     */   public BaseClassLoaderPolicy getPolicy()
/*     */   {
/* 149 */     return this.policy;
/*     */   }
/*     */ 
/*     */   public int getOrder()
/*     */   {
/* 159 */     return this.order;
/*     */   }
/*     */ 
/*     */   public BaseDelegateLoader getExported()
/*     */   {
/* 169 */     return this.exported;
/*     */   }
/*     */ 
/*     */   public List<? extends DelegateLoader> getDelegates()
/*     */   {
/* 179 */     return this.delegates;
/*     */   }
/*     */ 
/*     */   public Loader getCachedLoader(String name)
/*     */   {
/* 190 */     if (this.classCache != null)
/* 191 */       return (Loader)this.classCache.get(name);
/* 192 */     return null;
/*     */   }
/*     */ 
/*     */   public void cacheLoader(String name, Loader loader)
/*     */   {
/* 203 */     if (this.classCache != null)
/* 204 */       this.classCache.put(name, loader);
/*     */   }
/*     */ 
/*     */   public boolean isBlackListedClass(String name)
/*     */   {
/* 215 */     if (this.classBlackList != null)
/* 216 */       return this.classBlackList.contains(name);
/* 217 */     return false;
/*     */   }
/*     */ 
/*     */   public void blackListClass(String name)
/*     */   {
/* 227 */     if (this.classBlackList != null)
/* 228 */       this.classBlackList.add(name);
/*     */   }
/*     */ 
/*     */   public URL getCachedResource(String name)
/*     */   {
/* 239 */     if (this.resourceCache != null)
/* 240 */       return (URL)this.resourceCache.get(name);
/* 241 */     return null;
/*     */   }
/*     */ 
/*     */   public void cacheResource(String name, URL url)
/*     */   {
/* 252 */     if (this.resourceCache != null)
/* 253 */       this.resourceCache.put(name, url);
/*     */   }
/*     */ 
/*     */   public boolean isBlackListedResource(String name)
/*     */   {
/* 264 */     if (this.resourceBlackList != null)
/* 265 */       return this.resourceBlackList.contains(name);
/* 266 */     return false;
/*     */   }
/*     */ 
/*     */   public void blackListResource(String name)
/*     */   {
/* 276 */     if (this.resourceBlackList != null)
/* 277 */       this.resourceBlackList.add(name);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 283 */     return this.policy.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.spi.base.ClassLoaderInformation
 * JD-Core Version:    0.6.0
 */