/*     */ package org.jboss.classloader.spi.base;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.ProtectionDomain;
/*     */ import org.jboss.classloader.spi.ClassLoaderPolicy;
/*     */ 
/*     */ public abstract class BaseClassLoaderSystem
/*     */ {
/*     */   public String toLongString()
/*     */   {
/*  45 */     StringBuilder builder = new StringBuilder();
/*  46 */     builder.append(getClass().getSimpleName());
/*  47 */     builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
/*  48 */     builder.append("{");
/*  49 */     toLongString(builder);
/*  50 */     builder.append('}');
/*  51 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   protected void toLongString(StringBuilder builder)
/*     */   {
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  66 */     StringBuilder builder = new StringBuilder();
/*  67 */     builder.append(getClass().getSimpleName());
/*  68 */     builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
/*  69 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   protected void registerDomain(BaseClassLoaderDomain domain)
/*     */   {
/*  80 */     if (domain == null)
/*  81 */       throw new IllegalArgumentException("Null domain");
/*  82 */     domain.setClassLoaderSystem(this);
/*     */   }
/*     */ 
/*     */   protected void unregisterDomain(BaseClassLoaderDomain domain)
/*     */   {
/*  93 */     if (domain == null)
/*  94 */       throw new IllegalArgumentException("Null domain");
/*  95 */     domain.setClassLoaderSystem(null);
/*     */   }
/*     */ 
/*     */   protected ClassLoader registerClassLoaderPolicy(BaseClassLoaderDomain domain, ClassLoaderPolicy policy)
/*     */   {
/* 109 */     if (domain == null)
/* 110 */       throw new IllegalArgumentException("Null domain");
/* 111 */     if (policy == null) {
/* 112 */       throw new IllegalArgumentException("Null policy");
/*     */     }
/* 114 */     return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(policy, domain)
/*     */     {
/*     */       public BaseClassLoader run()
/*     */       {
/* 118 */         BaseClassLoader classLoader = BaseClassLoaderSystem.this.createClassLoader(this.val$policy);
/* 119 */         BaseClassLoaderSystem.this.beforeRegisterClassLoader(classLoader);
/* 120 */         this.val$domain.registerClassLoader(classLoader);
/* 121 */         BaseClassLoaderSystem.this.afterRegisterClassLoader(classLoader);
/* 122 */         return classLoader;
/*     */       }
/*     */     }
/*     */     , policy.getAccessControlContext());
/*     */   }
/*     */ 
/*     */   protected void unregisterClassLoaderPolicy(ClassLoaderPolicy policy)
/*     */   {
/* 136 */     if (policy == null) {
/* 137 */       throw new IllegalArgumentException("Null policy");
/*     */     }
/* 139 */     BaseClassLoaderPolicy basePolicy = policy;
/* 140 */     BaseClassLoader classLoader = basePolicy.getClassLoader();
/* 141 */     if (classLoader == null)
/* 142 */       throw new IllegalStateException("Policy has no associated classloader, it is therefore not registered with a domain. " + policy.toLongString());
/* 143 */     BaseClassLoaderDomain domain = basePolicy.getClassLoaderDomain();
/* 144 */     if (domain == null)
/* 145 */       throw new IllegalStateException("Policy has no domain " + policy.toLongString());
/* 146 */     beforeUnregisterClassLoader(classLoader);
/* 147 */     domain.unregisterClassLoader(classLoader);
/* 148 */     afterUnregisterClassLoader(classLoader);
/*     */   }
/*     */ 
/*     */   protected void unregisterClassLoader(ClassLoader classLoader)
/*     */   {
/* 160 */     if (classLoader == null) {
/* 161 */       throw new IllegalArgumentException("Null classLoader");
/*     */     }
/* 163 */     if (!(classLoader instanceof BaseClassLoader)) {
/* 164 */       throw new IllegalStateException("ClassLoader is not the correct type and therefore not registered: " + classLoader);
/*     */     }
/* 166 */     BaseClassLoader baseClassLoader = (BaseClassLoader)classLoader;
/* 167 */     unregisterClassLoaderPolicy(baseClassLoader.getPolicy());
/*     */   }
/*     */ 
/*     */   protected BaseClassLoader createClassLoader(ClassLoaderPolicy policy)
/*     */   {
/* 179 */     return new BaseClassLoader(policy);
/*     */   }
/*     */ 
/*     */   protected void beforeRegisterClassLoader(ClassLoader classLoader)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void afterRegisterClassLoader(ClassLoader classLoader)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void beforeUnregisterClassLoader(ClassLoader classLoader)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void afterUnregisterClassLoader(ClassLoader classLoader)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected byte[] transform(ClassLoader classLoader, String className, byte[] byteCode, ProtectionDomain protectionDomain)
/*     */     throws Exception
/*     */   {
/* 236 */     return byteCode;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.spi.base.BaseClassLoaderSystem
 * JD-Core Version:    0.6.0
 */