/*     */ package org.jboss.classloader.spi;
/*     */ 
/*     */ import org.jboss.classloader.spi.filter.ClassFilter;
/*     */ 
/*     */ public class ParentPolicy
/*     */ {
/*  35 */   public static final ParentPolicy BEFORE = new ParentPolicy(ClassFilter.EVERYTHING, ClassFilter.NOTHING, "BEFORE");
/*     */ 
/*  38 */   public static final ParentPolicy AFTER = new ParentPolicy(ClassFilter.NOTHING_BUT_JAVA, ClassFilter.EVERYTHING, "AFTER");
/*     */ 
/*  41 */   public static final ParentPolicy BEFORE_BUT_JAVA_ONLY = new ParentPolicy(ClassFilter.JAVA_ONLY, ClassFilter.NOTHING, "BEFORE_BUT_JAVA_ONLY");
/*     */ 
/*  44 */   public static final ParentPolicy AFTER_BUT_JAVA_BEFORE = new ParentPolicy(ClassFilter.JAVA_ONLY, ClassFilter.EVERYTHING, "AFTER_BUT_JAVA_BEFORE");
/*     */   private ClassFilter beforeFilter;
/*     */   private ClassFilter afterFilter;
/*     */   private String description;
/*     */ 
/*     */   public ParentPolicy(ClassFilter beforeFilter, ClassFilter afterFilter)
/*     */   {
/*  64 */     this(beforeFilter, afterFilter, null);
/*     */   }
/*     */ 
/*     */   public ParentPolicy(ClassFilter beforeFilter, ClassFilter afterFilter, String description)
/*     */   {
/*  77 */     if (beforeFilter == null)
/*  78 */       throw new IllegalArgumentException("Null beforeFilter");
/*  79 */     if (afterFilter == null) {
/*  80 */       throw new IllegalArgumentException("Null afterFilter");
/*     */     }
/*  82 */     this.beforeFilter = beforeFilter;
/*  83 */     this.afterFilter = afterFilter;
/*  84 */     this.description = description;
/*  85 */     if (description == null)
/*  86 */       this.description = ("(before=" + beforeFilter + " after=" + afterFilter + ")");
/*     */   }
/*     */ 
/*     */   public ClassFilter getBeforeFilter()
/*     */   {
/*  96 */     return this.beforeFilter;
/*     */   }
/*     */ 
/*     */   public ClassFilter getAfterFilter()
/*     */   {
/* 106 */     return this.afterFilter;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 112 */     return this.description;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.spi.ParentPolicy
 * JD-Core Version:    0.6.0
 */