/*    */ package org.jboss.classadapter.plugins;
/*    */ 
/*    */ import org.jboss.classadapter.spi.ClassAdapter;
/*    */ import org.jboss.classadapter.spi.ClassAdapterFactory;
/*    */ import org.jboss.config.spi.Configuration;
/*    */ import org.jboss.reflect.spi.ClassInfo;
/*    */ import org.jboss.reflect.spi.TypeInfo;
/*    */ import org.jboss.reflect.spi.TypeInfoFactory;
/*    */ 
/*    */ public class BasicClassAdapterFactory
/*    */   implements ClassAdapterFactory
/*    */ {
/*    */   protected Configuration configuration;
/*    */ 
/*    */   public Configuration getConfiguration()
/*    */   {
/* 43 */     return this.configuration;
/*    */   }
/*    */ 
/*    */   public void setConfiguration(Configuration configuration)
/*    */   {
/* 48 */     this.configuration = configuration;
/*    */   }
/*    */ 
/*    */   public ClassAdapter getClassAdapter(Class clazz)
/*    */   {
/* 53 */     TypeInfoFactory typeInfoFactory = this.configuration.getTypeInfoFactory();
/* 54 */     TypeInfo typeInfo = typeInfoFactory.getTypeInfo(clazz);
/* 55 */     return getClassAdapter(typeInfo);
/*    */   }
/*    */ 
/*    */   public ClassAdapter getClassAdapter(String name, ClassLoader cl) throws ClassNotFoundException
/*    */   {
/* 60 */     TypeInfoFactory typeInfoFactory = this.configuration.getTypeInfoFactory();
/* 61 */     TypeInfo typeInfo = typeInfoFactory.getTypeInfo(name, cl);
/* 62 */     return getClassAdapter(typeInfo);
/*    */   }
/*    */ 
/*    */   public ClassAdapter getClassAdapter(TypeInfo typeInfo)
/*    */   {
/* 67 */     if (!(typeInfo instanceof ClassInfo))
/* 68 */       throw new IllegalArgumentException("Not a class " + typeInfo.getName());
/* 69 */     ClassInfo classInfo = (ClassInfo)typeInfo;
/*    */ 
/* 71 */     return new BasicClassAdapter(this, classInfo);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classadapter.plugins.BasicClassAdapterFactory
 * JD-Core Version:    0.6.0
 */