/*     */ package org.jboss.cache.invalidation.triggers;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.cache.invalidation.InvalidationGroup;
/*     */ import org.jboss.cache.invalidation.InvalidationManagerMBean;
/*     */ import org.jboss.cache.invalidation.InvalidationsTxGrouper;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.EntityPersistenceManager;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.ejb.plugins.AbstractInterceptor;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.CacheInvalidationConfigMetaData;
/*     */ import org.jboss.metadata.EntityMetaData;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.metadata.XmlLoadable;
/*     */ import org.jboss.system.Registry;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class EntityBeanCacheBatchInvalidatorInterceptor extends AbstractInterceptor
/*     */   implements XmlLoadable
/*     */ {
/*  42 */   protected boolean doCacheInvalidations = true;
/*  43 */   protected InvalidationManagerMBean invalMgr = null;
/*  44 */   protected InvalidationGroup ig = null;
/*  45 */   protected EntityContainer container = null;
/*     */   public boolean invalidateRelated;
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*  50 */     EntityMetaData emd = (EntityMetaData)getContainer().getBeanMetaData();
/*  51 */     this.doCacheInvalidations = emd.doDistributedCacheInvalidations();
/*     */ 
/*  53 */     if (this.doCacheInvalidations)
/*     */     {
/*  57 */       String groupName = emd.getDistributedCacheInvalidationConfig().getInvalidationGroupName();
/*  58 */       String imName = emd.getDistributedCacheInvalidationConfig().getInvalidationManagerName();
/*     */ 
/*  60 */       this.invalMgr = ((InvalidationManagerMBean)Registry.lookup(imName));
/*  61 */       this.ig = this.invalMgr.getInvalidationGroup(groupName);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*  67 */     this.invalMgr = null;
/*     */ 
/*  69 */     if (this.ig != null)
/*     */     {
/*  71 */       this.ig.removeReference();
/*  72 */       this.ig = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean changed(Invocation mi, EntityEnterpriseContext ctx)
/*     */     throws Exception
/*     */   {
/*  80 */     if (ctx.getId() == null) return true;
/*     */ 
/*  82 */     if (!this.container.isReadOnly())
/*     */     {
/*  84 */       Method method = mi.getMethod();
/*  85 */       if ((method == null) || (!this.container.getBeanMetaData().isMethodReadOnly(method.getName())))
/*     */       {
/*  88 */         return this.invalidateRelated ? this.container.getPersistenceManager().isModified(ctx) : this.container.getPersistenceManager().isStoreRequired(ctx);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  93 */     return false;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi) throws Exception
/*     */   {
/*  98 */     if (this.doCacheInvalidations)
/*     */     {
/* 101 */       EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
/* 102 */       Object id = ctx.getId();
/*     */ 
/* 105 */       Transaction tx = mi.getTransaction();
/*     */ 
/* 108 */       if ((tx != null) && (tx.getStatus() != 6))
/*     */       {
/* 111 */         Object retVal = getNext().invoke(mi);
/*     */ 
/* 113 */         if (changed(mi, ctx))
/*     */         {
/* 115 */           InvalidationsTxGrouper.registerInvalidationSynchronization(tx, this.ig, (Serializable)id);
/*     */         }
/*     */ 
/* 119 */         return retVal;
/*     */       }
/*     */ 
/* 124 */       Object result = getNext().invoke(mi);
/*     */ 
/* 126 */       if (changed(mi, ctx))
/*     */       {
/* 128 */         InvalidationsTxGrouper.registerInvalidationSynchronization(tx, this.ig, (Serializable)id);
/*     */       }
/* 130 */       return result;
/*     */     }
/*     */ 
/* 135 */     return getNext().invoke(mi);
/*     */   }
/*     */ 
/*     */   public void setContainer(Container container) {
/* 139 */     this.container = ((EntityContainer)container);
/*     */   }
/* 141 */   public Container getContainer() { return this.container;
/*     */   }
/*     */ 
/*     */   public void importXml(Element element)
/*     */     throws Exception
/*     */   {
/* 147 */     String str = MetaData.getElementAttribute(element, "invalidate-related");
/* 148 */     this.invalidateRelated = (str == null ? true : Boolean.valueOf(str).booleanValue());
/* 149 */     if (this.log.isTraceEnabled())
/*     */     {
/* 151 */       this.log.trace("invalidate-related: " + this.invalidateRelated);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.cache.invalidation.triggers.EntityBeanCacheBatchInvalidatorInterceptor
 * JD-Core Version:    0.6.0
 */