/*     */ package org.jboss.cache.invalidation.bridges;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.rmi.dgc.VMID;
/*     */ import java.util.Properties;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.Message;
/*     */ import javax.jms.MessageListener;
/*     */ import javax.jms.ObjectMessage;
/*     */ import javax.jms.Topic;
/*     */ import javax.jms.TopicConnection;
/*     */ import javax.jms.TopicConnectionFactory;
/*     */ import javax.jms.TopicPublisher;
/*     */ import javax.jms.TopicSession;
/*     */ import javax.jms.TopicSubscriber;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.cache.invalidation.BatchInvalidation;
/*     */ import org.jboss.cache.invalidation.BridgeInvalidationSubscription;
/*     */ import org.jboss.cache.invalidation.InvalidationBridgeListener;
/*     */ import org.jboss.cache.invalidation.InvalidationManagerMBean;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class JMSCacheInvalidationBridge extends ServiceMBeanSupport
/*     */   implements JMSCacheInvalidationBridgeMBean, InvalidationBridgeListener, MessageListener
/*     */ {
/*     */   public static final String JMS_CACHE_INVALIDATION_BRIDGE = "JMS_CACHE_INVALIDATION_BRIDGE";
/*  78 */   protected InvalidationManagerMBean invalMgr = null;
/*  79 */   protected BridgeInvalidationSubscription invalidationSubscription = null;
/*  80 */   protected String invalidationManagerName = "jboss.cache:service=InvalidationManager";
/*     */ 
/*  82 */   protected boolean publishingAuthorized = false;
/*  83 */   protected String connectionFactoryName = "java:/ConnectionFactory";
/*  84 */   protected String topicName = "topic/JMSCacheInvalidationBridge";
/*  85 */   protected boolean transacted = true;
/*  86 */   protected int acknowledgeMode = 1;
/*  87 */   protected int propagationMode = 1;
/*     */ 
/*  89 */   protected VMID serviceId = new VMID();
/*     */ 
/*  91 */   protected TopicConnection conn = null;
/*  92 */   protected TopicSession session = null;
/*  93 */   protected Topic topic = null;
/*  94 */   protected TopicSubscriber subscriber = null;
/*  95 */   protected TopicPublisher pub = null;
/*     */ 
/*  97 */   protected String providerUrl = null;
/*     */ 
/*     */   public String getInvalidationManager()
/*     */   {
/* 111 */     return this.invalidationManagerName;
/*     */   }
/*     */ 
/*     */   public void setInvalidationManager(String objectName)
/*     */   {
/* 116 */     this.invalidationManagerName = objectName;
/*     */   }
/*     */ 
/*     */   public String getConnectionFactoryName()
/*     */   {
/* 121 */     return this.connectionFactoryName;
/*     */   }
/*     */ 
/*     */   public void setConnectionFactoryName(String factoryName) {
/* 125 */     this.connectionFactoryName = factoryName;
/*     */   }
/*     */ 
/*     */   public String getTopicName()
/*     */   {
/* 130 */     return this.topicName;
/*     */   }
/*     */ 
/*     */   public void setTopicName(String topicName) {
/* 134 */     this.topicName = topicName;
/*     */   }
/*     */ 
/*     */   public String getProviderUrl()
/*     */   {
/* 139 */     return this.providerUrl;
/*     */   }
/*     */ 
/*     */   public void setProviderUrl(String providerUrl)
/*     */   {
/* 144 */     this.providerUrl = providerUrl;
/*     */   }
/*     */ 
/*     */   public boolean isTransacted()
/*     */   {
/* 149 */     return this.transacted;
/*     */   }
/*     */ 
/*     */   public void setTransacted(boolean isTransacted) {
/* 153 */     this.transacted = isTransacted;
/*     */   }
/*     */ 
/*     */   public int getAcknowledgeMode()
/*     */   {
/* 158 */     return this.acknowledgeMode;
/*     */   }
/*     */ 
/*     */   public void setAcknowledgeMode(int ackMode) {
/* 162 */     if ((ackMode > 3) || (ackMode < 1)) {
/* 163 */       throw new RuntimeException("Value AcknowledgeMode must be between 1 and 3");
/*     */     }
/* 165 */     switch (ackMode) {
/*     */     case 1:
/* 167 */       this.acknowledgeMode = 1; break;
/*     */     case 2:
/* 168 */       this.acknowledgeMode = 2; break;
/*     */     case 3:
/* 169 */       this.acknowledgeMode = 3;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getPropagationMode()
/*     */   {
/* 175 */     return this.propagationMode;
/*     */   }
/*     */ 
/*     */   public void setPropagationMode(int propMode) {
/* 179 */     if ((propMode > 3) || (propMode < 1)) {
/* 180 */       throw new RuntimeException("Value PropagationMode must be between 1 and 3");
/*     */     }
/* 182 */     this.propagationMode = propMode;
/*     */   }
/*     */ 
/*     */   public void onMessage(Message msg)
/*     */   {
/* 191 */     if ((this.propagationMode == 1) || (this.propagationMode == 2))
/*     */     {
/*     */       try
/*     */       {
/* 196 */         ObjectMessage objmsg = (ObjectMessage)msg;
/* 197 */         if (!objmsg.getJMSType().equals("JMS_CACHE_INVALIDATION_BRIDGE")) return;
/* 198 */         JMSCacheInvalidationMessage content = (JMSCacheInvalidationMessage)objmsg.getObject();
/*     */ 
/* 203 */         if (!content.emitter.equals(this.serviceId))
/*     */         {
/* 205 */           if (content.invalidateAllGroupName != null)
/*     */           {
/* 207 */             this.invalidationSubscription.invalidateAll(content.invalidateAllGroupName);
/*     */           }
/*     */           else
/*     */           {
/* 211 */             this.invalidationSubscription.batchInvalidate(content.getInvalidations());
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 217 */         this.log.warn(ex.getMessage());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void batchInvalidate(BatchInvalidation[] invalidations, boolean asynchronous)
/*     */   {
/* 226 */     if (((this.propagationMode == 1) || (this.propagationMode == 3)) && (this.publishingAuthorized))
/*     */     {
/* 230 */       JMSCacheInvalidationMessage msg = new JMSCacheInvalidationMessage(this.serviceId, invalidations);
/* 231 */       sendJMSInvalidationEvent(msg);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void invalidate(String invalidationGroupName, Serializable[] keys, boolean asynchronous)
/*     */   {
/* 237 */     if (((this.propagationMode == 1) || (this.propagationMode == 3)) && (this.publishingAuthorized))
/*     */     {
/* 241 */       JMSCacheInvalidationMessage msg = new JMSCacheInvalidationMessage(this.serviceId, invalidationGroupName, keys);
/*     */ 
/* 245 */       sendJMSInvalidationEvent(msg);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void invalidate(String invalidationGroupName, Serializable key, boolean asynchronous)
/*     */   {
/* 251 */     if (((this.propagationMode == 1) || (this.propagationMode == 3)) && (this.publishingAuthorized))
/*     */     {
/* 255 */       JMSCacheInvalidationMessage msg = new JMSCacheInvalidationMessage(this.serviceId, invalidationGroupName, new Serializable[] { key });
/*     */ 
/* 259 */       sendJMSInvalidationEvent(msg);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void invalidateAll(String groupName, boolean asynchronous)
/*     */   {
/* 265 */     if (((this.propagationMode == 1) || (this.propagationMode == 3)) && (this.publishingAuthorized))
/*     */     {
/* 269 */       JMSCacheInvalidationMessage msg = new JMSCacheInvalidationMessage(this.serviceId, groupName);
/*     */ 
/* 273 */       sendJMSInvalidationEvent(msg);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void newGroupCreated(String groupInvalidationName)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void groupIsDropped(String groupInvalidationName)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 293 */     this.log.info("Starting JMS cache invalidation bridge");
/*     */ 
/* 297 */     this.invalMgr = ((InvalidationManagerMBean)Registry.lookup(this.invalidationManagerName));
/*     */ 
/* 300 */     this.invalidationSubscription = this.invalMgr.registerBridgeListener(this);
/*     */ 
/* 304 */     InitialContext iniCtx = getInitialContext();
/*     */ 
/* 306 */     Object tmp = iniCtx.lookup(this.connectionFactoryName);
/* 307 */     TopicConnectionFactory tcf = (TopicConnectionFactory)tmp;
/* 308 */     this.conn = tcf.createTopicConnection();
/*     */ 
/* 310 */     this.topic = ((Topic)iniCtx.lookup(this.topicName));
/* 311 */     this.session = this.conn.createTopicSession(this.transacted, this.acknowledgeMode);
/*     */ 
/* 314 */     this.conn.start();
/*     */ 
/* 318 */     if ((this.propagationMode == 1) || (this.propagationMode == 2))
/*     */     {
/* 321 */       this.subscriber = this.session.createSubscriber(this.topic);
/* 322 */       this.subscriber.setMessageListener(this);
/*     */     }
/*     */ 
/* 325 */     if ((this.propagationMode == 1) || (this.propagationMode == 3))
/*     */     {
/* 328 */       this.pub = this.session.createPublisher(this.topic);
/* 329 */       this.publishingAuthorized = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */   {
/* 335 */     this.log.info("Stoping JMS cache invalidation bridge");
/*     */     try
/*     */     {
/* 338 */       if ((this.propagationMode == 1) || (this.propagationMode == 2))
/*     */       {
/* 341 */         this.subscriber.close();
/*     */       }
/*     */ 
/* 344 */       if ((this.propagationMode == 1) || (this.propagationMode == 3))
/*     */       {
/* 347 */         this.publishingAuthorized = false;
/* 348 */         this.pub.close();
/*     */       }
/*     */ 
/* 351 */       this.conn.stop();
/* 352 */       this.session.close();
/* 353 */       this.conn.close();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 358 */       this.log.warn("Failed to stop JMS resources associated with the JMS bridge: ", ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected synchronized TopicSession getSession()
/*     */   {
/* 368 */     return this.session;
/*     */   }
/*     */ 
/*     */   protected synchronized TopicPublisher getPublisher()
/*     */   {
/* 373 */     return this.pub;
/*     */   }
/*     */ 
/*     */   protected void sendJMSInvalidationEvent(JMSCacheInvalidationMessage invalidationMsg)
/*     */   {
/*     */     try
/*     */     {
/* 380 */       if (this.log.isTraceEnabled()) {
/* 381 */         this.log.trace("sending JMS message for cache invalidation" + invalidationMsg);
/*     */       }
/*     */       try
/*     */       {
/* 385 */         ObjectMessage msg = getSession().createObjectMessage();
/* 386 */         msg.setJMSType("JMS_CACHE_INVALIDATION_BRIDGE");
/* 387 */         msg.setObject(invalidationMsg);
/* 388 */         getPublisher().publish(msg);
/*     */       }
/*     */       catch (JMSException ex)
/*     */       {
/* 392 */         this.log.debug("failed to publish seppuku event: ", ex);
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 397 */       this.log.warn("failed to do cluster seppuku event: ", ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected InitialContext getInitialContext()
/*     */     throws NamingException
/*     */   {
/* 404 */     if (this.providerUrl == null)
/*     */     {
/* 406 */       return new InitialContext();
/*     */     }
/*     */ 
/* 410 */     this.log.debug("Using Context.PROVIDER_URL: " + this.providerUrl);
/*     */ 
/* 412 */     Properties props = new Properties(System.getProperties());
/* 413 */     props.put("java.naming.provider.url", this.providerUrl);
/* 414 */     return new InitialContext(props);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.cache.invalidation.bridges.JMSCacheInvalidationBridge
 * JD-Core Version:    0.6.0
 */