/*     */ package org.jboss.cache.invalidation;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ class InvalidatorSynchronization
/*     */   implements Synchronization
/*     */ {
/*     */   protected Transaction tx;
/* 106 */   protected HashMap ids = new HashMap();
/*     */ 
/*     */   InvalidatorSynchronization(Transaction tx)
/*     */   {
/* 113 */     this.tx = tx;
/*     */   }
/*     */ 
/*     */   public void addInvalidation(InvalidationGroup group, Serializable key)
/*     */   {
/* 118 */     InvalidationManagerMBean im = group.getInvalidationManager();
/*     */     Map relatedInvalidationMgr;
/* 124 */     synchronized (this.ids)
/*     */     {
/* 126 */       relatedInvalidationMgr = (HashMap)this.ids.get(im);
/* 127 */       if (relatedInvalidationMgr == null)
/*     */       {
/* 129 */         relatedInvalidationMgr = new HashMap();
/* 130 */         this.ids.put(im, relatedInvalidationMgr);
/*     */       }
/*     */     }
/*     */     Set relatedInvalidations;
/* 135 */     synchronized (relatedInvalidationMgr)
/*     */     {
/* 137 */       relatedInvalidations = (HashSet)relatedInvalidationMgr.get(group);
/* 138 */       if (relatedInvalidations == null)
/*     */       {
/* 140 */         relatedInvalidations = new HashSet();
/* 141 */         relatedInvalidationMgr.put(group, relatedInvalidations);
/*     */       }
/*     */     }
/*     */ 
/* 145 */     relatedInvalidations.add(key);
/*     */   }
/*     */ 
/*     */   public void beforeCompletion()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void afterCompletion(int status)
/*     */   {
/* 160 */     ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
/* 161 */     Thread.currentThread().setContextClassLoader(getClass().getClassLoader());
/*     */     try
/*     */     {
/*     */       try
/*     */       {
/* 167 */         sendBatchInvalidations();
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 171 */         InvalidationsTxGrouper.log.warn("Failed sending invalidations messages", ex);
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 176 */       Thread.currentThread().setContextClassLoader(oldCl);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void sendBatchInvalidations()
/*     */   {
/* 182 */     boolean trace = InvalidationsTxGrouper.log.isTraceEnabled();
/* 183 */     if (trace)
/*     */     {
/* 185 */       InvalidationsTxGrouper.log.trace("Begin sendBatchInvalidations, tx=" + this.tx);
/*     */     }
/*     */ 
/* 189 */     Iterator imIter = this.ids.keySet().iterator();
/* 190 */     while (imIter.hasNext())
/*     */     {
/* 192 */       InvalidationManagerMBean im = (InvalidationManagerMBean)imIter.next();
/*     */ 
/* 196 */       HashMap relatedInvalidationMgr = (HashMap)this.ids.get(im);
/*     */ 
/* 198 */       BatchInvalidation[] bomb = new BatchInvalidation[relatedInvalidationMgr.size()];
/*     */ 
/* 200 */       Iterator groupsIter = relatedInvalidationMgr.keySet().iterator();
/* 201 */       int i = 0;
/* 202 */       while (groupsIter.hasNext())
/*     */       {
/* 204 */         InvalidationGroup group = (InvalidationGroup)groupsIter.next();
/* 205 */         HashSet sourceIds = (HashSet)relatedInvalidationMgr.get(group);
/* 206 */         String groupName = group.getGroupName();
/* 207 */         if (trace)
/*     */         {
/* 209 */           InvalidationsTxGrouper.log.trace("Adding ids to bomb(" + groupName + "): " + sourceIds);
/*     */         }
/* 211 */         Serializable[] ids = new Serializable[sourceIds.size()];
/* 212 */         sourceIds.toArray(ids);
/* 213 */         BatchInvalidation batch = new BatchInvalidation(ids, groupName);
/*     */ 
/* 215 */         bomb[i] = batch;
/*     */ 
/* 217 */         i++;
/*     */       }
/*     */ 
/* 222 */       im.batchInvalidate(bomb);
/*     */     }
/* 224 */     if (trace)
/*     */     {
/* 226 */       InvalidationsTxGrouper.log.trace("End sendBatchInvalidations, tx=" + this.tx);
/*     */     }
/*     */ 
/* 231 */     this.ids = null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.cache.invalidation.InvalidatorSynchronization
 * JD-Core Version:    0.6.0
 */