/*     */ package org.jboss.bootstrap;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.PrintStream;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.URL;
/*     */ import java.util.Date;
/*     */ import java.util.List;
/*     */ import java.util.Properties;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import java.util.logging.LogManager;
/*     */ import javax.management.Notification;
/*     */ import javax.management.NotificationBroadcasterSupport;
/*     */ import javax.management.NotificationEmitter;
/*     */ import org.jboss.Version;
/*     */ import org.jboss.bootstrap.spi.Bootstrap;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.net.protocol.URLStreamHandlerFactory;
/*     */ import org.jboss.system.NoAnnotationURLClassLoader;
/*     */ import org.jboss.system.server.Server;
/*     */ import org.jboss.system.server.ServerConfig;
/*     */ import org.jboss.util.StopWatch;
/*     */ 
/*     */ public abstract class AbstractServerImpl extends NotificationBroadcasterSupport
/*     */   implements Server, NotificationEmitter
/*     */ {
/*     */   protected Logger log;
/*  62 */   private final Version version = Version.getInstance();
/*     */ 
/*  65 */   private final Package jbossPackage = Package.getPackage("org.jboss");
/*     */   private BaseServerConfig config;
/*     */   private Date startDate;
/*     */   private boolean started;
/*     */   private boolean isInStart;
/*     */   private boolean isInShutdown;
/*     */   private boolean isInternalShutdown;
/*     */   private ShutdownHook shutdownHook;
/*     */   private LifeThread lifeThread;
/*  92 */   private List<Bootstrap> bootstraps = new CopyOnWriteArrayList();
/*     */ 
/*  95 */   private List<Bootstrap> startedBootstraps = new CopyOnWriteArrayList();
/*     */ 
/*     */   public void addBootstrap(Bootstrap bootstrap)
/*     */   {
/* 112 */     if (bootstrap == null) {
/* 113 */       throw new IllegalArgumentException("Null bootstrap");
/*     */     }
/* 115 */     this.bootstraps.add(bootstrap);
/*     */   }
/*     */ 
/*     */   public void removeBootstrap(Bootstrap bootstrap)
/*     */   {
/* 126 */     if (bootstrap == null) {
/* 127 */       throw new IllegalArgumentException("Null bootstrap");
/*     */     }
/* 129 */     this.bootstraps.add(bootstrap);
/*     */   }
/*     */ 
/*     */   public void init(Properties props)
/*     */     throws IllegalStateException, Exception
/*     */   {
/* 142 */     if (props == null) {
/* 143 */       throw new IllegalArgumentException("props is null");
/*     */     }
/* 145 */     if (this.config != null) {
/* 146 */       throw new IllegalStateException("already initialized");
/*     */     }
/* 148 */     ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/* 152 */       Thread.currentThread().setContextClassLoader(getClass().getClassLoader());
/* 153 */       doInit(props);
/*     */     }
/*     */     finally
/*     */     {
/* 157 */       Thread.currentThread().setContextClassLoader(oldCL);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void doInit(Properties props)
/*     */     throws Exception
/*     */   {
/* 170 */     this.config = new BaseServerConfig(props);
/*     */ 
/* 173 */     boolean overrideTmpDir = Boolean.getBoolean("jboss.server.temp.dir.overrideJavaTmpDir");
/* 174 */     if (overrideTmpDir)
/*     */     {
/* 176 */       File serverTmpDir = this.config.getServerTempDir();
/* 177 */       System.setProperty("java.io.tmpdir", serverTmpDir.getCanonicalPath());
/*     */     }
/*     */ 
/* 183 */     this.config.getServerLogDir();
/* 184 */     this.log = Logger.getLogger(getClass());
/*     */ 
/* 187 */     initURLHandlers();
/* 188 */     this.config.initURLs();
/*     */ 
/* 190 */     this.log.info("Starting JBoss (Microcontainer)...");
/*     */ 
/* 192 */     if (this.jbossPackage != null)
/*     */     {
/* 195 */       this.log.info("Release ID: " + this.jbossPackage.getImplementationTitle() + " " + this.jbossPackage.getImplementationVersion());
/*     */     }
/*     */     else
/*     */     {
/* 201 */       this.log.warn("could not get package info to display release, either the jar manifest in jboss-system.jar has been mangled or you're running unit tests from ant outside of JBoss itself.");
/*     */     }
/*     */ 
/* 206 */     this.log.debug("Using config: " + this.config);
/*     */ 
/* 209 */     this.log.debug("Server type: " + getClass());
/*     */ 
/* 212 */     ClassLoader cl = getClass().getClassLoader();
/* 213 */     this.log.debug("Server loaded through: " + cl.getClass().getName());
/*     */ 
/* 216 */     if ((cl instanceof NoAnnotationURLClassLoader))
/*     */     {
/* 218 */       NoAnnotationURLClassLoader nacl = (NoAnnotationURLClassLoader)cl;
/* 219 */       URL[] bootURLs = nacl.getAllURLs();
/* 220 */       this.log.debug("Boot URLs:");
/* 221 */       for (int i = 0; i < bootURLs.length; i++)
/*     */       {
/* 223 */         this.log.debug("  " + bootURLs[i]);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 228 */     this.log.info("Home Dir: " + this.config.getHomeDir());
/* 229 */     this.log.info("Home URL: " + this.config.getHomeURL());
/* 230 */     this.log.info("Library URL: " + this.config.getLibraryURL());
/* 231 */     this.log.info("Patch URL: " + this.config.getPatchURL());
/* 232 */     this.log.info("Server Name: " + this.config.getServerName());
/* 233 */     this.log.info("Server Home Dir: " + this.config.getServerHomeDir());
/* 234 */     this.log.info("Server Home URL: " + this.config.getServerHomeURL());
/* 235 */     this.log.info("Server Data Dir: " + this.config.getServerDataDir());
/* 236 */     this.log.info("Server Temp Dir: " + this.config.getServerTempDir());
/* 237 */     this.log.info("Server Config URL: " + this.config.getServerConfigURL());
/* 238 */     this.log.info("Server Library URL: " + this.config.getServerLibraryURL());
/* 239 */     this.log.info("Root Deployment Filename: " + this.config.getRootDeploymentFilename());
/*     */   }
/*     */ 
/*     */   private void initURLHandlers()
/*     */   {
/* 251 */     if (this.config.getRequireJBossURLStreamHandlerFactory())
/*     */     {
/* 253 */       internalInitURLHandlers();
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 259 */         internalInitURLHandlers();
/*     */       }
/*     */       catch (SecurityException e)
/*     */       {
/* 263 */         this.log.warn("You do not have permissions to set URLStreamHandlerFactory", e);
/*     */       }
/*     */       catch (Error e)
/*     */       {
/* 267 */         this.log.warn("URLStreamHandlerFactory already set", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void internalInitURLHandlers()
/*     */   {
/*     */     try
/*     */     {
/* 282 */       URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory());
/*     */ 
/* 285 */       URLStreamHandlerFactory.preload();
/*     */     }
/*     */     catch (Error error)
/*     */     {
/* 290 */       this.log.warn("Caught Throwable Error, this probably means we've already set the URLStreamHAndlerFactory before");
/*     */     }
/*     */ 
/* 295 */     String handlerPkgs = System.getProperty("java.protocol.handler.pkgs");
/* 296 */     if (handlerPkgs != null)
/*     */     {
/* 298 */       handlerPkgs = handlerPkgs + "|org.jboss.net.protocol";
/*     */     }
/*     */     else
/*     */     {
/* 302 */       handlerPkgs = "org.jboss.net.protocol";
/*     */     }
/* 304 */     System.setProperty("java.protocol.handler.pkgs", handlerPkgs);
/*     */   }
/*     */ 
/*     */   public ServerConfig getConfig()
/*     */     throws IllegalStateException
/*     */   {
/* 316 */     if (this.config == null) {
/* 317 */       throw new IllegalStateException("not initialized");
/*     */     }
/* 319 */     return this.config;
/*     */   }
/*     */ 
/*     */   public boolean isStarted()
/*     */   {
/* 329 */     return this.started;
/*     */   }
/*     */ 
/*     */   public boolean isInShutdown()
/*     */   {
/* 339 */     return this.isInShutdown;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws IllegalStateException, Exception
/*     */   {
/* 350 */     synchronized (this)
/*     */     {
/* 352 */       if (!this.isInStart)
/*     */       {
/* 354 */         this.isInStart = true;
/*     */       }
/*     */       else
/*     */       {
/* 358 */         this.log.debug("Already in start, ignoring duplicate start");
/* 359 */         return;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 364 */     ServerConfig config = getConfig();
/*     */ 
/* 367 */     if (this.started) {
/* 368 */       throw new IllegalStateException("already started");
/*     */     }
/* 370 */     ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/* 374 */       ClassLoader myCL = getClass().getClassLoader();
/* 375 */       Thread.currentThread().setContextClassLoader(myCL);
/*     */ 
/* 378 */       StopWatch watch = new StopWatch(true);
/*     */ 
/* 381 */       this.startDate = new Date();
/*     */ 
/* 384 */       this.shutdownHook = new ShutdownHook();
/* 385 */       this.shutdownHook.setDaemon(true);
/*     */       try
/*     */       {
/* 389 */         Runtime.getRuntime().addShutdownHook(this.shutdownHook);
/* 390 */         this.log.debug("Shutdown hook added " + this.shutdownHook);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 394 */         this.log.warn("Failed to add shutdown hook; ignoring", e);
/*     */       }
/*     */ 
/* 398 */       doStart(watch);
/*     */ 
/* 401 */       ClassLoader cl = Thread.currentThread().getContextClassLoader();
/*     */       try
/*     */       {
/* 405 */         for (Bootstrap bootstrap : this.bootstraps)
/*     */         {
/* 407 */           Thread.currentThread().setContextClassLoader(bootstrap.getClass().getClassLoader());
/* 408 */           bootstrap.start(this);
/* 409 */           this.startedBootstraps.add(0, bootstrap);
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 414 */         Thread.currentThread().setContextClassLoader(cl);
/*     */       }
/*     */ 
/* 417 */       if (config.isInstallLifeThread())
/*     */       {
/* 419 */         this.log.debug("Installing life thread " + this.lifeThread);
/* 420 */         this.lifeThread = new LifeThread();
/* 421 */         this.lifeThread.start();
/*     */       }
/*     */ 
/* 424 */       this.started = true;
/*     */ 
/* 427 */       Notification msg = new Notification("org.jboss.system.server.started", this, 1L);
/* 428 */       msg.setUserData(new Long(watch.getLapTime()));
/* 429 */       sendNotification(msg);
/*     */ 
/* 431 */       watch.stop();
/*     */ 
/* 433 */       if (this.jbossPackage != null)
/*     */       {
/* 436 */         this.log.info("JBoss (Microcontainer) [" + this.jbossPackage.getImplementationVersion() + "] Started in " + watch);
/*     */       }
/*     */       else
/*     */       {
/* 441 */         this.log.info("JBoss (Microcontainer) [unknown version] Started in " + watch);
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 446 */       this.log.debug("Failed to start", t);
/*     */ 
/* 448 */       if ((t instanceof Exception))
/* 449 */         throw ((Exception)t);
/* 450 */       if ((t instanceof Error)) {
/* 451 */         throw ((Error)t);
/*     */       }
/* 453 */       throw new RuntimeException("Unexpected error", t);
/*     */     }
/*     */     finally
/*     */     {
/* 457 */       Thread.currentThread().setContextClassLoader(oldCL);
/* 458 */       this.isInStart = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected abstract void doStart(StopWatch paramStopWatch)
/*     */     throws Throwable;
/*     */ 
/*     */   protected abstract void doShutdown();
/*     */ 
/*     */   protected void shutdownServer()
/*     */   {
/* 480 */     if (this.log.isTraceEnabled()) {
/* 481 */       this.log.trace("Shutdown caller:", new Throwable("Here"));
/*     */     }
/*     */ 
/* 486 */     if (this.isInternalShutdown) {
/* 487 */       return;
/*     */     }
/* 489 */     this.isInternalShutdown = true;
/*     */ 
/* 492 */     Notification msg = new Notification("org.jboss.system.server.stopped", this, 2L);
/* 493 */     sendNotification(msg);
/*     */ 
/* 496 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/* 500 */       for (Bootstrap bootstrap : this.startedBootstraps)
/*     */       {
/* 502 */         Thread.currentThread().setContextClassLoader(bootstrap.getClass().getClassLoader());
/*     */         try
/*     */         {
/* 505 */           bootstrap.shutdown(this);
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 509 */           this.log.warn("Error shutting down bootstrap: " + bootstrap, t);
/*     */         }
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 515 */       Thread.currentThread().setContextClassLoader(cl);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 520 */       doShutdown();
/*     */     }
/*     */     finally
/*     */     {
/* 525 */       this.log.info("Shutdown complete");
/* 526 */       System.out.println("Shutdown complete");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */     throws IllegalStateException
/*     */   {
/* 540 */     if (this.log.isTraceEnabled()) {
/* 541 */       this.log.trace("Shutdown caller:", new Throwable("Here"));
/*     */     }
/* 543 */     if (!this.started) {
/* 544 */       throw new IllegalStateException("not started");
/*     */     }
/* 546 */     if (this.isInShutdown) {
/* 547 */       throw new IllegalStateException("already in shutdown mode");
/*     */     }
/* 549 */     this.isInShutdown = true;
/* 550 */     boolean exitOnShutdown = this.config.getExitOnShutdown();
/* 551 */     boolean blockingShutdown = this.config.getBlockingShutdown();
/* 552 */     this.log.info("Shutting down the server, blockingShutdown: " + blockingShutdown);
/*     */ 
/* 554 */     this.log.debug("exitOnShutdown: " + exitOnShutdown);
/* 555 */     this.log.debug("blockingShutdown: " + blockingShutdown);
/*     */ 
/* 557 */     if (exitOnShutdown)
/*     */     {
/* 559 */       exit(0);
/*     */     }
/*     */     else
/*     */     {
/* 565 */       this.lifeThread.interrupt();
/*     */ 
/* 567 */       if (blockingShutdown)
/*     */       {
/* 569 */         shutdownServer();
/*     */       }
/*     */       else
/*     */       {
/* 575 */         new Thread()
/*     */         {
/*     */           public void run()
/*     */           {
/* 581 */             AbstractServerImpl.this.shutdownServer();
/*     */           }
/*     */         }
/* 575 */         .start();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void exit(int exitcode)
/*     */   {
/* 597 */     new Thread(exitcode)
/*     */     {
/*     */       public void run()
/*     */       {
/* 601 */         AbstractServerImpl.this.log.info("Server exit(" + this.val$exitcode + ") called");
/*     */ 
/* 604 */         AbstractServerImpl.this.shutdownHook.setHaltExitCode(this.val$exitcode);
/*     */ 
/* 607 */         Runtime.getRuntime().exit(this.val$exitcode);
/*     */       }
/*     */     }
/* 597 */     .start();
/*     */   }
/*     */ 
/*     */   public void exit()
/*     */   {
/* 617 */     exit(1);
/*     */   }
/*     */ 
/*     */   public void halt(int exitcode)
/*     */   {
/* 629 */     new Thread(exitcode)
/*     */     {
/*     */       public void run()
/*     */       {
/* 633 */         System.err.println("Server halt(" + this.val$exitcode + ") called, halting the JVM now!");
/* 634 */         Runtime.getRuntime().halt(this.val$exitcode);
/*     */       }
/*     */     }
/* 629 */     .start();
/*     */   }
/*     */ 
/*     */   public void halt()
/*     */   {
/* 645 */     halt(1);
/*     */   }
/*     */ 
/*     */   private void logMemoryUsage(Runtime rt)
/*     */   {
/* 660 */     this.log.info("Total/free memory: " + rt.totalMemory() + "/" + rt.freeMemory());
/*     */   }
/*     */ 
/*     */   public void runGarbageCollector()
/*     */   {
/* 668 */     Runtime rt = Runtime.getRuntime();
/*     */ 
/* 670 */     logMemoryUsage(rt);
/* 671 */     rt.gc();
/* 672 */     this.log.info("Hinted to the JVM to run garbage collection");
/* 673 */     logMemoryUsage(rt);
/*     */   }
/*     */ 
/*     */   public void runFinalization()
/*     */   {
/* 681 */     Runtime.getRuntime().runFinalization();
/* 682 */     this.log.info("Hinted to the JVM to run any pending object finalizations");
/*     */   }
/*     */ 
/*     */   public void traceMethodCalls(Boolean flag)
/*     */   {
/* 692 */     Runtime.getRuntime().traceMethodCalls(flag.booleanValue());
/*     */   }
/*     */ 
/*     */   public void traceInstructions(Boolean flag)
/*     */   {
/* 702 */     Runtime.getRuntime().traceInstructions(flag.booleanValue());
/*     */   }
/*     */ 
/*     */   public Date getStartDate()
/*     */   {
/* 712 */     return this.startDate;
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/* 717 */     return this.version.toString();
/*     */   }
/*     */ 
/*     */   public String getVersionName()
/*     */   {
/* 722 */     return this.version.getName();
/*     */   }
/*     */ 
/*     */   public String getVersionNumber()
/*     */   {
/* 727 */     return this.version.getVersionNumber();
/*     */   }
/*     */ 
/*     */   public String getBuildNumber()
/*     */   {
/* 732 */     return this.version.getBuildNumber();
/*     */   }
/*     */ 
/*     */   public String getBuildJVM()
/*     */   {
/* 737 */     return this.version.getBuildJVM();
/*     */   }
/*     */ 
/*     */   public String getBuildOS()
/*     */   {
/* 742 */     return this.version.getBuildOS();
/*     */   }
/*     */ 
/*     */   public String getBuildID()
/*     */   {
/* 747 */     return this.version.getBuildID();
/*     */   }
/*     */ 
/*     */   public String getBuildDate()
/*     */   {
/* 756 */     return this.version.getBuildDate();
/*     */   }
/*     */ 
/*     */   private class ShutdownHook extends Thread
/*     */   {
/* 798 */     private boolean forceHalt = true;
/*     */     private int haltExitCode;
/*     */ 
/*     */     public ShutdownHook()
/*     */     {
/* 805 */       super();
/*     */ 
/* 807 */       String value = SecurityActions.getSystemProperty("jboss.shutdown.forceHalt", null);
/* 808 */       if (value != null)
/*     */       {
/* 810 */         this.forceHalt = Boolean.valueOf(value).booleanValue();
/*     */       }
/*     */     }
/*     */ 
/*     */     public void setHaltExitCode(int haltExitCode)
/*     */     {
/* 816 */       this.haltExitCode = haltExitCode;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 821 */       AbstractServerImpl.this.log.info("Runtime shutdown hook called, forceHalt: " + this.forceHalt);
/*     */ 
/* 824 */       AbstractServerImpl.this.shutdownServer();
/*     */ 
/* 827 */       LogManager lm = LogManager.getLogManager();
/*     */       try
/*     */       {
/* 830 */         Class[] sig = new Class[0];
/* 831 */         Method doReset = lm.getClass().getDeclaredMethod("doReset", sig);
/* 832 */         Object[] args = new Object[0];
/* 833 */         doReset.invoke(lm, args);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 837 */         if (AbstractServerImpl.this.log.isTraceEnabled()) {
/* 838 */           AbstractServerImpl.this.log.trace("No doReset found?", e);
/*     */         }
/*     */       }
/*     */ 
/* 842 */       if (this.forceHalt)
/*     */       {
/* 844 */         System.out.println("Halting VM");
/* 845 */         Runtime.getRuntime().halt(this.haltExitCode);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private class LifeThread extends Thread
/*     */   {
/* 768 */     Object lock = new Object();
/*     */ 
/*     */     LifeThread()
/*     */     {
/* 772 */       super();
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 777 */       synchronized (this.lock)
/*     */       {
/*     */         try
/*     */         {
/* 781 */           this.lock.wait();
/*     */         }
/*     */         catch (InterruptedException ignore)
/*     */         {
/*     */         }
/*     */       }
/* 787 */       AbstractServerImpl.this.log.info("LifeThread.run() exits!");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.bootstrap.AbstractServerImpl
 * JD-Core Version:    0.6.0
 */