/*    */ package org.jboss.beans.metadata.plugins.policy;
/*    */ 
/*    */ import java.util.Map;
/*    */ import java.util.Set;
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
/*    */ import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
/*    */ import org.jboss.metadata.spi.MutableMetaData;
/*    */ import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
/*    */ import org.jboss.metadata.spi.retrieval.MetaDataItem;
/*    */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*    */ import org.jboss.metadata.spi.scope.Scope;
/*    */ import org.jboss.metadata.spi.scope.ScopeKey;
/*    */ 
/*    */ public class MetaDataRepositoryInstaller
/*    */ {
/*    */   private Kernel underlyingKernel;
/*    */   private Set<Scope> scopes;
/*    */   private Map<String, Object> bindings;
/*    */ 
/*    */   public void setKernel(Kernel kernel)
/*    */   {
/* 53 */     this.underlyingKernel = kernel;
/*    */   }
/*    */ 
/*    */   public void setScopes(Set<Scope> scopes)
/*    */   {
/* 58 */     this.scopes = scopes;
/*    */   }
/*    */ 
/*    */   public void setBindings(Map<String, Object> bindings)
/*    */   {
/* 63 */     this.bindings = bindings;
/*    */   }
/*    */ 
/*    */   public void start()
/*    */   {
/* 68 */     KernelMetaDataRepository kmdr = this.underlyingKernel.getMetaDataRepository();
/* 69 */     MutableMetaDataRepository mmdr = kmdr.getMetaDataRepository();
/* 70 */     ScopeKey scopeKey = new ScopeKey(this.scopes);
/* 71 */     MetaDataRetrieval retrieval = mmdr.getMetaDataRetrieval(scopeKey);
/*    */ 
/* 73 */     if (retrieval == null)
/*    */     {
/* 75 */       retrieval = new MemoryMetaDataLoader(scopeKey);
/* 76 */       mmdr.addMetaDataRetrieval(retrieval);
/*    */     }
/* 78 */     MutableMetaData mmd = (MutableMetaData)retrieval;
/*    */ 
/* 80 */     Kernel kernel = this.underlyingKernel;
/*    */ 
/* 82 */     ScopeKey parent = scopeKey.getParent();
/* 83 */     if (parent != null)
/*    */     {
/* 85 */       MetaDataRetrieval pretrieval = mmdr.getMetaDataRetrieval(parent);
/* 86 */       MetaDataItem item = pretrieval.retrieveMetaData(Kernel.class);
/* 87 */       if (item != null) {
/* 88 */         kernel = (Kernel)item.getValue();
/*    */       }
/*    */     }
/* 91 */     Kernel scopedKernel = null;
/*    */ 
/* 93 */     mmd.addMetaData(scopedKernel, Kernel.class);
/*    */   }
/*    */ 
/*    */   public void stop()
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.policy.MetaDataRepositoryInstaller
 * JD-Core Version:    0.6.0
 */