/*     */ package org.jboss.beans.metadata.plugins.policy;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.annotation.factory.AnnotationCreator;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.policy.ScopeMetaData;
/*     */ import org.jboss.metadata.spi.scope.ScopeFactory;
/*     */ import org.jboss.metadata.spi.scope.ScopeFactoryLookup;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ import org.jboss.metadata.spi.scope.ScopeLevel;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractScopeMetaData extends JBossObject
/*     */   implements ScopeMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String scope;
/*     */   private String level;
/*     */   private String qualifier;
/*     */ 
/*     */   public Object getUnderlyingValue()
/*     */   {
/*  55 */     return this.scope;
/*     */   }
/*     */ 
/*     */   public Object getValue(TypeInfo info, ClassLoader cl)
/*     */     throws Throwable
/*     */   {
/*  61 */     if (this.scope != null)
/*     */     {
/*  63 */       Annotation annotation = (Annotation)AnnotationCreator.createAnnotation(this.scope, cl);
/*  64 */       ScopeFactoryLookup scopeFactoryLookup = (ScopeFactoryLookup)annotation.getClass().getAnnotation(ScopeFactoryLookup.class);
/*  65 */       if (scopeFactoryLookup != null)
/*     */       {
/*  74 */         ScopeFactory scopeFactory = (ScopeFactory)scopeFactoryLookup.value().newInstance();
/*  75 */         return scopeFactory.create(annotation);
/*     */       }
/*     */ 
/*  80 */       return createScopeKey(annotation.getClass().getSimpleName(), annotation.toString());
/*     */     }
/*     */ 
/*  85 */     return createScopeKey(this.level, this.qualifier);
/*     */   }
/*     */ 
/*     */   private ScopeKey createScopeKey(String name, String qualifier)
/*     */   {
/*  91 */     int level = ScopeLevel.getScopeLevel(name);
/*  92 */     return new ScopeKey(new ScopeLevel(level, name), qualifier);
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor vistor)
/*     */   {
/*  97 */     vistor.initialVisit(this);
/*     */   }
/*     */ 
/*     */   public void describeVisit(MetaDataVisitor vistor)
/*     */   {
/* 102 */     vistor.describeVisit(this);
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/* 107 */     return null;
/*     */   }
/*     */ 
/*     */   public String getScope()
/*     */   {
/* 112 */     return this.scope;
/*     */   }
/*     */ 
/*     */   public String getLevel()
/*     */   {
/* 117 */     return this.level;
/*     */   }
/*     */ 
/*     */   public String getQualifier()
/*     */   {
/* 122 */     return this.qualifier;
/*     */   }
/*     */ 
/*     */   public void setScope(String scope)
/*     */   {
/* 127 */     this.scope = scope;
/*     */   }
/*     */ 
/*     */   public void setLevel(String level)
/*     */   {
/* 132 */     this.level = level;
/*     */   }
/*     */ 
/*     */   public void setQualifier(String qualifier)
/*     */   {
/* 137 */     this.qualifier = qualifier;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 142 */     buffer.append("scope=").append(this.scope);
/* 143 */     buffer.append(" level=").append(this.level);
/* 144 */     buffer.append(" qualifier=").append(this.qualifier);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 149 */     buffer.append(this.scope);
/* 150 */     buffer.append('/');
/* 151 */     buffer.append(this.level);
/* 152 */     buffer.append('/');
/* 153 */     buffer.append(this.qualifier);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.policy.AbstractScopeMetaData
 * JD-Core Version:    0.6.0
 */