/*     */ package org.jboss.beans.metadata.plugins.factory;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractMapMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
/*     */ import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
/*     */ import org.jboss.beans.metadata.spi.ConstructorMetaData;
/*     */ import org.jboss.beans.metadata.spi.LifecycleMetaData;
/*     */ import org.jboss.beans.metadata.spi.PropertyMetaData;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ 
/*     */ public class GenericBeanFactoryMetaData extends AbstractBeanMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */ 
/*     */   public GenericBeanFactoryMetaData()
/*     */   {
/*  56 */     setBean(GenericBeanFactory.class.getName());
/*  57 */     AbstractConstructorMetaData constructor = new AbstractConstructorMetaData();
/*  58 */     ArrayList parameters = new ArrayList();
/*  59 */     parameters.add(new AbstractParameterMetaData(KernelConfigurator.class.getName(), new AbstractDependencyValueMetaData("jboss.kernel:service=KernelConfigurator")));
/*  60 */     constructor.setParameters(parameters);
/*  61 */     setConstructor(constructor);
/*  62 */     setProperties(new HashSet());
/*     */   }
/*     */ 
/*     */   public GenericBeanFactoryMetaData(String name)
/*     */   {
/*  72 */     this();
/*  73 */     setName(name);
/*     */   }
/*     */ 
/*     */   public GenericBeanFactoryMetaData(String name, String bean)
/*     */   {
/*  84 */     this(name);
/*  85 */     setBeanClass(bean);
/*     */   }
/*     */ 
/*     */   public String getBeanClass()
/*     */   {
/*  95 */     AbstractPropertyMetaData prop = (AbstractPropertyMetaData)getProperty("bean");
/*  96 */     if (prop != null)
/*     */     {
/*  98 */       AbstractValueMetaData value = (AbstractValueMetaData)prop.getValue();
/*  99 */       if (value != null)
/* 100 */         return (String)value.getUnderlyingValue();
/*     */     }
/* 102 */     return null;
/*     */   }
/*     */ 
/*     */   public void setBeanClass(String beanClass)
/*     */   {
/* 112 */     Set properties = getProperties();
/* 113 */     properties.add(new AbstractPropertyMetaData("bean", new AbstractValueMetaData(beanClass)));
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoaderMetaData classLoader)
/*     */   {
/* 118 */     super.setClassLoader(classLoader);
/* 119 */     Set properties = getProperties();
/* 120 */     properties.add(new AbstractPropertyMetaData("classLoader", new AbstractValueMetaData(classLoader)));
/*     */   }
/*     */ 
/*     */   public void setBeanConstructor(ConstructorMetaData constructor)
/*     */   {
/* 130 */     Set properties = getProperties();
/* 131 */     properties.add(new AbstractPropertyMetaData("constructor", new AbstractValueMetaData(constructor)));
/*     */   }
/*     */ 
/*     */   public ValueMetaData getBeanProperty(String name)
/*     */   {
/* 142 */     if (name == null)
/* 143 */       throw new IllegalArgumentException("Null name");
/* 144 */     PropertyMetaData properties = getProperty("properties");
/* 145 */     if (properties == null)
/* 146 */       return null;
/* 147 */     AbstractMapMetaData map = (AbstractMapMetaData)properties.getValue();
/* 148 */     for (Iterator i = map.entrySet().iterator(); i.hasNext(); )
/*     */     {
/* 150 */       Map.Entry entry = (Map.Entry)i.next();
/* 151 */       ValueMetaData key = (ValueMetaData)entry.getKey();
/* 152 */       if (key.getUnderlyingValue().equals(name))
/*     */       {
/* 154 */         ValueMetaData vmd = (ValueMetaData)entry.getValue();
/* 155 */         return (ValueMetaData)vmd.getUnderlyingValue();
/*     */       }
/*     */     }
/* 158 */     return null;
/*     */   }
/*     */ 
/*     */   public void addBeanProperty(PropertyMetaData property)
/*     */   {
/* 168 */     PropertyMetaData properties = getProperty("properties");
/*     */     AbstractMapMetaData map;
/* 171 */     if (properties == null)
/*     */     {
/* 173 */       AbstractMapMetaData map = new AbstractMapMetaData();
/* 174 */       properties = new AbstractPropertyMetaData("properties", map);
/* 175 */       addProperty(properties);
/*     */     }
/*     */     else
/*     */     {
/* 179 */       map = (AbstractMapMetaData)properties.getValue();
/*     */     }
/*     */ 
/* 182 */     ValueMetaData valueMetaData = property.getValue();
/* 183 */     valueMetaData = new AbstractValueMetaData(valueMetaData);
/* 184 */     map.put(new AbstractValueMetaData(property.getName()), valueMetaData);
/*     */   }
/*     */ 
/*     */   public void setBeanCreate(LifecycleMetaData lifecycle)
/*     */   {
/* 189 */     Set properties = getProperties();
/* 190 */     properties.add(new AbstractPropertyMetaData("create", new AbstractValueMetaData(lifecycle)));
/*     */   }
/*     */ 
/*     */   public void setBeanStart(LifecycleMetaData lifecycle)
/*     */   {
/* 195 */     Set properties = getProperties();
/* 196 */     properties.add(new AbstractPropertyMetaData("start", new AbstractValueMetaData(lifecycle)));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.factory.GenericBeanFactoryMetaData
 * JD-Core Version:    0.6.0
 */