/*     */ package org.jboss.beans.metadata.plugins.factory;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
/*     */ import org.jboss.beans.metadata.spi.ConstructorMetaData;
/*     */ import org.jboss.beans.metadata.spi.LifecycleMetaData;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.beans.metadata.spi.factory.BeanFactory;
/*     */ import org.jboss.joinpoint.spi.Joinpoint;
/*     */ import org.jboss.joinpoint.spi.JoinpointException;
/*     */ import org.jboss.joinpoint.spi.MethodJoinpoint;
/*     */ import org.jboss.joinpoint.spi.TargettedJoinpoint;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ 
/*     */ public class GenericBeanFactory
/*     */   implements BeanFactory
/*     */ {
/*     */   protected KernelConfigurator configurator;
/*     */   protected String bean;
/*     */   protected ClassLoaderMetaData classLoader;
/*     */   protected ConstructorMetaData constructor;
/*     */   protected Map properties;
/*     */   protected LifecycleMetaData create;
/*     */   protected LifecycleMetaData start;
/*     */ 
/*     */   public GenericBeanFactory(KernelConfigurator configurator)
/*     */   {
/*  77 */     this.configurator = configurator;
/*     */   }
/*     */ 
/*     */   public Object createBean()
/*     */     throws Throwable
/*     */   {
/*  88 */     ClassLoader cl = Configurator.getClassLoader(this.classLoader);
/*  89 */     BeanInfo info = null;
/*  90 */     if (this.bean != null) {
/*  91 */       info = this.configurator.getBeanInfo(this.bean, cl);
/*     */     }
/*  93 */     Joinpoint joinpoint = this.configurator.getConstructorJoinPoint(info, this.constructor, null);
/*  94 */     Object result = joinpoint.dispatch();
/*  95 */     if ((info == null) && (result != null))
/*  96 */       info = this.configurator.getBeanInfo(result.getClass());
/*     */     Iterator i$;
/*  98 */     if ((this.properties != null) && (this.properties.size() > 0))
/*     */     {
/* 100 */       for (i$ = this.properties.entrySet().iterator(); i$.hasNext(); ) { Object o = i$.next();
/*     */ 
/* 102 */         Map.Entry entry = (Map.Entry)o;
/* 103 */         String property = (String)entry.getKey();
/* 104 */         ValueMetaData vmd = (ValueMetaData)entry.getValue();
/* 105 */         TargettedJoinpoint jp = this.configurator.getPropertySetterJoinPoint(info, property, cl, vmd);
/* 106 */         jp.setTarget(result);
/* 107 */         jp.dispatch();
/*     */       }
/*     */     }
/* 110 */     invokeLifecycle("create", this.create, info, cl, result);
/* 111 */     invokeLifecycle("start", this.start, info, cl, result);
/* 112 */     return result;
/*     */   }
/*     */ 
/*     */   public String getBean()
/*     */   {
/* 122 */     return this.bean;
/*     */   }
/*     */ 
/*     */   public void setBean(String bean)
/*     */   {
/* 132 */     this.bean = bean;
/*     */   }
/*     */ 
/*     */   public ClassLoaderMetaData getClassLoader()
/*     */   {
/* 142 */     return this.classLoader;
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoaderMetaData classLoader)
/*     */   {
/* 152 */     this.classLoader = classLoader;
/*     */   }
/*     */ 
/*     */   public ConstructorMetaData getConstructor()
/*     */   {
/* 162 */     return this.constructor;
/*     */   }
/*     */ 
/*     */   public void setConstructor(ConstructorMetaData constructor)
/*     */   {
/* 172 */     this.constructor = constructor;
/*     */   }
/*     */ 
/*     */   public Map getProperties()
/*     */   {
/* 182 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public void setProperties(Map properties)
/*     */   {
/* 192 */     this.properties = properties;
/*     */   }
/*     */ 
/*     */   public LifecycleMetaData getCreate()
/*     */   {
/* 202 */     return this.create;
/*     */   }
/*     */ 
/*     */   public void setCreate(LifecycleMetaData create)
/*     */   {
/* 212 */     this.create = create;
/*     */   }
/*     */ 
/*     */   public LifecycleMetaData getStart()
/*     */   {
/* 222 */     return this.start;
/*     */   }
/*     */ 
/*     */   public void setStart(LifecycleMetaData start)
/*     */   {
/* 232 */     this.start = start;
/*     */   }
/*     */ 
/*     */   protected void invokeLifecycle(String methodName, LifecycleMetaData lifecycle, BeanInfo info, ClassLoader cl, Object target)
/*     */     throws Throwable
/*     */   {
/* 247 */     if ((lifecycle == null) || (!lifecycle.isIgnored()))
/*     */     {
/* 249 */       String method = methodName;
/* 250 */       if ((lifecycle != null) && (lifecycle.getMethodName() != null))
/* 251 */         method = lifecycle.getMethodName();
/* 252 */       List parameters = null;
/* 253 */       if (lifecycle != null)
/* 254 */         parameters = lifecycle.getParameters();
/*     */       MethodJoinpoint joinpoint;
/*     */       try {
/* 258 */         joinpoint = this.configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
/*     */       }
/*     */       catch (JoinpointException ignored)
/*     */       {
/* 262 */         return;
/*     */       }
/* 264 */       joinpoint.setTarget(target);
/* 265 */       joinpoint.dispatch();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.factory.GenericBeanFactory
 * JD-Core Version:    0.6.0
 */