/*    */ package org.jboss.beans.metadata.plugins.builder;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
/*    */ import org.jboss.beans.metadata.spi.ParameterMetaData;
/*    */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*    */ 
/*    */ public class ParameterMetaDataBuilder<T extends MutableParameterizedMetaData>
/*    */ {
/*    */   private T parameterHolder;
/*    */ 
/*    */   public ParameterMetaDataBuilder(T parameterHolder)
/*    */     throws IllegalArgumentException
/*    */   {
/* 45 */     this.parameterHolder = parameterHolder;
/*    */   }
/*    */ 
/*    */   private List<ParameterMetaData> getParameters()
/*    */   {
/* 50 */     return this.parameterHolder.getParameters();
/*    */   }
/*    */ 
/*    */   private void setParameters(List<ParameterMetaData> parameters)
/*    */   {
/* 55 */     this.parameterHolder.setParameters(parameters);
/*    */   }
/*    */ 
/*    */   private List<ParameterMetaData> checkParameters()
/*    */   {
/* 60 */     List parameters = getParameters();
/* 61 */     if (parameters == null)
/*    */     {
/* 63 */       parameters = new ArrayList();
/* 64 */       setParameters(parameters);
/*    */     }
/* 66 */     return parameters;
/*    */   }
/*    */ 
/*    */   public T addParameterMetaData(String type, Object value)
/*    */   {
/* 71 */     List parameters = checkParameters();
/* 72 */     parameters.add(new AbstractParameterMetaData(type, value));
/* 73 */     return this.parameterHolder;
/*    */   }
/*    */ 
/*    */   public T addParameterMetaData(String type, ValueMetaData value)
/*    */   {
/* 78 */     List parameters = checkParameters();
/* 79 */     parameters.add(new AbstractParameterMetaData(type, value));
/* 80 */     return this.parameterHolder;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.builder.ParameterMetaDataBuilder
 * JD-Core Version:    0.6.0
 */