/*     */ package org.jboss.beans.metadata.plugins.builder;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractDependencyMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractSupplyMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.PropertyMetaData;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
/*     */ import org.jboss.dependency.spi.ControllerMode;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ 
/*     */ class BeanMetaDataBuilderImpl
/*     */   implements BeanMetaDataBuilder
/*     */ {
/*     */   private AbstractBeanMetaData beanMetaData;
/*     */   private ParameterMetaDataBuilder<AbstractConstructorMetaData> constructorBuilder;
/*     */   private LifecycleMetaDataBuilder createBuilder;
/*     */   private LifecycleMetaDataBuilder startBuilder;
/*     */   private LifecycleMetaDataBuilder stopBuilder;
/*     */   private LifecycleMetaDataBuilder destroyBuilder;
/*     */   private AbstractInstallMetaDataBuilder installBuilder;
/*     */   private AbstractInstallMetaDataBuilder uninstallBuilder;
/*     */ 
/*     */   public BeanMetaDataBuilderImpl(String bean)
/*     */   {
/*  69 */     this(new AbstractBeanMetaData(bean));
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilderImpl(String name, String bean)
/*     */   {
/*  74 */     this(new AbstractBeanMetaData(name, bean));
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilderImpl(AbstractBeanMetaData beanMetaData)
/*     */   {
/*  79 */     this.beanMetaData = beanMetaData;
/*     */ 
/*  81 */     this.createBuilder = new CreateLifecycleMetaDataBuilder(beanMetaData);
/*  82 */     this.startBuilder = new StartLifecycleMetaDataBuilder(beanMetaData);
/*  83 */     this.stopBuilder = new StopLifecycleMetaDataBuilder(beanMetaData);
/*  84 */     this.destroyBuilder = new DestroyLifecycleMetaDataBuilder(beanMetaData);
/*     */ 
/*  86 */     this.installBuilder = new InstallMetaDataBuilder(beanMetaData);
/*  87 */     this.uninstallBuilder = new UninstallMetaDataBuilder(beanMetaData);
/*     */   }
/*     */ 
/*     */   public BeanMetaData getBeanMetaData()
/*     */   {
/*  92 */     return this.beanMetaData;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder setAliases(Set<Object> aliases)
/*     */   {
/*  97 */     this.beanMetaData.setAliases(aliases);
/*  98 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder setMode(String modeString)
/*     */   {
/* 103 */     return setMode(new ControllerMode(modeString));
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder setMode(ControllerMode mode)
/*     */   {
/* 108 */     this.beanMetaData.setMode(mode);
/* 109 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder setClassLoader(Object classLoader)
/*     */   {
/* 114 */     this.beanMetaData.setClassLoader(new AbstractClassLoaderMetaData(new AbstractValueMetaData(classLoader)));
/* 115 */     return this;
/*     */   }
/*     */ 
/*     */   protected void checkConstructorBuilder()
/*     */   {
/* 120 */     AbstractConstructorMetaData constructor = (AbstractConstructorMetaData)this.beanMetaData.getConstructor();
/* 121 */     if (constructor == null)
/*     */     {
/* 123 */       constructor = new AbstractConstructorMetaData();
/* 124 */       this.beanMetaData.setConstructor(constructor);
/* 125 */       this.constructorBuilder = new ParameterMetaDataBuilder(constructor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder setConstructorValue(Object value)
/*     */   {
/* 131 */     return setConstructorValue(new AbstractValueMetaData(value));
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder setConstructorValue(ValueMetaData value)
/*     */   {
/* 136 */     checkConstructorBuilder();
/* 137 */     AbstractConstructorMetaData constructor = (AbstractConstructorMetaData)this.beanMetaData.getConstructor();
/* 138 */     constructor.setValue(value);
/* 139 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addConstructorParameter(String type, Object value)
/*     */   {
/* 144 */     checkConstructorBuilder();
/* 145 */     this.constructorBuilder.addParameterMetaData(type, value);
/* 146 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addConstructorParameter(String type, ValueMetaData value)
/*     */   {
/* 151 */     checkConstructorBuilder();
/* 152 */     this.constructorBuilder.addParameterMetaData(type, value);
/* 153 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addPropertyMetaData(String name, Object value)
/*     */   {
/* 158 */     Set properties = getProperties();
/* 159 */     properties.add(new AbstractPropertyMetaData(name, value));
/* 160 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addPropertyMetaData(String name, String value)
/*     */   {
/* 165 */     Set properties = getProperties();
/* 166 */     properties.add(new AbstractPropertyMetaData(name, value));
/* 167 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addPropertyMetaData(String name, ValueMetaData value)
/*     */   {
/* 172 */     Set properties = getProperties();
/* 173 */     properties.add(new AbstractPropertyMetaData(name, value));
/* 174 */     return this;
/*     */   }
/*     */ 
/*     */   private Set<PropertyMetaData> getProperties()
/*     */   {
/* 179 */     Set properties = this.beanMetaData.getProperties();
/* 180 */     if (properties == null)
/*     */     {
/* 182 */       properties = new HashSet();
/* 183 */       this.beanMetaData.setProperties(properties);
/*     */     }
/* 185 */     return properties;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder setCreate(String methodName)
/*     */   {
/* 190 */     this.createBuilder.createLifecycleMetaData(methodName);
/* 191 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addCreateParameter(String type, Object value)
/*     */   {
/* 196 */     this.createBuilder.addParameterMetaData(type, value);
/* 197 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addCreateParameter(String type, ValueMetaData value)
/*     */   {
/* 202 */     this.createBuilder.addParameterMetaData(type, value);
/* 203 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder setStart(String methodName)
/*     */   {
/* 208 */     this.startBuilder.createLifecycleMetaData(methodName);
/* 209 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addStartParameter(String type, Object value)
/*     */   {
/* 214 */     this.startBuilder.addParameterMetaData(type, value);
/* 215 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addStartParameter(String type, ValueMetaData value)
/*     */   {
/* 220 */     this.startBuilder.addParameterMetaData(type, value);
/* 221 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder setStop(String methodName)
/*     */   {
/* 226 */     this.stopBuilder.createLifecycleMetaData(methodName);
/* 227 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addStopParameter(String type, Object value)
/*     */   {
/* 232 */     this.stopBuilder.addParameterMetaData(type, value);
/* 233 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addStopParameter(String type, ValueMetaData value)
/*     */   {
/* 238 */     this.stopBuilder.addParameterMetaData(type, value);
/* 239 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder setDestroy(String methodName)
/*     */   {
/* 244 */     this.destroyBuilder.createLifecycleMetaData(methodName);
/* 245 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addDestroyParameter(String type, Object value)
/*     */   {
/* 250 */     this.destroyBuilder.addParameterMetaData(type, value);
/* 251 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addDestroyParameter(String type, ValueMetaData value)
/*     */   {
/* 256 */     this.destroyBuilder.addParameterMetaData(type, value);
/* 257 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addSupply(Object supply)
/*     */   {
/* 262 */     return addSupply(supply, null);
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addSupply(Object supply, String type)
/*     */   {
/* 267 */     Set supplies = this.beanMetaData.getSupplies();
/* 268 */     if (supplies == null)
/*     */     {
/* 270 */       supplies = new HashSet();
/* 271 */       this.beanMetaData.setSupplies(supplies);
/*     */     }
/* 273 */     AbstractSupplyMetaData asmd = new AbstractSupplyMetaData(supply);
/* 274 */     if (type != null)
/* 275 */       asmd.setType(type);
/* 276 */     supplies.add(asmd);
/* 277 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addDemand(Object demand)
/*     */   {
/* 282 */     return addDemand(demand, null, null);
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addDemand(Object demand, String whenRequired, String transformer)
/*     */   {
/* 287 */     Set demands = this.beanMetaData.getDemands();
/* 288 */     if (demands == null)
/*     */     {
/* 290 */       demands = new HashSet();
/* 291 */       this.beanMetaData.setDemands(demands);
/*     */     }
/* 293 */     AbstractDemandMetaData admd = new AbstractDemandMetaData(demand);
/* 294 */     if (whenRequired != null)
/* 295 */       admd.setWhenRequired(new ControllerState(whenRequired));
/* 296 */     if (transformer != null)
/* 297 */       admd.setTransformer(transformer);
/* 298 */     demands.add(admd);
/* 299 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addDependency(Object dependency)
/*     */   {
/* 304 */     Set dependencies = this.beanMetaData.getDepends();
/* 305 */     if (dependencies == null)
/*     */     {
/* 307 */       dependencies = new HashSet();
/* 308 */       this.beanMetaData.setDepends(dependencies);
/*     */     }
/* 310 */     dependencies.add(new AbstractDependencyMetaData(dependency));
/* 311 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addInstall(String methodName)
/*     */   {
/* 316 */     return addInstall(methodName, null);
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addInstall(String methodName, String bean)
/*     */   {
/* 321 */     return addInstall(methodName, bean, new String[0], new Object[0]);
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addInstall(String methodName, String type, Object value)
/*     */   {
/* 326 */     return addInstall(methodName, null, type, value);
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addInstall(String methodName, String bean, String type, Object value)
/*     */   {
/* 331 */     return addInstall(methodName, bean, new String[] { type }, new Object[] { value });
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addInstall(String methodName, String[] types, Object[] values)
/*     */   {
/* 336 */     return addInstall(methodName, null, types, values);
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addInstall(String methodName, String bean, String[] types, Object[] values)
/*     */   {
/* 341 */     AbstractInstallMetaData install = (AbstractInstallMetaData)this.installBuilder.createLifecycleMetaData(methodName);
/* 342 */     install.setBean(bean);
/* 343 */     for (int i = 0; i < types.length; i++)
/*     */     {
/* 345 */       this.installBuilder.addParameter(install, types[i], values[i]);
/*     */     }
/* 347 */     return this;
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addUninstall(String methodName)
/*     */   {
/* 352 */     return addUninstall(methodName, null);
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addUninstall(String methodName, String type, Object value)
/*     */   {
/* 357 */     return addUninstall(methodName, new String[] { type }, new Object[] { value });
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addUninstall(String methodName, String[] types, Object[] values)
/*     */   {
/* 362 */     return addUninstall(methodName, null, types, values);
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addUninstall(String methodName, String bean)
/*     */   {
/* 367 */     return addUninstall(methodName, bean, new String[0], new Object[0]);
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addUninstall(String methodName, String bean, String type, Object value)
/*     */   {
/* 372 */     return addUninstall(methodName, bean, new String[] { type }, new Object[] { value });
/*     */   }
/*     */ 
/*     */   public BeanMetaDataBuilder addUninstall(String methodName, String bean, String[] types, Object[] values)
/*     */   {
/* 377 */     AbstractInstallMetaData uninstall = (AbstractInstallMetaData)this.uninstallBuilder.createLifecycleMetaData(methodName);
/* 378 */     uninstall.setBean(bean);
/* 379 */     for (int i = 0; i < types.length; i++)
/*     */     {
/* 381 */       this.uninstallBuilder.addParameter(uninstall, types[i], values[i]);
/*     */     }
/* 383 */     return this;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderImpl
 * JD-Core Version:    0.6.0
 */