/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class InjectionOption extends JBossObject
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  42 */   public static final InjectionOption STRICT = new InjectionOption("Strict");
/*     */ 
/*  45 */   public static final InjectionOption CALLBACK = new InjectionOption("Callback");
/*     */   protected final String optionString;
/*     */ 
/*     */   private InjectionOption(String optionString)
/*     */   {
/*  57 */     if (optionString == null)
/*  58 */       throw new IllegalArgumentException("Null option string");
/*  59 */     this.optionString = optionString;
/*     */   }
/*     */ 
/*     */   public static InjectionOption getInstance(String optionString)
/*     */   {
/*  71 */     if (STRICT.getOptionString().equalsIgnoreCase(optionString))
/*  72 */       return STRICT;
/*  73 */     if (CALLBACK.getOptionString().equalsIgnoreCase(optionString)) {
/*  74 */       return CALLBACK;
/*     */     }
/*  76 */     throw new IllegalArgumentException("No such option: " + optionString);
/*     */   }
/*     */ 
/*     */   public String getOptionString()
/*     */   {
/*  86 */     return this.optionString;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/*  91 */     if ((object == null) || (!(object instanceof InjectionOption)))
/*  92 */       return false;
/*  93 */     InjectionOption other = (InjectionOption)object;
/*  94 */     return this.optionString.equals(other.getOptionString());
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/*  99 */     buffer.append(this.optionString);
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 104 */     return this.optionString.hashCode();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.InjectionOption
 * JD-Core Version:    0.6.0
 */