/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Stack;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.dependency.plugins.JMXObjectNameFix;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractValueMetaData extends JBossObject
/*     */   implements ValueMetaData, TypeProvider, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private Object value;
/*     */ 
/*     */   public AbstractValueMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractValueMetaData(Object value)
/*     */   {
/*  67 */     setValue(value);
/*     */   }
/*     */ 
/*     */   public Object getValue()
/*     */   {
/*  72 */     return this.value;
/*     */   }
/*     */ 
/*     */   public void setValue(Object value)
/*     */   {
/*  77 */     Object jmxHack = JMXObjectNameFix.needsAnAlias(value);
/*  78 */     if (jmxHack != null)
/*  79 */       this.value = jmxHack;
/*     */     else
/*  81 */       this.value = value;
/*  82 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public Object getUnderlyingValue()
/*     */   {
/*  87 */     return this.value;
/*     */   }
/*     */ 
/*     */   public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable
/*     */   {
/*  92 */     return info != null ? info.convertValue(this.value) : this.value;
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/*  97 */     visitor.initialVisit(this);
/*     */   }
/*     */ 
/*     */   public void describeVisit(MetaDataVisitor vistor)
/*     */   {
/* 102 */     vistor.describeVisit(this);
/*     */   }
/*     */ 
/*     */   public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable
/*     */   {
/* 107 */     Stack visitorNodeStack = visitor.visitorNodeStack();
/*     */ 
/* 109 */     MetaDataVisitorNode node = (MetaDataVisitorNode)visitorNodeStack.pop();
/*     */     try
/*     */     {
/* 112 */       if ((node instanceof TypeProvider))
/*     */       {
/* 114 */         TypeProvider typeProvider = (TypeProvider)node;
/* 115 */         TypeInfo localTypeInfo = typeProvider.getType(visitor, this);
/*     */         return localTypeInfo;
/*     */       }
/* 119 */       throw new IllegalArgumentException("Node not of TypeProvider instance, cannot determine type info.");
/*     */     }
/*     */     finally
/*     */     {
/* 124 */       visitorNodeStack.push(node); } throw localObject;
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/* 130 */     if ((this.value instanceof MetaDataVisitorNode))
/* 131 */       return Collections.singletonList((MetaDataVisitorNode)this.value).iterator();
/* 132 */     return null;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 137 */     buffer.append("value=").append(this.value);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 142 */     buffer.append(this.value);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractValueMetaData
 * JD-Core Version:    0.6.0
 */