/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.beans.metadata.plugins.builder.MutableParameterizedMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.ParameterMetaData;
/*     */ import org.jboss.dependency.plugins.AbstractDependencyItem;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.dispatch.InvokeDispatchHelper;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractValueFactoryMetaData extends AbstractValueMetaData
/*     */   implements MutableParameterizedMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   protected transient KernelControllerContext context;
/*     */   protected String method;
/*     */   protected String parameter;
/*     */   protected String defaultValue;
/*     */   protected ControllerState whenRequiredState;
/*     */   protected ControllerState dependentState;
/*     */   protected List<ParameterMetaData> parameters;
/*     */ 
/*     */   public AbstractValueFactoryMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractValueFactoryMetaData(Object value)
/*     */   {
/* 100 */     super(value);
/*     */   }
/*     */ 
/*     */   public AbstractValueFactoryMetaData(Object value, String method)
/*     */   {
/* 111 */     this(value, method, null);
/*     */   }
/*     */ 
/*     */   public AbstractValueFactoryMetaData(Object value, String method, String defaultValue)
/*     */   {
/* 123 */     super(value);
/* 124 */     this.method = method;
/* 125 */     this.defaultValue = defaultValue;
/*     */   }
/*     */ 
/*     */   public String getMethod()
/*     */   {
/* 135 */     return this.method;
/*     */   }
/*     */ 
/*     */   public void setMethod(String method)
/*     */   {
/* 145 */     this.method = method;
/*     */   }
/*     */ 
/*     */   public String getParameter()
/*     */   {
/* 155 */     return this.parameter;
/*     */   }
/*     */ 
/*     */   public void setParameter(String parameter)
/*     */   {
/* 165 */     this.parameter = parameter;
/*     */   }
/*     */ 
/*     */   public void setWhenRequiredState(ControllerState whenRequiredState)
/*     */   {
/* 175 */     this.whenRequiredState = whenRequiredState;
/* 176 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public ControllerState getWhenRequiredState()
/*     */   {
/* 186 */     return this.whenRequiredState;
/*     */   }
/*     */ 
/*     */   public void setDependentState(ControllerState dependentState)
/*     */   {
/* 196 */     this.dependentState = dependentState;
/* 197 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public ControllerState getDependentState()
/*     */   {
/* 207 */     return this.dependentState;
/*     */   }
/*     */ 
/*     */   public String getDefaultValue()
/*     */   {
/* 217 */     return this.defaultValue;
/*     */   }
/*     */ 
/*     */   public void setDefaultValue(String defaultValue)
/*     */   {
/* 227 */     this.defaultValue = defaultValue;
/*     */   }
/*     */ 
/*     */   public List<ParameterMetaData> getParameters()
/*     */   {
/* 237 */     return this.parameters;
/*     */   }
/*     */ 
/*     */   public void setParameters(List<ParameterMetaData> parameters)
/*     */   {
/* 247 */     this.parameters = parameters;
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/* 252 */     this.context = visitor.getControllerContext();
/* 253 */     Object name = this.context.getName();
/* 254 */     Object iDependOn = getUnderlyingValue();
/*     */ 
/* 256 */     ControllerState whenRequired = this.whenRequiredState;
/* 257 */     if (whenRequired == null)
/*     */     {
/* 259 */       whenRequired = visitor.getContextState();
/*     */     }
/* 261 */     ControllerState state = this.dependentState;
/* 262 */     if (state == null)
/*     */     {
/* 264 */       state = ControllerState.INSTALLED;
/*     */     }
/*     */ 
/* 267 */     DependencyItem item = new AbstractDependencyItem(name, iDependOn, whenRequired, state);
/* 268 */     visitor.addDependency(item);
/* 269 */     super.initialVisit(visitor);
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/* 274 */     if (getParameters() != null)
/* 275 */       return getParameters().iterator();
/* 276 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable
/*     */   {
/* 281 */     ControllerState state = this.dependentState;
/* 282 */     if (state == null)
/* 283 */       state = ControllerState.INSTALLED;
/* 284 */     KernelController controller = (KernelController)this.context.getController();
/* 285 */     ControllerContext lookup = controller.getContext(getUnderlyingValue(), state);
/* 286 */     if (lookup == null)
/* 287 */       throw new Error("Should not be here - dependency failed - " + this);
/* 288 */     if (!(lookup instanceof InvokeDispatchContext)) {
/* 289 */       throw new IllegalArgumentException("Underlying context is not InvokeDispatchContext: " + this.context);
/*     */     }
/* 291 */     Kernel kernel = controller.getKernel();
/* 292 */     KernelConfigurator configurator = kernel.getConfigurator();
/* 293 */     Object result = InvokeDispatchHelper.invoke(configurator, lookup.getTarget(), (InvokeDispatchContext)lookup, getMethod(), getParameters());
/*     */ 
/* 300 */     if (result == null)
/* 301 */       result = this.defaultValue;
/* 302 */     return info != null ? info.convertValue(result) : result;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 307 */     super.toString(buffer);
/* 308 */     if (this.method != null)
/* 309 */       buffer.append(" method=").append(this.method);
/* 310 */     if (this.whenRequiredState != null)
/* 311 */       buffer.append(" whenRequiredState=").append(this.whenRequiredState.getStateString());
/* 312 */     if (this.dependentState != null)
/* 313 */       buffer.append(" dependentState=").append(this.dependentState.getStateString());
/* 314 */     if (this.defaultValue != null)
/* 315 */       buffer.append(" default=").append(this.defaultValue);
/* 316 */     if ((this.parameters != null) && (!this.parameters.isEmpty()))
/* 317 */       buffer.append(" parameters=").append(this.parameters);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractValueFactoryMetaData
 * JD-Core Version:    0.6.0
 */