/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Set;
/*     */ import java.util.Stack;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.ParameterMetaData;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractParameterMetaData extends AbstractFeatureMetaData
/*     */   implements ParameterMetaData, ValueMetaDataAware, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   protected String type;
/*     */   protected ValueMetaData value;
/*     */   protected int index;
/*     */ 
/*     */   public AbstractParameterMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractParameterMetaData(Object value)
/*     */   {
/*  79 */     this.type = value.getClass().getName();
/*  80 */     this.value = new AbstractValueMetaData(value);
/*     */   }
/*     */ 
/*     */   public AbstractParameterMetaData(ValueMetaData value)
/*     */   {
/*  90 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public AbstractParameterMetaData(String type, Object value)
/*     */   {
/* 101 */     this.type = type;
/* 102 */     this.value = new AbstractValueMetaData(value);
/*     */   }
/*     */ 
/*     */   public AbstractParameterMetaData(String type, String value)
/*     */   {
/* 113 */     this.type = type;
/* 114 */     this.value = new StringValueMetaData(value);
/*     */   }
/*     */ 
/*     */   public AbstractParameterMetaData(String type, ValueMetaData value)
/*     */   {
/* 125 */     this.type = type;
/* 126 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public String getType()
/*     */   {
/* 131 */     return this.type;
/*     */   }
/*     */ 
/*     */   public void setType(String type)
/*     */   {
/* 136 */     this.type = type;
/* 137 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public ValueMetaData getValue()
/*     */   {
/* 142 */     return this.value;
/*     */   }
/*     */ 
/*     */   public int getIndex()
/*     */   {
/* 147 */     return this.index;
/*     */   }
/*     */ 
/*     */   public void setIndex(int index)
/*     */   {
/* 152 */     this.index = index;
/*     */   }
/*     */ 
/*     */   public void setValue(ValueMetaData value)
/*     */   {
/* 157 */     this.value = value;
/* 158 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   protected void addChildren(Set<MetaDataVisitorNode> children)
/*     */   {
/* 163 */     super.addChildren(children);
/* 164 */     if (this.value != null)
/* 165 */       children.add(this.value);
/*     */   }
/*     */ 
/*     */   public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous)
/*     */     throws Throwable
/*     */   {
/*     */     KernelConfigurator configurator;
/* 170 */     if (this.type != null)
/*     */     {
/* 172 */       KernelControllerContext context = visitor.getControllerContext();
/* 173 */       ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
/* 174 */       KernelController controller = (KernelController)context.getController();
/* 175 */       configurator = controller.getKernel().getConfigurator();
/* 176 */       return applyCollectionOrMapCheck(configurator.getClassInfo(this.type, cl));
/*     */     }
/*     */ 
/* 180 */     Stack visitorNodeStack = visitor.visitorNodeStack();
/*     */ 
/* 182 */     MetaDataVisitorNode node = (MetaDataVisitorNode)visitorNodeStack.pop();
/*     */     try
/*     */     {
/* 185 */       if ((node instanceof TypeProvider))
/*     */       {
/* 187 */         TypeProvider typeProvider = (TypeProvider)node;
/* 188 */         configurator = typeProvider.getType(visitor, this);
/*     */         return configurator;
/*     */       }
/* 192 */       throw new IllegalArgumentException("Node not of TypeProvider instance, cannot determine type info.");
/*     */     }
/*     */     finally
/*     */     {
/* 197 */       visitorNodeStack.push(node); } throw localObject;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 204 */     buffer.append("type=").append(this.type);
/* 205 */     buffer.append(" value=").append(this.value);
/* 206 */     super.toString(buffer);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 211 */     buffer.append(this.type);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractParameterMetaData
 * JD-Core Version:    0.6.0
 */