/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class AbstractMapMetaData extends AbstractTypeMetaData
/*     */   implements Map<MetaDataVisitorNode, MetaDataVisitorNode>, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  50 */   private HashMap<MetaDataVisitorNode, MetaDataVisitorNode> map = new HashMap();
/*     */   protected String keyType;
/*     */   protected String valueType;
/*     */ 
/*     */   public String getKeyType()
/*     */   {
/*  72 */     return this.keyType;
/*     */   }
/*     */ 
/*     */   public void setKeyType(String keyType)
/*     */   {
/*  82 */     this.keyType = keyType;
/*     */   }
/*     */ 
/*     */   public String getValueType()
/*     */   {
/*  92 */     return this.valueType;
/*     */   }
/*     */ 
/*     */   public void setValueType(String valueType)
/*     */   {
/* 102 */     this.valueType = valueType;
/*     */   }
/*     */ 
/*     */   public Object getValue(TypeInfo info, ClassLoader cl)
/*     */     throws Throwable
/*     */   {
/* 108 */     Map result = (Map)getTypeInstance(info, cl, getExpectedClass());
/*     */ 
/* 110 */     TypeInfo keyTypeInfo = getKeyClassInfo(cl);
/* 111 */     TypeInfo valueTypeInfo = getValueClassInfo(cl);
/*     */     Iterator i;
/* 113 */     if (this.map.size() > 0)
/*     */     {
/* 115 */       for (i = this.map.entrySet().iterator(); i.hasNext(); )
/*     */       {
/* 117 */         Map.Entry entry = (Map.Entry)i.next();
/* 118 */         ValueMetaData key = (ValueMetaData)entry.getKey();
/* 119 */         ValueMetaData value = (ValueMetaData)entry.getValue();
/* 120 */         Object keyValue = key.getValue(keyTypeInfo, cl);
/* 121 */         Object valueValue = value.getValue(valueTypeInfo, cl);
/* 122 */         result.put(keyValue, valueValue);
/*     */       }
/*     */     }
/* 125 */     return result;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 130 */     this.map.clear();
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object key)
/*     */   {
/* 135 */     return this.map.containsKey(key);
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object value)
/*     */   {
/* 140 */     return this.map.containsValue(value);
/*     */   }
/*     */ 
/*     */   public Set<Map.Entry<MetaDataVisitorNode, MetaDataVisitorNode>> entrySet()
/*     */   {
/* 145 */     return this.map.entrySet();
/*     */   }
/*     */ 
/*     */   public MetaDataVisitorNode get(Object key)
/*     */   {
/* 150 */     return (MetaDataVisitorNode)this.map.get(key);
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 155 */     return this.map.isEmpty();
/*     */   }
/*     */ 
/*     */   public Set<MetaDataVisitorNode> keySet()
/*     */   {
/* 160 */     return this.map.keySet();
/*     */   }
/*     */ 
/*     */   public MetaDataVisitorNode put(MetaDataVisitorNode key, MetaDataVisitorNode value)
/*     */   {
/* 165 */     return (MetaDataVisitorNode)this.map.put(key, value);
/*     */   }
/*     */ 
/*     */   public void putAll(Map<? extends MetaDataVisitorNode, ? extends MetaDataVisitorNode> t)
/*     */   {
/* 170 */     this.map.putAll(t);
/*     */   }
/*     */ 
/*     */   public MetaDataVisitorNode remove(Object key)
/*     */   {
/* 175 */     return (MetaDataVisitorNode)this.map.remove(key);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 180 */     return this.map.size();
/*     */   }
/*     */ 
/*     */   public Collection<MetaDataVisitorNode> values()
/*     */   {
/* 185 */     return this.map.values();
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/* 190 */     ArrayList children = new ArrayList(keySet());
/* 191 */     children.addAll(values());
/* 192 */     return children.iterator();
/*     */   }
/*     */ 
/*     */   public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable
/*     */   {
/* 197 */     if (this.keyType != null)
/*     */     {
/* 199 */       for (MetaDataVisitorNode key : keySet())
/*     */       {
/* 201 */         if (previous.equals(key))
/*     */         {
/* 203 */           return getClass(visitor, this.keyType);
/*     */         }
/*     */       }
/*     */     }
/* 207 */     if (this.valueType != null)
/*     */     {
/* 209 */       for (MetaDataVisitorNode v : values())
/*     */       {
/* 211 */         if (previous.equals(v))
/*     */         {
/* 213 */           return getClass(visitor, this.valueType);
/*     */         }
/*     */       }
/*     */     }
/* 217 */     return super.getType(visitor, previous);
/*     */   }
/*     */ 
/*     */   protected Object getDefaultInstance()
/*     */   {
/* 227 */     return new HashMap();
/*     */   }
/*     */ 
/*     */   protected Class<? extends Map> getExpectedClass()
/*     */   {
/* 232 */     return Map.class;
/*     */   }
/*     */ 
/*     */   protected ClassInfo getKeyClassInfo(ClassLoader cl)
/*     */     throws Throwable
/*     */   {
/* 244 */     if (this.keyType == null) {
/* 245 */       return null;
/*     */     }
/* 247 */     return this.configurator.getClassInfo(this.keyType, cl);
/*     */   }
/*     */ 
/*     */   protected ClassInfo getValueClassInfo(ClassLoader cl)
/*     */     throws Throwable
/*     */   {
/* 259 */     if (this.valueType == null) {
/* 260 */       return null;
/*     */     }
/* 262 */     return this.configurator.getClassInfo(this.valueType, cl);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractMapMetaData
 * JD-Core Version:    0.6.0
 */