/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.LazyMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.dependency.plugins.AbstractDependencyItem;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ 
/*     */ public class AbstractLazyMetaData extends AbstractBeanMetaData
/*     */   implements LazyMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String beanName;
/*     */   private boolean exposeClass;
/*     */   private Set<String> interfaces;
/*     */   private String factoryClassName;
/*     */ 
/*     */   public AbstractLazyMetaData()
/*     */   {
/*  57 */     setAutowireCandidate(false);
/*  58 */     setFactoryClassName("org.jboss.kernel.spi.lazy.LazyProxyFactory");
/*     */   }
/*     */ 
/*     */   public AbstractLazyMetaData(String beanName)
/*     */   {
/*  63 */     this();
/*  64 */     this.beanName = beanName;
/*  65 */     setName(beanName + "Proxy");
/*     */   }
/*     */ 
/*     */   public Object getUnderlyingValue()
/*     */   {
/*  70 */     return this.beanName;
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor vistor)
/*     */   {
/*  75 */     if (this.beanName == null) {
/*  76 */       throw new IllegalArgumentException("Null bean name.");
/*     */     }
/*  78 */     KernelController controller = (KernelController)vistor.getControllerContext().getController();
/*  79 */     Kernel kernel = controller.getKernel();
/*  80 */     AbstractConstructorMetaData constructor = new AbstractConstructorMetaData();
/*  81 */     constructor.setFactoryClass(this.factoryClassName);
/*  82 */     constructor.setFactoryMethod("getProxy");
/*  83 */     List parameters = new ArrayList();
/*  84 */     parameters.add(new AbstractParameterMetaData(kernel));
/*  85 */     parameters.add(new AbstractParameterMetaData(this.beanName));
/*  86 */     parameters.add(new AbstractParameterMetaData(Boolean.TYPE.getName(), Boolean.valueOf(this.exposeClass)));
/*  87 */     parameters.add(new AbstractParameterMetaData(new AbstractValueMetaData(this.interfaces)));
/*  88 */     constructor.setParameters(parameters);
/*  89 */     setConstructor(constructor);
/*     */ 
/*  91 */     vistor.addDependency(new AbstractDependencyItem(this.name, this.beanName, ControllerState.INSTANTIATED, ControllerState.DESCRIBED));
/*  92 */     super.initialVisit(vistor);
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/*  97 */     return null;
/*     */   }
/*     */ 
/*     */   public List<BeanMetaData> getBeans()
/*     */   {
/* 102 */     return Collections.singletonList(this);
/*     */   }
/*     */ 
/*     */   protected void setFactoryClassName(String factoryClassName)
/*     */   {
/* 107 */     this.factoryClassName = factoryClassName;
/*     */   }
/*     */ 
/*     */   public String getBeanName()
/*     */   {
/* 112 */     return this.beanName;
/*     */   }
/*     */ 
/*     */   public void setBeanName(String beanName)
/*     */   {
/* 117 */     this.beanName = beanName;
/* 118 */     if (this.name == null)
/* 119 */       setName(beanName + "Proxy");
/*     */   }
/*     */ 
/*     */   public boolean isExposeClass()
/*     */   {
/* 124 */     return this.exposeClass;
/*     */   }
/*     */ 
/*     */   public void setExposeClass(boolean exposeClass)
/*     */   {
/* 129 */     this.exposeClass = exposeClass;
/*     */   }
/*     */ 
/*     */   public Set<String> getInterfaces()
/*     */   {
/* 134 */     return this.interfaces;
/*     */   }
/*     */ 
/*     */   public void setInterfaces(Set<String> interfaces)
/*     */   {
/* 139 */     this.interfaces = interfaces;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractLazyMetaData
 * JD-Core Version:    0.6.0
 */