/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.beans.metadata.spi.InstallMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.dependency.plugins.AbstractDependencyItem;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractInstallMetaData extends AbstractLifecycleMetaData
/*     */   implements InstallMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   protected String bean;
/*  53 */   protected ControllerState dependentState = ControllerState.INSTALLED;
/*     */ 
/*     */   public AbstractInstallMetaData()
/*     */   {
/*  60 */     setState(ControllerState.INSTALLED);
/*     */   }
/*     */ 
/*     */   public String getBean()
/*     */   {
/*  65 */     return this.bean;
/*     */   }
/*     */ 
/*     */   public void setBean(String bean)
/*     */   {
/*  75 */     this.bean = bean;
/*     */   }
/*     */ 
/*     */   public void setDependentState(ControllerState dependentState)
/*     */   {
/*  85 */     this.dependentState = dependentState;
/*  86 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public ControllerState getDependentState()
/*     */   {
/*  91 */     return this.dependentState;
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/*  96 */     KernelControllerContext context = visitor.getControllerContext();
/*  97 */     if (this.bean != null)
/*     */     {
/*  99 */       DependencyItem item = new InstallationDependencyItem(context.getName());
/* 100 */       visitor.addDependency(item);
/*     */     }
/* 102 */     super.initialVisit(visitor);
/*     */   }
/*     */ 
/*     */   protected ClassInfo getClassInfo(KernelControllerContext context) throws Throwable
/*     */   {
/* 107 */     if (this.bean != null)
/*     */     {
/* 109 */       KernelController controller = (KernelController)context.getController();
/* 110 */       ControllerContext beanContext = controller.getContext(this.bean, ControllerState.INSTANTIATED);
/* 111 */       if (beanContext != null)
/*     */       {
/* 113 */         KernelConfigurator configurator = controller.getKernel().getConfigurator();
/* 114 */         Object target = beanContext.getTarget();
/* 115 */         return configurator.getClassInfo(target.getClass());
/*     */       }
/*     */ 
/* 119 */       throw new IllegalArgumentException("Cannot determine install bean class: " + this);
/*     */     }
/*     */ 
/* 122 */     return super.getClassInfo(context);
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 127 */     if (this.bean != null)
/* 128 */       buffer.append("bean=").append(this.bean);
/* 129 */     if (!ControllerState.INSTALLED.equals(this.dependentState))
/* 130 */       buffer.append(" dependentState=" + this.dependentState);
/* 131 */     buffer.append(" ");
/* 132 */     super.toString(buffer);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 137 */     if (this.bean != null)
/*     */     {
/* 139 */       buffer.append(this.bean).append(".");
/*     */     }
/* 141 */     if (this.methodName != null)
/* 142 */       buffer.append(this.methodName);
/*     */   }
/*     */ 
/*     */   public class InstallationDependencyItem extends AbstractDependencyItem
/*     */   {
/*     */     public InstallationDependencyItem(Object name)
/*     */     {
/* 157 */       super(AbstractInstallMetaData.this.bean, AbstractInstallMetaData.this.state, AbstractInstallMetaData.this.dependentState);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractInstallMetaData
 * JD-Core Version:    0.6.0
 */