/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.metadata.spi.AnnotationMetaData;
/*     */ import org.jboss.beans.metadata.spi.FeatureMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.collection.CollectionsFactory;
/*     */ 
/*     */ public abstract class AbstractFeatureMetaData extends JBossObject
/*     */   implements FeatureMetaData, TypeProvider, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   protected String description;
/*     */   protected Set<AnnotationMetaData> annotations;
/*     */ 
/*     */   public void setDescription(String description)
/*     */   {
/*  69 */     this.description = description;
/*  70 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void setAnnotations(Set<AnnotationMetaData> annotations)
/*     */   {
/*  80 */     this.annotations = annotations;
/*  81 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public String getDescription()
/*     */   {
/*  86 */     return this.description;
/*     */   }
/*     */ 
/*     */   public Set<AnnotationMetaData> getAnnotations()
/*     */   {
/*  91 */     return this.annotations;
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/*  96 */     visitor.initialVisit(this);
/*     */   }
/*     */ 
/*     */   public void describeVisit(MetaDataVisitor vistor)
/*     */   {
/* 101 */     vistor.describeVisit(this);
/*     */   }
/*     */ 
/*     */   protected TypeInfo applyCollectionOrMapCheck(TypeInfo typeInfo)
/*     */     throws Throwable
/*     */   {
/* 107 */     if ((typeInfo instanceof ClassInfo))
/*     */     {
/* 109 */       ClassInfo classInfo = (ClassInfo)typeInfo;
/* 110 */       TypeInfo componentType = classInfo.getComponentType();
/* 111 */       if (componentType != null)
/* 112 */         return componentType;
/*     */     }
/* 114 */     if ((typeInfo.isCollection()) || (typeInfo.isMap()))
/*     */     {
/* 116 */       throw new IllegalArgumentException("Should not be here - set element/value class type in collection/map: " + this);
/*     */     }
/* 118 */     return typeInfo;
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/* 123 */     Set children = CollectionsFactory.createLazySet();
/* 124 */     addChildren(children);
/* 125 */     if (children.size() == 0) {
/* 126 */       return null;
/*     */     }
/* 128 */     return children.iterator();
/*     */   }
/*     */ 
/*     */   protected void addChildren(Set<MetaDataVisitorNode> children)
/*     */   {
/* 133 */     if ((this.annotations != null) && (this.annotations.size() > 0))
/* 134 */       children.addAll(this.annotations);
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 139 */     if (this.description != null)
/* 140 */       buffer.append("description=").append(this.description);
/* 141 */     if (this.annotations != null)
/* 142 */       buffer.append(" annotations=").append(this.annotations);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 147 */     buffer.append(this.description);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractFeatureMetaData
 * JD-Core Version:    0.6.0
 */