/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.beans.metadata.spi.DependencyMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.dependency.plugins.AbstractDependencyItem;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.util.HashCode;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractDependencyMetaData extends JBossObject
/*     */   implements DependencyMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   protected Object dependency;
/*     */ 
/*     */   public AbstractDependencyMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractDependencyMetaData(Object dependency)
/*     */   {
/*  66 */     this.dependency = dependency;
/*     */   }
/*     */ 
/*     */   public void setDependency(Object dependency)
/*     */   {
/*  76 */     this.dependency = dependency;
/*  77 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public Object getDependency()
/*     */   {
/*  82 */     return this.dependency;
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/*  87 */     KernelControllerContext context = visitor.getControllerContext();
/*  88 */     DependencyItem item = new LifecycleDependencyItem(context.getName(), ControllerState.CREATE);
/*  89 */     visitor.addDependency(item);
/*  90 */     item = new LifecycleDependencyItem(context.getName(), ControllerState.START);
/*  91 */     visitor.addDependency(item);
/*     */ 
/*  93 */     visitor.initialVisit(this);
/*     */   }
/*     */ 
/*     */   public void describeVisit(MetaDataVisitor vistor)
/*     */   {
/*  98 */     vistor.describeVisit(this);
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/* 103 */     return null;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 108 */     buffer.append("dependency=").append(this.dependency);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 113 */     buffer.append(this.dependency);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 118 */     if (!(obj instanceof AbstractDependencyMetaData))
/* 119 */       return false;
/* 120 */     return equals(this.dependency, ((AbstractDependencyMetaData)obj).dependency);
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 125 */     return HashCode.generate(this.dependency);
/*     */   }
/*     */ 
/*     */   public class LifecycleDependencyItem extends AbstractDependencyItem
/*     */   {
/*     */     public LifecycleDependencyItem(Object name, ControllerState state)
/*     */     {
/* 141 */       super(AbstractDependencyMetaData.this.dependency, state, state);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractDependencyMetaData
 * JD-Core Version:    0.6.0
 */