/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.Stack;
/*     */ import org.jboss.beans.metadata.spi.AutowireType;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
/*     */ import org.jboss.beans.metadata.spi.CallbackMetaData;
/*     */ import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
/*     */ import org.jboss.beans.metadata.spi.ConstructorMetaData;
/*     */ import org.jboss.beans.metadata.spi.DemandMetaData;
/*     */ import org.jboss.beans.metadata.spi.DependencyMetaData;
/*     */ import org.jboss.beans.metadata.spi.InstallMetaData;
/*     */ import org.jboss.beans.metadata.spi.LifecycleMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.PropertyMetaData;
/*     */ import org.jboss.beans.metadata.spi.SupplyMetaData;
/*     */ import org.jboss.dependency.plugins.AbstractDependencyItem;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerMode;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.managed.api.annotation.ManagementObject;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ @ManagementObject
/*     */ public class AbstractBeanMetaData extends AbstractFeatureMetaData
/*     */   implements BeanMetaData, BeanMetaDataFactory, MutableLifecycleHolder, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*     */   protected String bean;
/*     */   protected String name;
/*     */   protected Set<Object> aliases;
/*     */   protected String parent;
/*     */   protected boolean isAbstract;
/*     */   protected AutowireType autowireType;
/*     */   protected ControllerMode mode;
/*  92 */   protected boolean autowireCandidate = true;
/*     */   private Set<PropertyMetaData> properties;
/*     */   protected ClassLoaderMetaData classLoader;
/*     */   protected ConstructorMetaData constructor;
/*     */   protected LifecycleMetaData create;
/*     */   protected LifecycleMetaData start;
/*     */   protected LifecycleMetaData stop;
/*     */   protected LifecycleMetaData destroy;
/*     */   protected Set<DemandMetaData> demands;
/*     */   protected Set<SupplyMetaData> supplies;
/*     */   protected Set<DependencyMetaData> depends;
/*     */   protected List<InstallMetaData> installs;
/*     */   protected List<InstallMetaData> uninstalls;
/*     */   protected List<CallbackMetaData> installCallbacks;
/*     */   protected List<CallbackMetaData> uninstallCallbacks;
/*     */   protected transient ControllerContext context;
/*     */ 
/*     */   public AbstractBeanMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractBeanMetaData(String bean)
/*     */   {
/* 154 */     this.bean = bean;
/*     */   }
/*     */ 
/*     */   public AbstractBeanMetaData(String name, String bean)
/*     */   {
/* 164 */     this.name = name;
/* 165 */     this.bean = bean;
/*     */   }
/*     */ 
/*     */   public List<BeanMetaData> getBeans()
/*     */   {
/* 170 */     List nestedBeans = findNestedBeans();
/* 171 */     if (nestedBeans.isEmpty())
/*     */     {
/* 173 */       return Collections.singletonList(this);
/*     */     }
/*     */ 
/* 177 */     nestedBeans.add(this);
/* 178 */     return nestedBeans;
/*     */   }
/*     */ 
/*     */   protected List<BeanMetaData> findNestedBeans()
/*     */   {
/* 184 */     List allBeans = new ArrayList();
/* 185 */     addBeans(this, allBeans);
/* 186 */     return allBeans;
/*     */   }
/*     */ 
/*     */   protected void addBeans(MetaDataVisitorNode current, List<BeanMetaData> list)
/*     */   {
/* 191 */     for (Iterator children = current.getChildren(); (children != null) && (children.hasNext()); )
/*     */     {
/* 193 */       MetaDataVisitorNode next = (MetaDataVisitorNode)children.next();
/* 194 */       if ((next instanceof BeanMetaDataFactory))
/*     */       {
/* 196 */         list.addAll(((BeanMetaDataFactory)next).getBeans());
/*     */       }
/*     */       else
/*     */       {
/* 200 */         addBeans(next, list);
/* 201 */         if ((next instanceof Serializable))
/*     */         {
/* 203 */           list.add((Serializable)current);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getBean()
/*     */   {
/* 215 */     return this.bean;
/*     */   }
/*     */ 
/*     */   public void setBean(String bean)
/*     */   {
/* 225 */     this.bean = bean;
/* 226 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public PropertyMetaData getProperty(String name)
/*     */   {
/* 237 */     if (name == null)
/* 238 */       throw new IllegalArgumentException("Null name");
/* 239 */     if ((this.properties != null) && (this.properties.size() > 0))
/*     */     {
/* 241 */       for (PropertyMetaData prop : this.properties)
/*     */       {
/* 243 */         if (name.equals(prop.getName()))
/* 244 */           return prop;
/*     */       }
/*     */     }
/* 247 */     return null;
/*     */   }
/*     */ 
/*     */   public void addProperty(PropertyMetaData property)
/*     */   {
/* 257 */     if (property == null)
/* 258 */       throw new IllegalArgumentException("Null property");
/* 259 */     if (this.properties == null)
/* 260 */       this.properties = new HashSet();
/* 261 */     this.properties.add(property);
/* 262 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void setProperties(Set<PropertyMetaData> properties)
/*     */   {
/* 272 */     this.properties = properties;
/* 273 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public ClassLoaderMetaData getClassLoader()
/*     */   {
/* 278 */     return this.classLoader;
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoaderMetaData classLoader)
/*     */   {
/* 283 */     this.classLoader = classLoader;
/*     */   }
/*     */ 
/*     */   public void setConstructor(ConstructorMetaData constructor)
/*     */   {
/* 293 */     this.constructor = constructor;
/*     */   }
/*     */ 
/*     */   public void setDemands(Set<DemandMetaData> demands)
/*     */   {
/* 303 */     this.demands = demands;
/* 304 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void setSupplies(Set<SupplyMetaData> supplies)
/*     */   {
/* 314 */     this.supplies = supplies;
/* 315 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void setDepends(Set<DependencyMetaData> depends)
/*     */   {
/* 325 */     this.depends = depends;
/* 326 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 331 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 341 */     this.name = name;
/* 342 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public Set<Object> getAliases()
/*     */   {
/* 347 */     return this.aliases;
/*     */   }
/*     */ 
/*     */   public void setAliases(Set<Object> aliases)
/*     */   {
/* 352 */     this.aliases = aliases;
/*     */   }
/*     */ 
/*     */   public String getParent()
/*     */   {
/* 357 */     return this.parent;
/*     */   }
/*     */ 
/*     */   public void setParent(String parent)
/*     */   {
/* 367 */     this.parent = parent;
/*     */   }
/*     */ 
/*     */   public boolean isAbstract()
/*     */   {
/* 372 */     return this.isAbstract;
/*     */   }
/*     */ 
/*     */   public void setAbstract(boolean anAbstract)
/*     */   {
/* 382 */     this.isAbstract = anAbstract;
/*     */   }
/*     */ 
/*     */   public AutowireType getAutowireType()
/*     */   {
/* 387 */     return this.autowireType;
/*     */   }
/*     */ 
/*     */   public void setAutowireType(AutowireType autowireType)
/*     */   {
/* 397 */     this.autowireType = autowireType;
/*     */   }
/*     */ 
/*     */   public ControllerMode getMode()
/*     */   {
/* 402 */     return this.mode;
/*     */   }
/*     */ 
/*     */   public void setMode(ControllerMode mode)
/*     */   {
/* 407 */     this.mode = mode;
/* 408 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public boolean isAutowireCandidate()
/*     */   {
/* 413 */     return this.autowireCandidate;
/*     */   }
/*     */ 
/*     */   public void setAutowireCandidate(boolean autowireCandidate)
/*     */   {
/* 418 */     this.autowireCandidate = autowireCandidate;
/*     */   }
/*     */ 
/*     */   public Set<PropertyMetaData> getProperties()
/*     */   {
/* 423 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public ConstructorMetaData getConstructor()
/*     */   {
/* 428 */     return this.constructor;
/*     */   }
/*     */ 
/*     */   public LifecycleMetaData getCreate()
/*     */   {
/* 433 */     return this.create;
/*     */   }
/*     */ 
/*     */   public void setCreate(LifecycleMetaData lifecycle)
/*     */   {
/* 443 */     lifecycle.setState(ControllerState.CREATE);
/* 444 */     this.create = lifecycle;
/*     */   }
/*     */ 
/*     */   public LifecycleMetaData getStart()
/*     */   {
/* 449 */     return this.start;
/*     */   }
/*     */ 
/*     */   public void setStart(LifecycleMetaData lifecycle)
/*     */   {
/* 459 */     lifecycle.setState(ControllerState.START);
/* 460 */     this.start = lifecycle;
/*     */   }
/*     */ 
/*     */   public LifecycleMetaData getStop()
/*     */   {
/* 465 */     return this.stop;
/*     */   }
/*     */ 
/*     */   public void setStop(LifecycleMetaData lifecycle)
/*     */   {
/* 475 */     lifecycle.setState(ControllerState.START);
/* 476 */     this.stop = lifecycle;
/*     */   }
/*     */ 
/*     */   public LifecycleMetaData getDestroy()
/*     */   {
/* 481 */     return this.destroy;
/*     */   }
/*     */ 
/*     */   public void setDestroy(LifecycleMetaData lifecycle)
/*     */   {
/* 491 */     lifecycle.setState(ControllerState.CREATE);
/* 492 */     this.destroy = lifecycle;
/*     */   }
/*     */ 
/*     */   public Set<DemandMetaData> getDemands()
/*     */   {
/* 497 */     return this.demands;
/*     */   }
/*     */ 
/*     */   public Set<SupplyMetaData> getSupplies()
/*     */   {
/* 502 */     return this.supplies;
/*     */   }
/*     */ 
/*     */   public Set<DependencyMetaData> getDepends()
/*     */   {
/* 507 */     return this.depends;
/*     */   }
/*     */ 
/*     */   public List<InstallMetaData> getInstalls()
/*     */   {
/* 512 */     return this.installs;
/*     */   }
/*     */ 
/*     */   public void setInstalls(List<InstallMetaData> installs)
/*     */   {
/* 522 */     this.installs = installs;
/* 523 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public List<InstallMetaData> getUninstalls()
/*     */   {
/* 528 */     return this.uninstalls;
/*     */   }
/*     */ 
/*     */   public void setUninstalls(List<InstallMetaData> uninstalls)
/*     */   {
/* 538 */     this.uninstalls = uninstalls;
/* 539 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public List<CallbackMetaData> getInstallCallbacks()
/*     */   {
/* 544 */     return this.installCallbacks;
/*     */   }
/*     */ 
/*     */   public void setInstallCallbacks(List<CallbackMetaData> installCallbacks)
/*     */   {
/* 549 */     this.installCallbacks = installCallbacks;
/* 550 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public List<CallbackMetaData> getUninstallCallbacks()
/*     */   {
/* 555 */     return this.uninstallCallbacks;
/*     */   }
/*     */ 
/*     */   public void setUninstallCallbacks(List<CallbackMetaData> uninstallCallbacks)
/*     */   {
/* 560 */     this.uninstallCallbacks = uninstallCallbacks;
/* 561 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/* 566 */     KernelControllerContext ctx = visitor.getControllerContext();
/* 567 */     if (ctx.getBeanMetaData() == this)
/* 568 */       this.context = ctx;
/* 569 */     boolean isInnerBean = !visitor.visitorNodeStack().isEmpty();
/* 570 */     if (isInnerBean)
/*     */     {
/* 572 */       Object name = ctx.getName();
/* 573 */       Object iDependOn = getUnderlyingValue();
/* 574 */       ControllerState whenRequired = visitor.getContextState();
/* 575 */       DependencyItem di = new AbstractDependencyItem(name, iDependOn, whenRequired, ControllerState.INSTALLED);
/* 576 */       visitor.addDependency(di);
/*     */     }
/* 578 */     super.initialVisit(visitor);
/*     */   }
/*     */ 
/*     */   protected void addChildren(Set<MetaDataVisitorNode> children)
/*     */   {
/* 583 */     super.addChildren(children);
/* 584 */     if ((this.classLoader != null) && (this.classLoader.getClassLoader() != this))
/* 585 */       children.add(this.classLoader);
/* 586 */     if (this.constructor != null)
/* 587 */       children.add(this.constructor);
/* 588 */     if (this.properties != null)
/* 589 */       children.addAll(this.properties);
/* 590 */     if (this.create != null)
/* 591 */       children.add(this.create);
/* 592 */     if (this.start != null)
/* 593 */       children.add(this.start);
/* 594 */     if (this.stop != null)
/* 595 */       children.add(this.stop);
/* 596 */     if (this.destroy != null)
/* 597 */       children.add(this.destroy);
/* 598 */     if (this.demands != null)
/* 599 */       children.addAll(this.demands);
/* 600 */     if (this.supplies != null)
/* 601 */       children.addAll(this.supplies);
/* 602 */     if (this.depends != null)
/* 603 */       children.addAll(this.depends);
/* 604 */     if (this.installs != null)
/* 605 */       children.addAll(this.installs);
/* 606 */     if (this.uninstalls != null)
/* 607 */       children.addAll(this.uninstalls);
/* 608 */     if (this.installCallbacks != null)
/* 609 */       children.addAll(this.installCallbacks);
/* 610 */     if (this.uninstallCallbacks != null)
/* 611 */       children.addAll(this.uninstallCallbacks);
/*     */   }
/*     */ 
/*     */   public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable
/*     */   {
/* 616 */     throw new IllegalArgumentException("Cannot determine inject class type: " + this);
/*     */   }
/*     */ 
/*     */   public Object getUnderlyingValue()
/*     */   {
/* 621 */     return this.name;
/*     */   }
/*     */ 
/*     */   public Object getValue(TypeInfo info, ClassLoader cl)
/*     */     throws Throwable
/*     */   {
/* 627 */     Controller controller = this.context.getController();
/* 628 */     ControllerContext lookup = controller.getInstalledContext(this.name);
/* 629 */     if ((lookup == null) || (lookup.getTarget() == null))
/*     */     {
/* 632 */       if ((info == null) && (this.classLoader != null) && (this.classLoader.getClassLoader() == this))
/*     */       {
/* 634 */         return cl;
/*     */       }
/* 636 */       throw new IllegalArgumentException("Bean not yet installed: " + this.name);
/*     */     }
/* 638 */     Object target = lookup.getTarget();
/*     */ 
/* 640 */     if ((info != null) && (!info.getType().isAssignableFrom(target.getClass())))
/*     */     {
/* 642 */       throw new ClassCastException(target + " is not a " + info);
/*     */     }
/* 644 */     return target;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 649 */     buffer.append("name=").append(this.name);
/* 650 */     if (this.aliases != null)
/* 651 */       buffer.append(" aliases=").append(this.aliases);
/* 652 */     buffer.append(" bean=").append(this.bean);
/* 653 */     buffer.append(" properties=");
/* 654 */     JBossObject.list(buffer, this.properties);
/* 655 */     if ((this.classLoader != null) && (this.classLoader.getClassLoader() != this))
/* 656 */       buffer.append(" classLoader=").append(this.classLoader);
/* 657 */     buffer.append(" constructor=").append(this.constructor);
/* 658 */     buffer.append(" autowireCandidate=").append(this.autowireCandidate);
/* 659 */     if (this.create != null)
/* 660 */       buffer.append(" create=").append(this.create);
/* 661 */     if (this.start != null)
/* 662 */       buffer.append(" start=").append(this.start);
/* 663 */     if (this.stop != null)
/* 664 */       buffer.append(" stop=").append(this.stop);
/* 665 */     if (this.destroy != null)
/* 666 */       buffer.append(" destroy=").append(this.destroy);
/* 667 */     if (this.demands != null)
/*     */     {
/* 669 */       buffer.append(" demands=");
/* 670 */       JBossObject.list(buffer, this.demands);
/*     */     }
/* 672 */     super.toString(buffer);
/* 673 */     if (this.supplies != null)
/*     */     {
/* 675 */       buffer.append(" supplies=");
/* 676 */       JBossObject.list(buffer, this.supplies);
/*     */     }
/* 678 */     if (this.depends != null)
/*     */     {
/* 680 */       buffer.append(" depends=");
/* 681 */       JBossObject.list(buffer, this.depends);
/*     */     }
/* 683 */     if (this.installs != null)
/*     */     {
/* 685 */       buffer.append(" installs=");
/* 686 */       JBossObject.list(buffer, this.installs);
/*     */     }
/* 688 */     if (this.uninstalls != null)
/*     */     {
/* 690 */       buffer.append(" uninstalls=");
/* 691 */       JBossObject.list(buffer, this.uninstalls);
/*     */     }
/* 693 */     if (this.installCallbacks != null)
/*     */     {
/* 695 */       buffer.append(" installCallbacks=");
/* 696 */       JBossObject.list(buffer, this.installCallbacks);
/*     */     }
/* 698 */     if (this.uninstallCallbacks != null)
/*     */     {
/* 700 */       buffer.append(" uninstallCallbacks=");
/* 701 */       JBossObject.list(buffer, this.uninstallCallbacks);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 707 */     buffer.append(this.bean);
/* 708 */     buffer.append('/');
/* 709 */     buffer.append(this.name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractBeanMetaData
 * JD-Core Version:    0.6.0
 */