/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class AbstractArrayMetaData extends AbstractListMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */ 
/*     */   public Object getValue(TypeInfo info, ClassLoader cl)
/*     */     throws Throwable
/*     */   {
/*  51 */     Collection result = (Collection)super.getValue(info, cl);
/*     */ 
/*  53 */     TypeInfo typeInfo = getClassInfo(cl);
/*     */ 
/*  55 */     if ((typeInfo != null) && (!(typeInfo instanceof ClassInfo))) {
/*  56 */       throw new IllegalArgumentException(typeInfo.getName() + " is not a class");
/*     */     }
/*  58 */     if (typeInfo == null)
/*     */     {
/*  61 */       if (info == null)
/*     */       {
/*  63 */         info = getElementClassInfo(cl, null);
/*  64 */         if (info == null)
/*  65 */           return null;
/*  66 */         info = info.getArrayType();
/*     */       }
/*     */ 
/*  69 */       if (!(info instanceof ClassInfo)) {
/*  70 */         return null;
/*     */       }
/*  72 */       if (((ClassInfo)info).isInterface()) {
/*  73 */         return null;
/*     */       }
/*  75 */       if (Object.class.getName().equals(info.getName())) {
/*  76 */         return null;
/*     */       }
/*  78 */       typeInfo = info;
/*     */     }
/*     */ 
/*  81 */     Object array = typeInfo.newArrayInstance(result.size());
/*  82 */     int i = 0;
/*  83 */     for (Iterator i$ = result.iterator(); i$.hasNext(); ) { Object element = i$.next();
/*  84 */       Array.set(array, i++, element); }
/*  85 */     return array;
/*     */   }
/*     */ 
/*     */   protected <T> T getTypeInstance(TypeInfo info, ClassLoader cl, Class<T> expected) throws Throwable
/*     */   {
/*  90 */     Collection result = new ArrayList();
/*  91 */     Object preinstantiatedObject = preinstantiatedLookup(cl, [Ljava.lang.Object.class);
/*  92 */     if (preinstantiatedObject != null)
/*     */     {
/*  94 */       Object[] preinstantiatedArray = (Object[])(Object[])preinstantiatedObject;
/*  95 */       for (Object previous : preinstantiatedArray)
/*     */       {
/*  97 */         result.add(previous);
/*     */       }
/*     */     }
/* 100 */     return expected.cast(result);
/*     */   }
/*     */ 
/*     */   protected <T> T checkResult(Object result, Class<T> expected)
/*     */   {
/* 105 */     if (result != null)
/*     */     {
/* 107 */       if (!result.getClass().isArray())
/* 108 */         throw new ClassCastException("Preinstantiated property is not an array: " + this.propertyName);
/*     */     }
/* 110 */     return expected.cast(result);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractArrayMetaData
 * JD-Core Version:    0.6.0
 */