/*     */ package org.jboss.beans.info.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.reflect.plugins.AnnotationHolder;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractPropertyInfo extends AnnotationHolder
/*     */   implements PropertyInfo, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*     */   protected transient BeanInfo beanInfo;
/*     */   protected String name;
/*     */   protected String upperName;
/*     */   protected TypeInfo type;
/*     */   protected MethodInfo getter;
/*     */   protected MethodInfo setter;
/*     */ 
/*     */   public AbstractPropertyInfo()
/*     */   {
/*  69 */     this(null, null, null, null, null);
/*     */   }
/*     */ 
/*     */   public AbstractPropertyInfo(String name)
/*     */   {
/*  79 */     this(name, name, null, null, null);
/*     */   }
/*     */ 
/*     */   public AbstractPropertyInfo(String name, String upperName, TypeInfo type, MethodInfo getter, MethodInfo setter)
/*     */   {
/*  93 */     this.name = name;
/*  94 */     this.upperName = upperName;
/*  95 */     this.type = type;
/*  96 */     this.getter = getter;
/*  97 */     this.setter = setter;
/*     */   }
/*     */ 
/*     */   public AbstractPropertyInfo(String name, String upperName, TypeInfo type, MethodInfo getter, MethodInfo setter, AnnotationValue[] annotations)
/*     */   {
/* 112 */     super(annotations);
/* 113 */     this.name = name;
/* 114 */     this.upperName = upperName;
/* 115 */     this.type = type;
/* 116 */     this.getter = getter;
/* 117 */     this.setter = setter;
/*     */   }
/*     */ 
/*     */   public BeanInfo getBeanInfo()
/*     */   {
/* 122 */     return this.beanInfo;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 127 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getUpperName()
/*     */   {
/* 132 */     return this.upperName;
/*     */   }
/*     */ 
/*     */   public TypeInfo getType()
/*     */   {
/* 137 */     return this.type;
/*     */   }
/*     */ 
/*     */   public void setType(TypeInfo type)
/*     */   {
/* 142 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public MethodInfo getGetter()
/*     */   {
/* 147 */     return this.getter;
/*     */   }
/*     */ 
/*     */   public void setGetter(MethodInfo getter)
/*     */   {
/* 152 */     this.getter = getter;
/*     */   }
/*     */ 
/*     */   public MethodInfo getSetter()
/*     */   {
/* 157 */     return this.setter;
/*     */   }
/*     */ 
/*     */   public void setSetter(MethodInfo setter)
/*     */   {
/* 162 */     this.setter = setter;
/*     */   }
/*     */ 
/*     */   public Object get(Object bean) throws Throwable
/*     */   {
/* 167 */     if (bean == null)
/* 168 */       throw new IllegalArgumentException("Null bean");
/* 169 */     if (this.getter == null) {
/* 170 */       throw new IllegalArgumentException("Property is not readable: " + getName() + " for " + this.beanInfo.getName());
/*     */     }
/* 172 */     return this.getter.invoke(bean, null);
/*     */   }
/*     */ 
/*     */   public void set(Object bean, Object value) throws Throwable
/*     */   {
/* 177 */     if (bean == null)
/* 178 */       throw new IllegalArgumentException("Null bean");
/* 179 */     if (this.setter == null) {
/* 180 */       throw new IllegalArgumentException("Property is not writable: " + getName() + " for " + this.beanInfo.getName());
/*     */     }
/* 182 */     this.setter.invoke(bean, new Object[] { value });
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/* 188 */     if ((object == null) || (!(object instanceof AbstractPropertyInfo))) {
/* 189 */       return false;
/*     */     }
/* 191 */     AbstractPropertyInfo other = (AbstractPropertyInfo)object;
/* 192 */     if (notEqual(this.name, other.name))
/* 193 */       return false;
/* 194 */     if (notEqual(this.getter, other.getter)) {
/* 195 */       return false;
/*     */     }
/* 197 */     return !notEqual(this.setter, other.setter);
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 204 */     buffer.append("name=").append(this.name);
/* 205 */     buffer.append(" getter=").append(this.getter);
/* 206 */     buffer.append(" setter=").append(this.setter);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 212 */     buffer.append(this.name);
/*     */   }
/*     */ 
/*     */   public int getHashCode()
/*     */   {
/* 218 */     return this.name.hashCode();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.info.plugins.AbstractPropertyInfo
 * JD-Core Version:    0.6.0
 */