/*    */ package org.jboss.aspects.versioned;
/*    */ 
/*    */ import javax.naming.InitialContext;
/*    */ import javax.transaction.TransactionManager;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.InstanceAdvisor;
/*    */ import org.jboss.aop.advice.AspectFactory;
/*    */ import org.jboss.aop.joinpoint.Joinpoint;
/*    */ import org.jboss.util.NestedRuntimeException;
/*    */ 
/*    */ public class VersionedObjectInterceptorFactory
/*    */   implements AspectFactory
/*    */ {
/* 39 */   private static VersionedObjectInterceptor instance = null;
/*    */ 
/*    */   public static synchronized VersionedObjectInterceptor getInstance()
/*    */   {
/*    */     try
/*    */     {
/* 46 */       if (instance == null)
/*    */       {
/* 48 */         InitialContext ctx = new InitialContext();
/* 49 */         TransactionManager tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
/* 50 */         instance = new VersionedObjectInterceptor(tm);
/*    */       }
/* 52 */       return instance;
/*    */     }
/*    */     catch (Exception ex) {
/*    */     }
/* 56 */     throw new NestedRuntimeException(ex);
/*    */   }
/*    */ 
/*    */   public Object createPerVM()
/*    */   {
/* 62 */     return getInstance();
/*    */   }
/*    */ 
/*    */   public Object createPerClass(Advisor advisor)
/*    */   {
/* 67 */     return getInstance();
/*    */   }
/*    */ 
/*    */   public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor)
/*    */   {
/* 72 */     return getInstance();
/*    */   }
/*    */ 
/*    */   public Object createPerJoinpoint(Advisor advisor, Joinpoint jp)
/*    */   {
/* 77 */     return getInstance();
/*    */   }
/*    */ 
/*    */   public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp)
/*    */   {
/* 82 */     return getInstance();
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 87 */     return getClass().getName();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.VersionedObjectInterceptorFactory
 * JD-Core Version:    0.6.0
 */