/*    */ package org.jboss.aspects.versioned;
/*    */ 
/*    */ import javax.transaction.Transaction;
/*    */ import javax.transaction.TransactionManager;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.FieldReadInvocation;
/*    */ import org.jboss.aop.joinpoint.FieldWriteInvocation;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.joinpoint.MethodInvocation;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class VersionedObjectInterceptor
/*    */   implements Interceptor
/*    */ {
/* 44 */   protected Logger log = Logger.getLogger(getClass());
/*    */   private TransactionManager tm;
/*    */ 
/*    */   public VersionedObjectInterceptor(TransactionManager tm)
/*    */   {
/* 49 */     this.tm = tm;
/*    */   }
/*    */   public String getName() {
/* 52 */     return "VersionedObjectInterceptor";
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation)
/*    */     throws Throwable
/*    */   {
/* 59 */     Transaction tx = this.tm.getTransaction();
/* 60 */     VersionedObject manager = (VersionedObject)invocation.getMetaData("VERSIONED", "VERSIONED_OBJECT");
/*    */ 
/* 62 */     Object version = manager.getVersion(tx);
/* 63 */     if (version != null)
/*    */     {
/* 65 */       invocation.setTargetObject(version);
/* 66 */       return invocation.invokeNext();
/*    */     }
/*    */ 
/* 69 */     boolean isReadonly = false;
/* 70 */     if ((invocation instanceof MethodInvocation))
/*    */     {
/* 72 */       String readonly = (String)invocation.getMetaData("VERSIONED", "read-only");
/* 73 */       if (readonly != null)
/*    */       {
/* 75 */         isReadonly = Boolean.getBoolean(readonly.toLowerCase());
/*    */       }
/*    */     }
/* 78 */     else if ((invocation instanceof FieldReadInvocation))
/*    */     {
/* 80 */       isReadonly = true;
/*    */     }
/* 82 */     else if ((invocation instanceof FieldWriteInvocation))
/*    */     {
/* 84 */       isReadonly = false;
/*    */     }
/* 86 */     if (isReadonly) return invocation.invokeNext();
/*    */ 
/* 90 */     version = manager.createVersion(tx);
/* 91 */     invocation.setTargetObject(version);
/* 92 */     return invocation.invokeNext();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.VersionedObjectInterceptor
 * JD-Core Version:    0.6.0
 */