/*     */ package org.jboss.aspects.versioned;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.util.MarshalledValue;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ 
/*     */ public class VersionedObject
/*     */ {
/*  42 */   FIFOSemaphore lock = new FIFOSemaphore(1L);
/*  43 */   TransactionLocal txLocal = new TransactionLocal();
/*  44 */   long currentId = 0L;
/*     */   Object currentObject;
/*  46 */   long versionIdGenerator = 0L;
/*     */ 
/*     */   public VersionedObject(Object obj)
/*     */   {
/*  50 */     this.currentObject = obj;
/*     */   }
/*     */ 
/*     */   public Object getVersion(Transaction tx)
/*     */   {
/*  55 */     if (tx == null) return this.currentObject;
/*  56 */     return this.txLocal.get(tx);
/*     */   }
/*     */   public Object createVersion(Transaction tx) throws Exception {
/*  61 */     this.lock.acquire();
/*  62 */     Object version = null;
/*     */     long versionId;
/*     */     try {
/*  66 */       version = new MarshalledValue(this.currentObject).get();
/*  67 */       if ((version instanceof Advised))
/*     */       {
/*  70 */         Advised versionAdvised = (Advised)version;
/*  71 */         Advised currentAdvised = (Advised)this.currentObject;
/*  72 */         versionAdvised._setInstanceAdvisor(currentAdvised._getInstanceAdvisor());
/*     */       }
/*  74 */       versionId = ++this.versionIdGenerator;
/*     */     }
/*     */     finally
/*     */     {
/*  78 */       this.lock.release();
/*     */     }
/*     */ 
/*  81 */     tx.registerSynchronization(new VersionSynchronization(tx, versionId, version));
/*  82 */     this.txLocal.set(tx, version);
/*  83 */     return version;
/*     */   }
/*     */   private final class VersionSynchronization implements Synchronization {
/*     */     long versionId;
/*     */     Object version;
/*     */     Transaction tx;
/*     */ 
/*     */     public VersionSynchronization(Transaction tx, long versionId, Object version) {
/*  94 */       this.tx = tx;
/*  95 */       this.versionId = versionId;
/*  96 */       this.version = version;
/*     */     }
/*     */ 
/*     */     public void beforeCompletion()
/*     */     {
/*     */       try {
/* 102 */         VersionedObject.this.lock.acquire();
/*     */       }
/*     */       catch (InterruptedException ignored)
/*     */       {
/* 106 */         throw new RuntimeException(ignored);
/*     */       }
/* 108 */       if (VersionedObject.this.currentId >= this.versionId)
/*     */       {
/* 110 */         VersionedObject.this.lock.release();
/* 111 */         throw new OptimisticLockFailure();
/*     */       }
/*     */     }
/*     */ 
/*     */     public void afterCompletion(int status)
/*     */     {
/* 118 */       if (status != 4)
/*     */       {
/* 120 */         VersionedObject.this.currentId = this.versionId;
/* 121 */         VersionedObject.this.currentObject = this.version;
/* 122 */         VersionedObject.this.lock.release();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.VersionedObject
 * JD-Core Version:    0.6.0
 */