/*    */ package org.jboss.aspects.versioned;
/*    */ 
/*    */ import org.jboss.aop.Advised;
/*    */ import org.jboss.aop.InstanceAdvisor;
/*    */ import org.jboss.aop.metadata.SimpleMetaData;
/*    */ import org.jboss.aop.proxy.ClassProxy;
/*    */ import org.jboss.aop.proxy.ClassProxyFactory;
/*    */ import org.jboss.aop.util.PayloadKey;
/*    */ 
/*    */ public class Versioned
/*    */ {
/*    */   public static final String VERSIONED = "VERSIONED";
/*    */   public static final String VERSIONED_OBJECT = "VERSIONED_OBJECT";
/*    */   public static final String READONLY = "read-only";
/* 54 */   static DistributedVersionManager localManager = null;
/*    */ 
/*    */   public static Object makeVersioned(Object target)
/*    */     throws Exception
/*    */   {
/* 45 */     if ((target instanceof ClassProxy)) throw new IllegalStateException("A ClassProxy is not allowed to be Versioned.  You must have a concrete object");
/* 46 */     ClassProxy proxy = ClassProxyFactory.newInstance(target.getClass());
/* 47 */     VersionedObject versioned = new VersionedObject(target);
/* 48 */     proxy._getInstanceAdvisor().getMetaData().addMetaData("VERSIONED", "VERSIONED_OBJECT", versioned, PayloadKey.TRANSIENT);
/* 49 */     proxy._getInstanceAdvisor().appendInterceptor(VersionedObjectInterceptorFactory.getInstance());
/* 50 */     proxy._getInstanceAdvisor().appendInterceptor(new VersionedObjectForwardingInterceptor());
/* 51 */     return proxy;
/*    */   }
/*    */ 
/*    */   public static synchronized DistributedVersionManager getLocalVersionManager()
/*    */     throws Exception
/*    */   {
/* 57 */     if (localManager == null)
/*    */     {
/* 59 */       LocalSynchronizationManager synchManager = new LocalSynchronizationManager(null);
/* 60 */       localManager = new DistributedVersionManager(1000L, synchManager);
/* 61 */       synchManager.versionManager = localManager;
/*    */     }
/*    */ 
/* 64 */     return localManager;
/*    */   }
/*    */ 
/*    */   public static void makePerFieldVersioned(Object target) throws Exception
/*    */   {
/* 69 */     if (!(target instanceof Advised)) throw new IllegalArgumentException("Cannot do per field versioning with a non-Advised object");
/* 70 */     Advised advised = (Advised)target;
/* 71 */     getLocalVersionManager().makeVersioned(advised);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.Versioned
 * JD-Core Version:    0.6.0
 */