/*     */ package org.jboss.aspects.versioned;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.InstanceAdvised;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.proxy.ClassProxy;
/*     */ import org.jboss.aop.proxy.ClassProxyFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class DistributedVersionManager extends VersionManager
/*     */ {
/*  48 */   protected static Logger log = Logger.getLogger(DistributedVersionManager.class);
/*     */   protected SynchronizationManager synchManager;
/*     */   protected long timeout;
/*     */ 
/*     */   public DistributedVersionManager(long timeout, SynchronizationManager synchManager)
/*     */   {
/*  54 */     this.synchManager = synchManager;
/*  55 */     this.timeout = timeout;
/*     */   }
/*     */ 
/*     */   public boolean isVersioned(Object obj)
/*     */   {
/*  60 */     if (!(obj instanceof InstanceAdvised)) return false;
/*  61 */     InstanceAdvised advised = (InstanceAdvised)obj;
/*  62 */     return getGUID(advised) != null;
/*     */   }
/*     */ 
/*     */   public GUID tag(InstanceAdvised advised)
/*     */   {
/*  67 */     GUID guid = new GUID();
/*  68 */     SimpleMetaData metaData = advised._getInstanceAdvisor().getMetaData();
/*  69 */     metaData.addMetaData("VERSION_MANAGER", "VERSION_ID", guid);
/*  70 */     return guid;
/*     */   }
/*     */ 
/*     */   public void untag(InstanceAdvised advised)
/*     */   {
/*  75 */     SimpleMetaData metaData = advised._getInstanceAdvisor().getMetaData();
/*  76 */     metaData.removeMetaData("VERSION_MANAGER", "VERSION_ID");
/*     */   }
/*     */ 
/*     */   public List makeVersionedList(List list, ArrayList newObjects) throws Exception
/*     */   {
/*  81 */     ClassProxy proxy = ClassProxyFactory.newInstance(list.getClass());
/*  82 */     GUID guid = tag(proxy);
/*  83 */     DistributedListState manager = new DistributedListState(guid, this.timeout, proxy, list, this, this.synchManager);
/*  84 */     StateManager.setStateManager(proxy, manager);
/*  85 */     CollectionStateChangeInterceptor interceptor = new CollectionStateChangeInterceptor(manager);
/*  86 */     proxy._getInstanceAdvisor().appendInterceptor(interceptor);
/*  87 */     newObjects.add(manager);
/*  88 */     return (List)proxy;
/*     */   }
/*     */ 
/*     */   public Map makeVersionedMap(Map map, ArrayList newObjects)
/*     */     throws Exception
/*     */   {
/*  94 */     ClassProxy proxy = ClassProxyFactory.newInstance(map.getClass());
/*  95 */     GUID guid = tag(proxy);
/*  96 */     DistributedMapState manager = new DistributedMapState(guid, this.timeout, proxy, map, this, this.synchManager);
/*  97 */     StateManager.setStateManager(proxy, manager);
/*  98 */     CollectionStateChangeInterceptor interceptor = new CollectionStateChangeInterceptor(manager);
/*  99 */     proxy._getInstanceAdvisor().appendInterceptor(interceptor);
/* 100 */     newObjects.add(manager);
/* 101 */     return (Map)proxy;
/*     */   }
/*     */ 
/*     */   public Set makeVersionedSet(Set set, ArrayList newObjects)
/*     */     throws Exception
/*     */   {
/* 107 */     ClassProxy proxy = ClassProxyFactory.newInstance(set.getClass());
/* 108 */     GUID guid = tag(proxy);
/* 109 */     DistributedSetState manager = new DistributedSetState(guid, this.timeout, proxy, set, this, this.synchManager);
/* 110 */     StateManager.setStateManager(proxy, manager);
/* 111 */     CollectionStateChangeInterceptor interceptor = new CollectionStateChangeInterceptor(manager);
/* 112 */     proxy._getInstanceAdvisor().appendInterceptor(interceptor);
/* 113 */     newObjects.add(manager);
/* 114 */     return (Set)proxy;
/*     */   }
/*     */ 
/*     */   public Object makeVersioned(Object obj)
/*     */     throws Exception
/*     */   {
/* 121 */     ArrayList newObjects = new ArrayList();
/* 122 */     obj = makeVersioned(obj, newObjects);
/* 123 */     this.synchManager.createObjects(newObjects);
/* 124 */     return obj;
/*     */   }
/*     */ 
/*     */   Object makeVersioned(Object obj, ArrayList newObjects)
/*     */     throws Exception
/*     */   {
/* 131 */     if ((obj instanceof ClassProxy)) return obj;
/*     */ 
/* 133 */     if (!(obj instanceof Advised))
/*     */     {
/* 135 */       if ((obj instanceof List))
/*     */       {
/* 137 */         List list = (List)obj;
/* 138 */         return makeVersionedList(list, newObjects);
/*     */       }
/* 140 */       if ((obj instanceof Map))
/*     */       {
/* 142 */         Map map = (Map)obj;
/* 143 */         return makeVersionedMap(map, newObjects);
/*     */       }
/* 145 */       if ((obj instanceof Set))
/*     */       {
/* 147 */         Set set = (Set)obj;
/* 148 */         return makeVersionedSet(set, newObjects);
/*     */       }
/*     */ 
/* 152 */       return obj;
/*     */     }
/*     */ 
/* 155 */     Advised advised = (Advised)obj;
/* 156 */     SimpleMetaData metaData = advised._getInstanceAdvisor().getMetaData();
/*     */     GUID guid;
/* 158 */     synchronized (metaData)
/*     */     {
/* 160 */       if (isVersioned(advised)) return obj;
/* 161 */       guid = tag(advised);
/*     */     }
/* 163 */     System.out.println("VersionManager: " + guid);
/* 164 */     DistributedPOJOState manager = new DistributedPOJOState(guid, this.timeout, advised, this, this.synchManager);
/* 165 */     StateManager.setStateManager(advised, manager);
/* 166 */     StateChangeInterceptor interceptor = new StateChangeInterceptor(manager);
/* 167 */     manager.acquireWriteLock();
/* 168 */     advised._getInstanceAdvisor().appendInterceptor(interceptor);
/*     */     try
/*     */     {
/* 171 */       Field[] advisedFields = ((ClassAdvisor)advised._getAdvisor()).getAdvisedFields();
/* 172 */       for (int i = 0; i < advisedFields.length; i++)
/*     */       {
/* 174 */         Field field = advisedFields[i];
/* 175 */         if (!Modifier.isStatic(field.getModifiers())) {
/* 176 */           Object fieldVal = field.get(advised);
/* 177 */           if (fieldVal != null)
/*     */           {
/* 179 */             if ((fieldVal instanceof Advised))
/*     */             {
/* 181 */               Advised fieldAdvised = (Advised)fieldVal;
/* 182 */               makeVersioned(fieldAdvised, newObjects);
/* 183 */               fieldVal = new VersionReference(getGUID(fieldAdvised), fieldAdvised);
/*     */             }
/* 185 */             else if ((fieldVal instanceof List))
/*     */             {
/* 187 */               List list = (List)fieldVal;
/* 188 */               InstanceAdvised instanceAdvised = (InstanceAdvised)makeVersionedList(list, newObjects);
/* 189 */               fieldVal = new VersionReference(getGUID(instanceAdvised), instanceAdvised);
/*     */             }
/* 191 */             else if ((fieldVal instanceof Map))
/*     */             {
/* 193 */               Map map = (Map)fieldVal;
/* 194 */               InstanceAdvised instanceAdvised = (InstanceAdvised)makeVersionedMap(map, newObjects);
/* 195 */               fieldVal = new VersionReference(getGUID(instanceAdvised), instanceAdvised);
/*     */             }
/* 197 */             else if ((fieldVal instanceof Set))
/*     */             {
/* 199 */               Set set = (Set)fieldVal;
/* 200 */               InstanceAdvised instanceAdvised = (InstanceAdvised)makeVersionedSet(set, newObjects);
/* 201 */               fieldVal = new VersionReference(getGUID(instanceAdvised), instanceAdvised);
/*     */             }
/*     */           }
/* 204 */           manager.fieldMap.put(new Integer(i), new DistributedFieldUpdate(fieldVal, 0L, i));
/*     */         }
/*     */       }
/* 206 */       newObjects.add(manager);
/* 207 */       i = advised;
/*     */       return i; } finally { manager.releaseWriteLock(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   public void addVersioning(DistributedPOJOState manager, Advised advised)
/*     */   {
/* 221 */     StateManager.setStateManager(advised, manager);
/* 222 */     StateChangeInterceptor interceptor = new StateChangeInterceptor(manager);
/* 223 */     SimpleMetaData metaData = advised._getInstanceAdvisor().getMetaData();
/* 224 */     metaData.addMetaData("VERSION_MANAGER", "VERSION_ID", manager.getGUID());
/* 225 */     advised._getInstanceAdvisor().appendInterceptor(interceptor);
/*     */   }
/*     */ 
/*     */   public ClassProxy addListVersioning(List list, DistributedListState manager)
/*     */     throws Exception
/*     */   {
/* 234 */     ClassProxy proxy = ClassProxyFactory.newInstance(list.getClass());
/* 235 */     GUID guid = manager.getGUID();
/* 236 */     SimpleMetaData metaData = proxy._getInstanceAdvisor().getMetaData();
/* 237 */     metaData.addMetaData("VERSION_MANAGER", "VERSION_ID", guid);
/* 238 */     StateManager.setStateManager(proxy, manager);
/* 239 */     CollectionStateChangeInterceptor interceptor = new CollectionStateChangeInterceptor(manager);
/* 240 */     proxy._getInstanceAdvisor().appendInterceptor(interceptor);
/* 241 */     return proxy;
/*     */   }
/*     */ 
/*     */   public ClassProxy addMapVersioning(Map map, DistributedMapState manager)
/*     */     throws Exception
/*     */   {
/* 250 */     ClassProxy proxy = ClassProxyFactory.newInstance(map.getClass());
/* 251 */     GUID guid = manager.getGUID();
/* 252 */     SimpleMetaData metaData = proxy._getInstanceAdvisor().getMetaData();
/* 253 */     metaData.addMetaData("VERSION_MANAGER", "VERSION_ID", guid);
/* 254 */     StateManager.setStateManager(proxy, manager);
/* 255 */     CollectionStateChangeInterceptor interceptor = new CollectionStateChangeInterceptor(manager);
/* 256 */     proxy._getInstanceAdvisor().appendInterceptor(interceptor);
/* 257 */     return proxy;
/*     */   }
/*     */ 
/*     */   public ClassProxy addSetVersioning(Set set, DistributedSetState manager)
/*     */     throws Exception
/*     */   {
/* 266 */     ClassProxy proxy = ClassProxyFactory.newInstance(set.getClass());
/* 267 */     GUID guid = manager.getGUID();
/* 268 */     SimpleMetaData metaData = proxy._getInstanceAdvisor().getMetaData();
/* 269 */     metaData.addMetaData("VERSION_MANAGER", "VERSION_ID", guid);
/* 270 */     StateManager.setStateManager(proxy, manager);
/* 271 */     CollectionStateChangeInterceptor interceptor = new CollectionStateChangeInterceptor(manager);
/* 272 */     proxy._getInstanceAdvisor().appendInterceptor(interceptor);
/* 273 */     return proxy;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.DistributedVersionManager
 * JD-Core Version:    0.6.0
 */