/*     */ package org.jboss.aspects.versioned;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Vector;
/*     */ import org.jboss.ha.framework.interfaces.HAPartition;
/*     */ import org.jboss.ha.framework.interfaces.HAPartition.HAMembershipListener;
/*     */ import org.jboss.ha.framework.interfaces.HAPartition.HAPartitionStateTransfer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class DistributedSynchronizationManager extends LocalSynchronizationManager
/*     */   implements HAPartition.HAPartitionStateTransfer, HAPartition.HAMembershipListener
/*     */ {
/*  45 */   protected static final Class[] STRING_TYPE = { String.class };
/*  46 */   protected static final Class[] LIST_TYPE = { List.class };
/*  47 */   protected static final Class[] LOCK_TYPES = { String.class, GUID.class, List.class };
/*     */ 
/*  49 */   protected static Logger log = Logger.getLogger(DistributedSynchronizationManager.class);
/*     */   protected HAPartition partition;
/*     */   protected String domainName;
/*  52 */   protected Hashtable heldLocks = new Hashtable();
/*     */ 
/*     */   public DistributedSynchronizationManager(String domainName, DistributedVersionManager versionManager, HAPartition partition)
/*     */   {
/*  56 */     super(versionManager);
/*  57 */     this.partition = partition;
/*  58 */     this.domainName = (domainName + "/SynchManager");
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*  64 */     this.partition.registerRPCHandler(this.domainName, this);
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*  69 */     pullState();
/*     */   }
/*     */ 
/*     */   protected void pullState() throws Exception
/*     */   {
/*  74 */     Object[] args = new Object[0];
/*  75 */     ArrayList rsp = this.partition.callMethodOnCluster(this.domainName, "getCurrentState", args, null, true);
/*  76 */     if (rsp.size() > 0)
/*  77 */       setCurrentState((Serializable)rsp.get(0));
/*     */   }
/*     */ 
/*     */   public Serializable getCurrentState()
/*     */   {
/*  82 */     if (log.isTraceEnabled())
/*  83 */       log.trace("getCurrentState called");
/*  84 */     return this.stateTable;
/*     */   }
/*     */ 
/*     */   public void setCurrentState(Serializable newState)
/*     */   {
/*  89 */     if (log.isTraceEnabled())
/*  90 */       log.trace("setCurrentState called");
/*     */     try
/*     */     {
/*  93 */       synchronized (this.tableLock)
/*     */       {
/*  95 */         this.stateTable = ((Hashtable)newState);
/*  96 */         log.trace("setCurrentState, size: " + this.stateTable.size());
/*  97 */         Iterator it = this.stateTable.values().iterator();
/*  98 */         while (it.hasNext())
/*     */         {
/* 100 */           DistributedState state = (DistributedState)it.next();
/* 101 */           if (!this.objectTable.containsKey(state.getGUID()))
/* 102 */             state.buildObject(this, this.versionManager);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 108 */       log.error("failed to set state sent from cluster", ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void membershipChanged(Vector deadMembers, Vector newMembers, Vector allMembers)
/*     */   {
/* 115 */     for (int i = 0; i < deadMembers.size(); i++)
/*     */     {
/* 117 */       Hashtable held = (Hashtable)this.heldLocks.remove(deadMembers.get(i));
/* 118 */       if (held == null)
/*     */         continue;
/* 120 */       Iterator it = held.values().iterator();
/* 121 */       while (it.hasNext())
/*     */       {
/* 123 */         List list = (List)it.next();
/* 124 */         releaseHeldLocks(list);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void sendNewObjects(List newObjects)
/*     */     throws Exception
/*     */   {
/* 132 */     log.trace("sending new objects");
/*     */     try
/*     */     {
/* 135 */       Object[] args = { newObjects };
/* 136 */       checkResponses(this.partition.callMethodOnCluster(this.domainName, "addNewObjects", args, LIST_TYPE, true));
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 140 */       log.error("serious cache problems, data inconsistency is imminent", ex);
/* 141 */       throw ex;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void sendClusterUpdatesAndRelease(GUID globalTxId, List clusterUpdates)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 150 */       Object[] args = { this.partition.getNodeName(), globalTxId, clusterUpdates };
/* 151 */       checkResponses(this.partition.callMethodOnCluster(this.domainName, "updateObjects", args, LOCK_TYPES, true));
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 156 */       log.error("serious cache problems, data inconsistency is imminent", ex);
/* 157 */       throw ex;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void acquireRemoteLocks(GUID globalTxId, List guids) throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 165 */       Object[] args = { this.partition.getNodeName(), globalTxId, guids };
/* 166 */       checkResponses(this.partition.callMethodOnCluster(this.domainName, "acquireLocks", args, LOCK_TYPES, true));
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */       try
/*     */       {
/* 172 */         Object[] args = { this.partition.getNodeName() };
/* 173 */         this.partition.callMethodOnCluster(this.domainName, "releaseHeldLocks", args, STRING_TYPE, true);
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/*     */       }
/* 178 */       throw ex;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void noTxUpdate(DistributedUpdate update) throws Exception
/*     */   {
/* 184 */     throw new RuntimeException("NOT IMPLEMENTED");
/*     */   }
/*     */ 
/*     */   public void addNewObjects(List newObjects)
/*     */     throws Exception
/*     */   {
/* 190 */     synchronized (this.tableLock)
/*     */     {
/* 192 */       for (int i = 0; i < newObjects.size(); i++)
/*     */       {
/* 194 */         DistributedState state = (DistributedState)newObjects.get(i);
/*     */ 
/* 196 */         this.stateTable.put(state.getGUID(), state);
/*     */       }
/* 198 */       for (int i = 0; i < newObjects.size(); i++)
/*     */       {
/* 200 */         DistributedState state = (DistributedState)newObjects.get(i);
/* 201 */         if (!this.objectTable.containsKey(state.getGUID()))
/* 202 */           state.buildObject(this, this.versionManager);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void updateObjects(String nodeName, GUID globalTxId, ArrayList updates) throws Exception
/*     */   {
/* 209 */     log.trace("updateObjects");
/* 210 */     synchronized (this.tableLock)
/*     */     {
/* 212 */       for (int i = 0; i < updates.size(); i++)
/*     */       {
/* 214 */         DistributedUpdate update = (DistributedUpdate)updates.get(i);
/*     */ 
/* 216 */         DistributedState state = (DistributedState)this.stateTable.get(update.getGUID());
/* 217 */         state.mergeState(update);
/* 218 */         state.releaseWriteLock();
/*     */       }
/*     */     }
/* 221 */     Hashtable table = (Hashtable)this.heldLocks.get(nodeName);
/* 222 */     table.remove(globalTxId);
/* 223 */     log.trace("end updateObjects");
/*     */   }
/*     */ 
/*     */   public void releaseHeldLocks(String nodeName, GUID globalTxId)
/*     */   {
/* 228 */     Hashtable held = (Hashtable)this.heldLocks.get(nodeName);
/* 229 */     if (held == null) return;
/*     */ 
/* 231 */     List locks = (List)held.remove(globalTxId);
/* 232 */     if (locks != null) releaseHeldLocks(locks); 
/*     */   }
/*     */ 
/*     */   public void acquireLocks(String nodeName, GUID globalTxId, List list)
/*     */     throws Exception
/*     */   {
/* 237 */     log.trace("acquireLocks");
/* 238 */     ArrayList locks = new ArrayList();
/*     */     try
/*     */     {
/* 241 */       for (int i = 0; i < list.size(); i++)
/*     */       {
/* 243 */         GUID guid = (GUID)list.get(i);
/* 244 */         DistributedState state = getState(guid);
/* 245 */         state.acquireWriteLock();
/* 246 */         locks.add(state);
/*     */       }
/* 248 */       Hashtable held = (Hashtable)this.heldLocks.get(nodeName);
/* 249 */       if (held == null)
/*     */       {
/* 251 */         held = new Hashtable();
/* 252 */         this.heldLocks.put(nodeName, held);
/*     */       }
/* 254 */       held.put(globalTxId, locks);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 258 */       releaseHeldLocks(locks);
/* 259 */       throw ex;
/*     */     }
/* 261 */     log.trace("end acquireLocks");
/*     */   }
/*     */ 
/*     */   protected void checkResponses(List rsps)
/*     */     throws Exception
/*     */   {
/*     */     Iterator it;
/* 272 */     if (rsps != null)
/* 273 */       for (it = rsps.iterator(); it.hasNext(); ) {
/* 274 */         Object rsp = it.next();
/* 275 */         if (rsp != null) {
/* 276 */           if ((rsp instanceof RuntimeException))
/* 277 */             throw ((RuntimeException)rsp);
/* 278 */           if ((rsp instanceof Exception))
/* 279 */             throw ((Exception)rsp);
/*     */         }
/*     */       }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.DistributedSynchronizationManager
 * JD-Core Version:    0.6.0
 */