/*     */ package org.jboss.aspects.versioned;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
/*     */ import EDU.oswego.cs.dl.util.concurrent.Sync;
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.aop.InstanceAdvised;
/*     */ import org.jboss.aop.proxy.ClassProxy;
/*     */ import org.jboss.aop.proxy.ClassProxyFactory;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class DistributedSetState extends CollectionStateManager
/*     */   implements Set, DistributedState, Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = -6272170697169509758L;
/*     */   private static HashMap setMethodMap;
/*  53 */   protected static Logger log = Logger.getLogger(DistributedSetState.class);
/*     */   protected volatile long versionId;
/*     */   protected HashSet updates;
/*     */   protected String classname;
/*     */   protected transient Set base;
/*  77 */   protected transient TransactionLocal txState = new TransactionLocal();
/*  78 */   protected transient TransactionLocal txVersion = new TransactionLocal();
/*     */   protected transient DistributedVersionManager versionManager;
/*     */   protected transient SynchronizationManager synchManager;
/*     */   protected transient TransactionManager tm;
/*     */   protected transient ClassProxy proxy;
/*     */ 
/*     */   public DistributedSetState()
/*     */   {
/*     */   }
/*     */ 
/*     */   public DistributedSetState(GUID guid, long timeout, ClassProxy proxy, Set obj, DistributedVersionManager versionManager, SynchronizationManager synchManager)
/*     */     throws Exception
/*     */   {
/*  93 */     super(guid, timeout, setMethodMap);
/*  94 */     this.base = obj;
/*  95 */     this.classname = obj.getClass().getName();
/*  96 */     this.versionManager = versionManager;
/*  97 */     this.synchManager = synchManager;
/*  98 */     this.proxy = proxy;
/*  99 */     InitialContext ctx = new InitialContext();
/* 100 */     this.tm = ((TransactionManager)ctx.lookup("java:/TransactionManager"));
/* 101 */     this.updates = createSetUpdates(this.base);
/*     */   }
/*     */ 
/*     */   public HashMap getMethodMap()
/*     */   {
/* 106 */     return ClassProxyFactory.getMethodMap(this.base.getClass().getName());
/*     */   }
/*     */   public InstanceAdvised getObject() {
/* 109 */     return this.proxy;
/*     */   }
/*     */ 
/*     */   protected Set getCurrentState(boolean forUpdate)
/*     */     throws Exception
/*     */   {
/* 115 */     Transaction tx = this.tm.getTransaction();
/* 116 */     if (tx == null)
/*     */     {
/* 118 */       if (forUpdate) this.versionId += 1L;
/* 119 */       return this.base;
/*     */     }
/*     */ 
/* 122 */     Set state = (Externalizable)this.txState.get(tx);
/* 123 */     if ((state == null) && (forUpdate))
/*     */     {
/* 125 */       state = (Externalizable)this.base.getClass().newInstance();
/* 126 */       state.addAll(this.base);
/* 127 */       this.txState.set(tx, state);
/* 128 */       long newId = this.versionId + 1L;
/* 129 */       this.synchManager.registerUpdate(tx, this);
/* 130 */       this.txVersion.set(tx, new Long(newId));
/* 131 */       return state;
/*     */     }
/* 133 */     return this.base;
/*     */   }
/*     */ 
/*     */   protected HashSet createSetUpdates(Set state)
/*     */   {
/* 139 */     HashSet setUpdates = new HashSet(state.size());
/* 140 */     Iterator it = state.iterator();
/* 141 */     while (it.hasNext())
/*     */     {
/* 143 */       Object obj = it.next();
/* 144 */       if (this.versionManager.isVersioned(obj))
/*     */       {
/* 146 */         setUpdates.add(new VersionReference(VersionManager.getGUID((InstanceAdvised)obj)));
/*     */       }
/*     */       else
/*     */       {
/* 150 */         setUpdates.add(obj);
/*     */       }
/*     */     }
/* 153 */     return setUpdates;
/*     */   }
/*     */ 
/*     */   public DistributedUpdate createTxUpdate(Transaction tx)
/*     */   {
/* 158 */     Set state = (Externalizable)this.txState.get(tx);
/* 159 */     long newId = ((Long)this.txVersion.get(tx)).longValue();
/* 160 */     DistributedSetUpdate update = new DistributedSetUpdate(this.guid, createSetUpdates(state), newId);
/* 161 */     return update;
/*     */   }
/*     */ 
/*     */   public InstanceAdvised buildObject(SynchronizationManager manager, DistributedVersionManager versionManager)
/*     */     throws Exception
/*     */   {
/* 167 */     log.trace("building a Set");
/* 168 */     this.versionManager = versionManager;
/* 169 */     this.synchManager = manager;
/* 170 */     log.trace("DistributedSetState: classname: " + this.classname);
/* 171 */     Class clazz = Thread.currentThread().getContextClassLoader().loadClass(this.classname);
/* 172 */     this.base = ((Externalizable)clazz.newInstance());
/* 173 */     Iterator it = this.updates.iterator();
/* 174 */     while (it.hasNext())
/*     */     {
/* 176 */       Object val = it.next();
/* 177 */       if ((val instanceof VersionReference))
/*     */       {
/* 179 */         VersionReference ref = (VersionReference)val;
/* 180 */         val = manager.getObject(ref.getGUID());
/* 181 */         if (val == null)
/*     */         {
/* 183 */           DistributedState fieldVal = manager.getState(ref.getGUID());
/* 184 */           val = fieldVal.buildObject(manager, versionManager);
/* 185 */           ref.set((InstanceAdvised)val);
/*     */         }
/*     */       }
/* 188 */       this.base.add(val);
/*     */     }
/* 190 */     this.proxy = versionManager.addSetVersioning(this.base, this);
/* 191 */     return this.proxy;
/*     */   }
/*     */ 
/*     */   public void checkOptimisticLock(Transaction tx)
/*     */   {
/* 197 */     Long version = (Long)this.txVersion.get(tx);
/* 198 */     if (version.longValue() <= this.versionId)
/* 199 */       throw new OptimisticLockFailure("optimistic lock failure for set");
/*     */   }
/*     */ 
/*     */   public void mergeState(Transaction tx)
/*     */     throws Exception
/*     */   {
/* 205 */     Set current = (Externalizable)this.txState.get(tx);
/* 206 */     this.base = current;
/* 207 */     Long version = (Long)this.txVersion.get(tx);
/* 208 */     this.versionId = version.longValue();
/*     */   }
/*     */ 
/*     */   public void mergeState(DistributedUpdate update) throws Exception
/*     */   {
/* 213 */     DistributedSetUpdate setUpdate = (DistributedSetUpdate)update;
/* 214 */     this.versionId = setUpdate.versionId;
/* 215 */     this.base.clear();
/* 216 */     Iterator it = setUpdate.setUpdates.iterator();
/* 217 */     while (it.hasNext())
/*     */     {
/* 219 */       Object val = it.next();
/* 220 */       if ((val instanceof VersionReference))
/*     */       {
/* 222 */         VersionReference ref = (VersionReference)val;
/* 223 */         val = this.synchManager.getObject(ref.getGUID());
/* 224 */         ref.set((InstanceAdvised)val);
/*     */       }
/* 226 */       this.base.add(val);
/*     */     }
/* 228 */     this.updates = setUpdate.setUpdates;
/*     */   }
/*     */ 
/*     */   public boolean add(Object val)
/*     */   {
/*     */     try
/*     */     {
/* 237 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 240 */         val = this.versionManager.makeVersioned(val);
/* 241 */         Set state = getCurrentState(true);
/* 242 */         boolean bool = state.add(val);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 251 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean addAll(Collection c)
/*     */   {
/*     */     try
/*     */     {
/* 259 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 262 */         Set state = getCurrentState(true);
/* 263 */         Object[] copy = c.toArray();
/* 264 */         for (int i = 0; i < copy.length; i++)
/*     */         {
/* 266 */           Object item = this.versionManager.makeVersioned(copy[i]);
/* 267 */           state.add(item);
/*     */         }
/* 269 */         i = 1;
/*     */         return i; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 278 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*     */     try
/*     */     {
/* 286 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 289 */         Set state = getCurrentState(true);
/* 290 */         state.clear();
/*     */       }
/*     */       finally
/*     */       {
/* 294 */         this.lock.readLock().release();
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 299 */       throw new RuntimeException(ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean contains(Object o)
/*     */   {
/*     */     try
/*     */     {
/* 307 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 310 */         Set state = getCurrentState(false);
/* 311 */         boolean bool = state.contains(o);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 320 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean containsAll(Collection c)
/*     */   {
/*     */     try
/*     */     {
/* 327 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 330 */         Set state = getCurrentState(false);
/* 331 */         boolean bool = state.containsAll(c);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 340 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/*     */     try
/*     */     {
/* 347 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 350 */         Set state = getCurrentState(false);
/* 351 */         boolean bool = state.equals(o);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 360 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*     */     try
/*     */     {
/* 367 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 370 */         Set state = getCurrentState(false);
/* 371 */         int i = state.hashCode();
/*     */         return i; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 380 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/*     */     try
/*     */     {
/* 387 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 390 */         Set state = getCurrentState(false);
/* 391 */         boolean bool = state.isEmpty();
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 400 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Iterator iterator()
/*     */   {
/*     */     try
/*     */     {
/* 407 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 410 */         Set state = getCurrentState(false);
/* 411 */         Iterator localIterator = state.iterator();
/*     */         return localIterator; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 420 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean remove(Object o)
/*     */   {
/*     */     try
/*     */     {
/* 427 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 430 */         Set state = getCurrentState(true);
/* 431 */         boolean bool = state.remove(o);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 440 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean removeAll(Collection c)
/*     */   {
/*     */     try
/*     */     {
/* 447 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 450 */         Set state = getCurrentState(true);
/* 451 */         boolean bool = state.removeAll(c);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 460 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean retainAll(Collection c)
/*     */   {
/*     */     try
/*     */     {
/* 467 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 470 */         Set state = getCurrentState(true);
/* 471 */         boolean bool = state.retainAll(c);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 480 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/*     */     try
/*     */     {
/* 487 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 490 */         Set state = getCurrentState(false);
/* 491 */         int i = state.size();
/*     */         return i; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 500 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Object[] toArray()
/*     */   {
/*     */     try
/*     */     {
/* 507 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 510 */         Set state = getCurrentState(false);
/* 511 */         Object[] arrayOfObject = state.toArray();
/*     */         return arrayOfObject; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 520 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Object[] toArray(Object[] a)
/*     */   {
/*     */     try
/*     */     {
/* 527 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 530 */         Set state = getCurrentState(false);
/* 531 */         Object[] arrayOfObject = state.toArray(a);
/*     */         return arrayOfObject; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 540 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 547 */     super.writeExternal(out);
/* 548 */     out.writeLong(this.versionId);
/* 549 */     out.writeObject(this.updates);
/* 550 */     out.writeObject(this.classname);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 556 */     super.readExternal(in);
/* 557 */     this.versionId = in.readLong();
/* 558 */     this.updates = ((HashSet)in.readObject());
/* 559 */     this.classname = ((String)in.readObject());
/*     */     try
/*     */     {
/* 562 */       InitialContext ctx = new InitialContext();
/* 563 */       this.tm = ((TransactionManager)ctx.lookup("java:/TransactionManager"));
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 567 */       throw new RuntimeException(ex);
/*     */     }
/* 569 */     this.txState = new TransactionLocal();
/* 570 */     this.txVersion = new TransactionLocal();
/* 571 */     this.methodMap = setMethodMap;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  58 */       setMethodMap = new HashMap();
/*  59 */       Method[] methods = Externalizable.class.getDeclaredMethods();
/*  60 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/*  62 */         long hash = MethodHashing.methodHash(methods[i]);
/*  63 */         setMethodMap.put(new Long(hash), methods[i]);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*  69 */       ignored.printStackTrace();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.DistributedSetState
 * JD-Core Version:    0.6.0
 */