/*     */ package org.jboss.aspects.versioned;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
/*     */ import EDU.oswego.cs.dl.util.concurrent.Sync;
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.aop.InstanceAdvised;
/*     */ import org.jboss.aop.proxy.ClassProxy;
/*     */ import org.jboss.aop.proxy.ClassProxyFactory;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class DistributedMapState extends CollectionStateManager
/*     */   implements Map, DistributedState, Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = -5397547850033533784L;
/*     */   private static HashMap mapMethodMap;
/*  53 */   protected static Logger log = Logger.getLogger(DistributedMapState.class);
/*     */   protected volatile long versionId;
/*     */   protected HashMap updates;
/*     */   protected String classname;
/*     */   protected transient Map base;
/*  77 */   protected transient TransactionLocal txState = new TransactionLocal();
/*  78 */   protected transient TransactionLocal txVersion = new TransactionLocal();
/*     */   protected transient DistributedVersionManager versionManager;
/*     */   protected transient SynchronizationManager synchManager;
/*     */   protected transient TransactionManager tm;
/*     */   protected transient ClassProxy proxy;
/*     */ 
/*     */   public DistributedMapState()
/*     */   {
/*     */   }
/*     */ 
/*     */   public DistributedMapState(GUID guid, long timeout, ClassProxy proxy, Map obj, DistributedVersionManager versionManager, SynchronizationManager synchManager)
/*     */     throws Exception
/*     */   {
/*  93 */     super(guid, timeout, mapMethodMap);
/*  94 */     this.base = obj;
/*  95 */     this.classname = obj.getClass().getName();
/*  96 */     this.versionManager = versionManager;
/*  97 */     this.synchManager = synchManager;
/*  98 */     this.proxy = proxy;
/*  99 */     InitialContext ctx = new InitialContext();
/* 100 */     this.tm = ((TransactionManager)ctx.lookup("java:/TransactionManager"));
/* 101 */     this.updates = createMapUpdates(this.base);
/*     */   }
/*     */ 
/*     */   public HashMap getMethodMap()
/*     */   {
/* 106 */     return ClassProxyFactory.getMethodMap(this.base.getClass().getName());
/*     */   }
/*     */   public InstanceAdvised getObject() {
/* 109 */     return this.proxy;
/*     */   }
/*     */ 
/*     */   protected Map getCurrentState(boolean forUpdate)
/*     */     throws Exception
/*     */   {
/* 115 */     Transaction tx = this.tm.getTransaction();
/* 116 */     if (tx == null)
/*     */     {
/* 118 */       if (forUpdate) this.versionId += 1L;
/* 119 */       return this.base;
/*     */     }
/*     */ 
/* 122 */     Map state = (Externalizable)this.txState.get(tx);
/* 123 */     if ((state == null) && (forUpdate))
/*     */     {
/* 125 */       state = (Externalizable)this.base.getClass().newInstance();
/* 126 */       state.putAll(this.base);
/* 127 */       this.txState.set(tx, state);
/* 128 */       long newId = this.versionId + 1L;
/* 129 */       this.synchManager.registerUpdate(tx, this);
/* 130 */       this.txVersion.set(tx, new Long(newId));
/* 131 */       return state;
/*     */     }
/* 133 */     return this.base;
/*     */   }
/*     */ 
/*     */   protected HashMap createMapUpdates(Map state)
/*     */   {
/* 139 */     HashMap mapUpdates = new HashMap();
/* 140 */     Iterator it = state.entrySet().iterator();
/* 141 */     while (it.hasNext())
/*     */     {
/* 143 */       Map.Entry entry = (Map.Entry)it.next();
/* 144 */       Object obj = entry.getValue();
/* 145 */       if (this.versionManager.isVersioned(obj))
/*     */       {
/* 147 */         mapUpdates.put(entry.getKey(), new VersionReference(VersionManager.getGUID((InstanceAdvised)obj)));
/*     */       }
/*     */       else
/*     */       {
/* 151 */         mapUpdates.put(entry.getKey(), obj);
/*     */       }
/*     */     }
/* 154 */     return mapUpdates;
/*     */   }
/*     */ 
/*     */   public DistributedUpdate createTxUpdate(Transaction tx)
/*     */   {
/* 159 */     Map state = (Externalizable)this.txState.get(tx);
/* 160 */     long newId = ((Long)this.txVersion.get(tx)).longValue();
/* 161 */     DistributedMapUpdate update = new DistributedMapUpdate(this.guid, createMapUpdates(state), newId);
/* 162 */     return update;
/*     */   }
/*     */ 
/*     */   public InstanceAdvised buildObject(SynchronizationManager manager, DistributedVersionManager versionManager)
/*     */     throws Exception
/*     */   {
/* 168 */     log.trace("building a Map");
/* 169 */     this.versionManager = versionManager;
/* 170 */     this.synchManager = manager;
/* 171 */     log.trace("DistributedMaptState: classname: " + this.classname);
/* 172 */     Class clazz = Thread.currentThread().getContextClassLoader().loadClass(this.classname);
/* 173 */     this.base = ((Externalizable)clazz.newInstance());
/* 174 */     Iterator it = this.updates.entrySet().iterator();
/* 175 */     while (it.hasNext())
/*     */     {
/* 177 */       Map.Entry entry = (Map.Entry)it.next();
/* 178 */       Object val = entry.getValue();
/* 179 */       if ((val instanceof VersionReference))
/*     */       {
/* 181 */         VersionReference ref = (VersionReference)val;
/* 182 */         val = manager.getObject(ref.getGUID());
/* 183 */         if (val == null)
/*     */         {
/* 185 */           DistributedState fieldVal = manager.getState(ref.getGUID());
/* 186 */           val = fieldVal.buildObject(manager, versionManager);
/* 187 */           ref.set((InstanceAdvised)val);
/*     */         }
/*     */       }
/* 190 */       this.base.put(entry.getKey(), val);
/*     */     }
/* 192 */     this.proxy = versionManager.addMapVersioning(this.base, this);
/* 193 */     return this.proxy;
/*     */   }
/*     */ 
/*     */   public void checkOptimisticLock(Transaction tx)
/*     */   {
/* 199 */     Long version = (Long)this.txVersion.get(tx);
/* 200 */     if (version.longValue() <= this.versionId)
/* 201 */       throw new OptimisticLockFailure("optimistic lock failure for list");
/*     */   }
/*     */ 
/*     */   public void mergeState(Transaction tx)
/*     */     throws Exception
/*     */   {
/* 207 */     Map current = (Externalizable)this.txState.get(tx);
/* 208 */     this.base = current;
/* 209 */     Long version = (Long)this.txVersion.get(tx);
/* 210 */     this.versionId = version.longValue();
/*     */   }
/*     */ 
/*     */   public void mergeState(DistributedUpdate update) throws Exception
/*     */   {
/* 215 */     DistributedMapUpdate mapUpdate = (DistributedMapUpdate)update;
/* 216 */     this.versionId = mapUpdate.versionId;
/* 217 */     this.base.clear();
/* 218 */     Iterator it = mapUpdate.mapUpdates.entrySet().iterator();
/* 219 */     while (it.hasNext())
/*     */     {
/* 221 */       Map.Entry entry = (Map.Entry)it.next();
/* 222 */       Object val = entry.getValue();
/* 223 */       if ((val instanceof VersionReference))
/*     */       {
/* 225 */         VersionReference ref = (VersionReference)val;
/* 226 */         val = this.synchManager.getObject(ref.getGUID());
/* 227 */         ref.set((InstanceAdvised)val);
/*     */       }
/* 229 */       this.base.put(entry.getKey(), val);
/*     */     }
/* 231 */     this.updates = mapUpdate.mapUpdates;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*     */     try
/*     */     {
/* 240 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 243 */         Map state = getCurrentState(true);
/* 244 */         state.clear();
/*     */       }
/*     */       finally
/*     */       {
/* 248 */         this.lock.readLock().release();
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 253 */       throw new RuntimeException(ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object o)
/*     */   {
/*     */     try
/*     */     {
/* 261 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 264 */         Map state = getCurrentState(false);
/* 265 */         boolean bool = state.containsKey(o);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 274 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object o)
/*     */   {
/*     */     try
/*     */     {
/* 282 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 285 */         Map state = getCurrentState(false);
/* 286 */         boolean bool = state.containsKey(o);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 295 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Set entrySet()
/*     */   {
/*     */     try
/*     */     {
/* 303 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 306 */         Map state = getCurrentState(false);
/* 307 */         Set localSet = state.entrySet();
/*     */         return localSet; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 316 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/*     */     try
/*     */     {
/* 324 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 327 */         Map state = getCurrentState(false);
/* 328 */         boolean bool = state.equals(o);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 337 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Object get(Object o)
/*     */   {
/*     */     try
/*     */     {
/* 345 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 348 */         Map state = getCurrentState(false);
/* 349 */         Object localObject1 = state.get(o);
/*     */         return localObject1; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 358 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*     */     try
/*     */     {
/* 366 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 369 */         Map state = getCurrentState(false);
/* 370 */         int i = state.hashCode();
/*     */         return i; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 379 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/*     */     try
/*     */     {
/* 386 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 389 */         Map state = getCurrentState(false);
/* 390 */         boolean bool = state.isEmpty();
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 399 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Set keySet()
/*     */   {
/*     */     try
/*     */     {
/* 407 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 410 */         Map state = getCurrentState(false);
/* 411 */         Set localSet = state.keySet();
/*     */         return localSet; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 420 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Object put(Object key, Object val)
/*     */   {
/*     */     try
/*     */     {
/* 428 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 431 */         val = this.versionManager.makeVersioned(val);
/* 432 */         Map state = getCurrentState(true);
/* 433 */         Object localObject1 = state.put(key, val);
/*     */         return localObject1; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 442 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public void putAll(Map c)
/*     */   {
/*     */     try
/*     */     {
/* 450 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 453 */         Map state = getCurrentState(true);
/* 454 */         Iterator it = state.entrySet().iterator();
/* 455 */         while (it.hasNext())
/*     */         {
/* 457 */           Map.Entry entry = (Map.Entry)it.next();
/* 458 */           Object val = this.versionManager.makeVersioned(entry.getValue());
/* 459 */           state.put(entry.getKey(), val);
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 464 */         this.lock.readLock().release();
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 469 */       throw new RuntimeException(ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object remove(Object key)
/*     */   {
/*     */     try
/*     */     {
/* 480 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 483 */         Map state = getCurrentState(true);
/* 484 */         Object localObject1 = state.remove(key);
/*     */         return localObject1; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 493 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/*     */     try
/*     */     {
/* 501 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 504 */         Map state = getCurrentState(false);
/* 505 */         int i = state.size();
/*     */         return i; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 514 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Collection values()
/*     */   {
/*     */     try
/*     */     {
/* 522 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 525 */         Map state = getCurrentState(false);
/* 526 */         Collection localCollection = state.values();
/*     */         return localCollection; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 535 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 542 */     super.writeExternal(out);
/* 543 */     out.writeLong(this.versionId);
/* 544 */     out.writeObject(this.updates);
/* 545 */     out.writeObject(this.classname);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 551 */     super.readExternal(in);
/* 552 */     this.versionId = in.readLong();
/* 553 */     this.updates = ((HashMap)in.readObject());
/* 554 */     this.classname = ((String)in.readObject());
/*     */     try
/*     */     {
/* 557 */       InitialContext ctx = new InitialContext();
/* 558 */       this.tm = ((TransactionManager)ctx.lookup("java:/TransactionManager"));
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 562 */       throw new RuntimeException(ex);
/*     */     }
/* 564 */     this.txState = new TransactionLocal();
/* 565 */     this.txVersion = new TransactionLocal();
/* 566 */     this.methodMap = mapMethodMap;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  58 */       mapMethodMap = new HashMap();
/*  59 */       Method[] methods = Externalizable.class.getDeclaredMethods();
/*  60 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/*  62 */         long hash = MethodHashing.methodHash(methods[i]);
/*  63 */         mapMethodMap.put(new Long(hash), methods[i]);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*  69 */       ignored.printStackTrace();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.DistributedMapState
 * JD-Core Version:    0.6.0
 */