/*     */ package org.jboss.aspects.versioned;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
/*     */ import EDU.oswego.cs.dl.util.concurrent.Sync;
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.ListIterator;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.aop.InstanceAdvised;
/*     */ import org.jboss.aop.proxy.ClassProxy;
/*     */ import org.jboss.aop.proxy.ClassProxyFactory;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class DistributedListState extends CollectionStateManager
/*     */   implements List, DistributedState, Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = 8318313674571329182L;
/*     */   private static HashMap listMethodMap;
/*  54 */   protected static Logger log = Logger.getLogger(DistributedListState.class);
/*     */   protected volatile long versionId;
/*     */   protected ArrayList updates;
/*     */   protected String classname;
/*     */   protected transient List base;
/*  78 */   protected transient TransactionLocal txState = new TransactionLocal();
/*  79 */   protected transient TransactionLocal txVersion = new TransactionLocal();
/*     */   protected transient DistributedVersionManager versionManager;
/*     */   protected transient SynchronizationManager synchManager;
/*     */   protected transient TransactionManager tm;
/*     */   protected transient ClassProxy proxy;
/*     */ 
/*     */   public DistributedListState()
/*     */   {
/*     */   }
/*     */ 
/*     */   public DistributedListState(GUID guid, long timeout, ClassProxy proxy, List obj, DistributedVersionManager versionManager, SynchronizationManager synchManager)
/*     */     throws Exception
/*     */   {
/*  94 */     super(guid, timeout, listMethodMap);
/*  95 */     this.base = obj;
/*  96 */     this.classname = obj.getClass().getName();
/*  97 */     this.versionManager = versionManager;
/*  98 */     this.synchManager = synchManager;
/*  99 */     this.proxy = proxy;
/* 100 */     InitialContext ctx = new InitialContext();
/* 101 */     this.tm = ((TransactionManager)ctx.lookup("java:/TransactionManager"));
/* 102 */     this.updates = createListUpdates(this.base);
/*     */   }
/*     */ 
/*     */   public HashMap getMethodMap()
/*     */   {
/* 107 */     return ClassProxyFactory.getMethodMap(this.base.getClass().getName());
/*     */   }
/*     */   public InstanceAdvised getObject() {
/* 110 */     return this.proxy;
/*     */   }
/*     */ 
/*     */   protected List getCurrentState(boolean forUpdate)
/*     */     throws Exception
/*     */   {
/* 116 */     Transaction tx = this.tm.getTransaction();
/* 117 */     if (tx == null)
/*     */     {
/* 119 */       if (forUpdate) this.versionId += 1L;
/* 120 */       return this.base;
/*     */     }
/*     */ 
/* 123 */     List state = (Externalizable)this.txState.get(tx);
/* 124 */     if ((state == null) && (forUpdate))
/*     */     {
/* 126 */       state = (Externalizable)this.base.getClass().newInstance();
/* 127 */       state.addAll(this.base);
/* 128 */       this.txState.set(tx, state);
/* 129 */       long newId = this.versionId + 1L;
/* 130 */       this.synchManager.registerUpdate(tx, this);
/* 131 */       this.txVersion.set(tx, new Long(newId));
/* 132 */       return state;
/*     */     }
/* 134 */     return this.base;
/*     */   }
/*     */ 
/*     */   protected ArrayList createListUpdates(List state)
/*     */   {
/* 140 */     ArrayList listUpdates = new ArrayList(state.size());
/* 141 */     Iterator it = state.iterator();
/* 142 */     while (it.hasNext())
/*     */     {
/* 144 */       Object obj = it.next();
/* 145 */       if (this.versionManager.isVersioned(obj))
/*     */       {
/* 147 */         listUpdates.add(new VersionReference(VersionManager.getGUID((InstanceAdvised)obj)));
/*     */       }
/*     */       else
/*     */       {
/* 151 */         listUpdates.add(obj);
/*     */       }
/*     */     }
/* 154 */     return listUpdates;
/*     */   }
/*     */ 
/*     */   public DistributedUpdate createTxUpdate(Transaction tx)
/*     */   {
/* 159 */     List state = (Externalizable)this.txState.get(tx);
/* 160 */     long newId = ((Long)this.txVersion.get(tx)).longValue();
/* 161 */     DistributedListUpdate update = new DistributedListUpdate(this.guid, createListUpdates(state), newId);
/* 162 */     return update;
/*     */   }
/*     */ 
/*     */   public InstanceAdvised buildObject(SynchronizationManager manager, DistributedVersionManager versionManager)
/*     */     throws Exception
/*     */   {
/* 168 */     log.trace("building a List");
/* 169 */     this.versionManager = versionManager;
/* 170 */     this.synchManager = manager;
/* 171 */     log.trace("DistributedListState: classname: " + this.classname);
/* 172 */     Class clazz = Thread.currentThread().getContextClassLoader().loadClass(this.classname);
/* 173 */     this.base = ((Externalizable)clazz.newInstance());
/* 174 */     Iterator it = this.updates.iterator();
/* 175 */     while (it.hasNext())
/*     */     {
/* 177 */       Object val = it.next();
/* 178 */       if ((val instanceof VersionReference))
/*     */       {
/* 180 */         VersionReference ref = (VersionReference)val;
/* 181 */         val = manager.getObject(ref.getGUID());
/* 182 */         if (val == null)
/*     */         {
/* 184 */           DistributedState fieldVal = manager.getState(ref.getGUID());
/* 185 */           val = fieldVal.buildObject(manager, versionManager);
/* 186 */           ref.set((InstanceAdvised)val);
/*     */         }
/*     */       }
/* 189 */       this.base.add(val);
/*     */     }
/* 191 */     this.proxy = versionManager.addListVersioning(this.base, this);
/* 192 */     return this.proxy;
/*     */   }
/*     */ 
/*     */   public void checkOptimisticLock(Transaction tx)
/*     */   {
/* 198 */     Long version = (Long)this.txVersion.get(tx);
/* 199 */     if (version.longValue() <= this.versionId)
/* 200 */       throw new OptimisticLockFailure("optimistic lock failure for list");
/*     */   }
/*     */ 
/*     */   public void mergeState(Transaction tx)
/*     */     throws Exception
/*     */   {
/* 206 */     List current = (Externalizable)this.txState.get(tx);
/* 207 */     this.base = current;
/* 208 */     Long version = (Long)this.txVersion.get(tx);
/* 209 */     this.versionId = version.longValue();
/*     */   }
/*     */ 
/*     */   public void mergeState(DistributedUpdate update) throws Exception
/*     */   {
/* 214 */     DistributedListUpdate listUpdate = (DistributedListUpdate)update;
/* 215 */     this.versionId = listUpdate.versionId;
/* 216 */     this.base.clear();
/* 217 */     Iterator it = listUpdate.listUpdates.iterator();
/* 218 */     while (it.hasNext())
/*     */     {
/* 220 */       Object val = it.next();
/* 221 */       if ((val instanceof VersionReference))
/*     */       {
/* 223 */         VersionReference ref = (VersionReference)val;
/* 224 */         val = this.synchManager.getObject(ref.getGUID());
/* 225 */         ref.set((InstanceAdvised)val);
/*     */       }
/* 227 */       this.base.add(val);
/*     */     }
/* 229 */     this.updates = listUpdate.listUpdates;
/*     */   }
/*     */ 
/*     */   public boolean add(Object val)
/*     */   {
/*     */     try
/*     */     {
/* 238 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 241 */         val = this.versionManager.makeVersioned(val);
/* 242 */         List state = getCurrentState(true);
/* 243 */         boolean bool = state.add(val);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 252 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public void add(int index, Object val)
/*     */   {
/*     */     try
/*     */     {
/* 260 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 263 */         val = this.versionManager.makeVersioned(val);
/* 264 */         List state = getCurrentState(true);
/* 265 */         state.add(index, val);
/*     */       }
/*     */       finally
/*     */       {
/* 269 */         this.lock.readLock().release();
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 274 */       throw new RuntimeException(ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean addAll(Collection c)
/*     */   {
/*     */     try
/*     */     {
/* 283 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 286 */         List state = getCurrentState(true);
/* 287 */         Object[] copy = c.toArray();
/* 288 */         for (int i = 0; i < copy.length; i++)
/*     */         {
/* 290 */           Object item = this.versionManager.makeVersioned(copy[i]);
/* 291 */           state.add(item);
/*     */         }
/* 293 */         i = 1;
/*     */         return i; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 302 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean addAll(int index, Collection c)
/*     */   {
/*     */     try
/*     */     {
/* 310 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 313 */         List state = getCurrentState(true);
/* 314 */         Object[] copy = c.toArray();
/* 315 */         for (int i = 0; i < copy.length; i++)
/*     */         {
/* 317 */           Object item = this.versionManager.makeVersioned(copy[i]);
/* 318 */           state.add(index + i, item);
/*     */         }
/* 320 */         i = 1;
/*     */         return i; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 329 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*     */     try
/*     */     {
/* 337 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 340 */         List state = getCurrentState(true);
/* 341 */         state.clear();
/*     */       }
/*     */       finally
/*     */       {
/* 345 */         this.lock.readLock().release();
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 350 */       throw new RuntimeException(ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean contains(Object o)
/*     */   {
/*     */     try
/*     */     {
/* 358 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 361 */         List state = getCurrentState(false);
/* 362 */         boolean bool = state.contains(o);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 371 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean containsAll(Collection c)
/*     */   {
/*     */     try
/*     */     {
/* 378 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 381 */         List state = getCurrentState(false);
/* 382 */         boolean bool = state.containsAll(c);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 391 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/*     */     try
/*     */     {
/* 398 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 401 */         List state = getCurrentState(false);
/* 402 */         boolean bool = state.equals(o);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 411 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Object get(int i)
/*     */   {
/*     */     try
/*     */     {
/* 418 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 421 */         List state = getCurrentState(false);
/* 422 */         Object localObject1 = state.get(i);
/*     */         return localObject1; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 431 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*     */     try
/*     */     {
/* 438 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 441 */         List state = getCurrentState(false);
/* 442 */         int i = state.hashCode();
/*     */         return i; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 451 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public int indexOf(Object o)
/*     */   {
/*     */     try
/*     */     {
/* 458 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 461 */         List state = getCurrentState(false);
/* 462 */         int i = state.indexOf(o);
/*     */         return i; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 471 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/*     */     try
/*     */     {
/* 478 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 481 */         List state = getCurrentState(false);
/* 482 */         boolean bool = state.isEmpty();
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 491 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Iterator iterator()
/*     */   {
/*     */     try
/*     */     {
/* 498 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 501 */         List state = getCurrentState(false);
/* 502 */         Iterator localIterator = state.iterator();
/*     */         return localIterator; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 511 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public int lastIndexOf(Object o)
/*     */   {
/*     */     try
/*     */     {
/* 518 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 521 */         List state = getCurrentState(false);
/* 522 */         int i = state.lastIndexOf(o);
/*     */         return i; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 531 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public ListIterator listIterator()
/*     */   {
/*     */     try
/*     */     {
/* 538 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 541 */         List state = getCurrentState(false);
/* 542 */         ListIterator localListIterator = state.listIterator();
/*     */         return localListIterator; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 551 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public ListIterator listIterator(int index)
/*     */   {
/*     */     try
/*     */     {
/* 558 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 561 */         List state = getCurrentState(false);
/* 562 */         ListIterator localListIterator = state.listIterator(index);
/*     */         return localListIterator; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 571 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Object remove(int index)
/*     */   {
/*     */     try
/*     */     {
/* 583 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 586 */         List state = getCurrentState(true);
/* 587 */         Object localObject1 = state.remove(index);
/*     */         return localObject1; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 596 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean remove(Object o)
/*     */   {
/*     */     try
/*     */     {
/* 603 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 606 */         List state = getCurrentState(true);
/* 607 */         boolean bool = state.remove(o);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 616 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean removeAll(Collection c)
/*     */   {
/*     */     try
/*     */     {
/* 623 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 626 */         List state = getCurrentState(true);
/* 627 */         boolean bool = state.removeAll(c);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 636 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public boolean retainAll(Collection c)
/*     */   {
/*     */     try
/*     */     {
/* 643 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 646 */         List state = getCurrentState(true);
/* 647 */         boolean bool = state.retainAll(c);
/*     */         return bool; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 656 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Object set(int index, Object element)
/*     */   {
/*     */     try
/*     */     {
/* 663 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/*     */         try
/*     */         {
/* 668 */           element = this.versionManager.makeVersioned(element);
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 672 */           throw new RuntimeException(ex);
/*     */         }
/* 674 */         List state = getCurrentState(true);
/* 675 */         Object localObject1 = state.set(index, element);
/*     */         return localObject1; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 684 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/*     */     try
/*     */     {
/* 691 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 694 */         List state = getCurrentState(false);
/* 695 */         int i = state.size();
/*     */         return i; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 704 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public List subList(int fromIndex, int toIndex)
/*     */   {
/*     */     try
/*     */     {
/* 711 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 714 */         List state = getCurrentState(false);
/* 715 */         List localList1 = state.subList(fromIndex, toIndex);
/*     */         return localList1; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 724 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Object[] toArray()
/*     */   {
/*     */     try
/*     */     {
/* 731 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 734 */         List state = getCurrentState(false);
/* 735 */         Object[] arrayOfObject = state.toArray();
/*     */         return arrayOfObject; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 744 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Object[] toArray(Object[] a)
/*     */   {
/*     */     try
/*     */     {
/* 751 */       this.lock.readLock().acquire();
/*     */       try
/*     */       {
/* 754 */         List state = getCurrentState(false);
/* 755 */         Object[] arrayOfObject = state.toArray(a);
/*     */         return arrayOfObject; } finally { this.lock.readLock().release(); }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 764 */     throw new RuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 771 */     super.writeExternal(out);
/* 772 */     out.writeLong(this.versionId);
/* 773 */     out.writeObject(this.updates);
/* 774 */     out.writeObject(this.classname);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 780 */     super.readExternal(in);
/* 781 */     this.versionId = in.readLong();
/* 782 */     this.updates = ((ArrayList)in.readObject());
/* 783 */     this.classname = ((String)in.readObject());
/*     */     try
/*     */     {
/* 786 */       InitialContext ctx = new InitialContext();
/* 787 */       this.tm = ((TransactionManager)ctx.lookup("java:/TransactionManager"));
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 791 */       throw new RuntimeException(ex);
/*     */     }
/* 793 */     this.txState = new TransactionLocal();
/* 794 */     this.txVersion = new TransactionLocal();
/* 795 */     this.methodMap = listMethodMap;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  59 */       listMethodMap = new HashMap();
/*  60 */       Method[] methods = Externalizable.class.getDeclaredMethods();
/*  61 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/*  63 */         long hash = MethodHashing.methodHash(methods[i]);
/*  64 */         listMethodMap.put(new Long(hash), methods[i]);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*  70 */       ignored.printStackTrace();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.DistributedListState
 * JD-Core Version:    0.6.0
 */