/*    */ package org.jboss.aspects.txlock;
/*    */ 
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.NamingException;
/*    */ import javax.transaction.TransactionManager;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.InstanceAdvisor;
/*    */ import org.jboss.aop.advice.AspectFactory;
/*    */ import org.jboss.aop.joinpoint.Joinpoint;
/*    */ import org.jboss.aop.metadata.SimpleMetaData;
/*    */ import org.jboss.aop.util.PayloadKey;
/*    */ 
/*    */ public class TxLockInterceptorFactory
/*    */   implements AspectFactory
/*    */ {
/*    */   private static TransactionManager getTransactionManager()
/*    */   {
/*    */     try
/*    */     {
/* 46 */       InitialContext ctx = new InitialContext();
/* 47 */       TransactionManager tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
/* 48 */       return tm;
/*    */     }
/*    */     catch (NamingException e) {
/*    */     }
/* 52 */     throw new RuntimeException(e);
/*    */   }
/*    */ 
/*    */   public Object createPerVM()
/*    */   {
/* 58 */     throw new RuntimeException("this interceptor only supports PER_CLASS and PER_INSTANCE");
/*    */   }
/*    */ 
/*    */   public Object createPerClass(Advisor advisor)
/*    */   {
/* 63 */     QueuedTxLock lock = new QueuedTxLock();
/* 64 */     advisor.getClassMetaData().addMetaData("TxLock", "TxLock", lock, PayloadKey.TRANSIENT);
/* 65 */     return new TxLockInterceptor(getTransactionManager(), lock);
/*    */   }
/*    */ 
/*    */   public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor)
/*    */   {
/* 71 */     SimpleMetaData instanceData = instanceAdvisor.getMetaData();
/* 72 */     QueuedTxLock lock = null;
/* 73 */     synchronized (instanceData)
/*    */     {
/* 75 */       lock = (QueuedTxLock)instanceData.getMetaData("TxLock", "TxLock");
/* 76 */       if (lock == null)
/*    */       {
/* 78 */         lock = new QueuedTxLock();
/* 79 */         instanceData.addMetaData("TxLock", "TxLock", lock, PayloadKey.TRANSIENT);
/*    */       }
/*    */     }
/* 82 */     return new TxLockInterceptor(getTransactionManager(), lock);
/*    */   }
/*    */ 
/*    */   public Object createPerJoinpoint(Advisor advisor, Joinpoint jp)
/*    */   {
/* 87 */     throw new RuntimeException("this interceptor only supports PER_CLASS and PER_INSTANCE");
/*    */   }
/*    */ 
/*    */   public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp)
/*    */   {
/* 92 */     throw new RuntimeException("this interceptor only supports PER_CLASS and PER_INSTANCE");
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 97 */     return getClass().getName();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.txlock.TxLockInterceptorFactory
 * JD-Core Version:    0.6.0
 */