/*    */ package org.jboss.aspects.txlock;
/*    */ 
/*    */ import javax.transaction.Transaction;
/*    */ import javax.transaction.TransactionManager;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class TxLockInterceptor
/*    */   implements Interceptor
/*    */ {
/* 42 */   protected Logger log = Logger.getLogger(getClass());
/*    */   private final TransactionManager tm;
/*    */   private final QueuedTxLock lock;
/*    */ 
/*    */   public TxLockInterceptor(TransactionManager tm, QueuedTxLock lock)
/*    */   {
/* 49 */     this.tm = tm;
/* 50 */     this.lock = lock;
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 55 */     return "TxLockInterceptor";
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation)
/*    */     throws Throwable
/*    */   {
/* 63 */     Transaction tx = this.tm.getTransaction();
/* 64 */     if (tx == null) return invocation.invokeNext();
/*    */ 
/* 71 */     this.lock.schedule(tx, invocation);
/*    */     try
/*    */     {
/* 74 */       Object localObject1 = invocation.invokeNext();
/*    */       return localObject1; } finally { this.lock.endInvocation(tx); } throw localObject2;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.txlock.TxLockInterceptor
 * JD-Core Version:    0.6.0
 */