/*     */ package org.jboss.aspects.tx;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.advice.AspectFactory;
/*     */ import org.jboss.aop.joinpoint.ConstructorJoinpoint;
/*     */ import org.jboss.aop.joinpoint.FieldJoinpoint;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.joinpoint.MethodJoinpoint;
/*     */ import org.jboss.aop.metadata.ConstructorMetaData;
/*     */ import org.jboss.aop.metadata.FieldMetaData;
/*     */ import org.jboss.aop.metadata.MethodMetaData;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.tm.TransactionManagerLocator;
/*     */ 
/*     */ public class TxInterceptorFactory
/*     */   implements AspectFactory
/*     */ {
/*     */   protected TxPolicy policy;
/*  45 */   protected HashMap nameMap = new HashMap();
/*     */ 
/*     */   protected void initializePolicy()
/*     */   {
/*  49 */     this.policy = new TxPolicy();
/*     */   }
/*     */ 
/*     */   public void initialize()
/*     */   {
/*  54 */     if (this.policy != null) return;
/*  55 */     initializePolicy();
/*  56 */     this.nameMap.put("NEVER", new TxInterceptor.Never(TransactionManagerLocator.getInstance().locate(), this.policy));
/*  57 */     this.nameMap.put("NOTSUPPORTED", new TxInterceptor.NotSupported(TransactionManagerLocator.getInstance().locate(), this.policy));
/*  58 */     this.nameMap.put("SUPPORTS", new TxInterceptor.Supports(TransactionManagerLocator.getInstance().locate(), this.policy));
/*  59 */     this.nameMap.put("REQUIRED", new TxInterceptor.Required(TransactionManagerLocator.getInstance().locate(), this.policy));
/*  60 */     this.nameMap.put("REQUIRESNEW", new TxInterceptor.RequiresNew(TransactionManagerLocator.getInstance().locate(), this.policy));
/*  61 */     this.nameMap.put("MANDATORY", new TxInterceptor.Mandatory(TransactionManagerLocator.getInstance().locate(), this.policy));
/*     */   }
/*     */ 
/*     */   protected String resolveTxType(Advisor advisor, Joinpoint jp)
/*     */   {
/*  66 */     if ((jp instanceof ConstructorJoinpoint))
/*     */     {
/*  68 */       Constructor con = ((ConstructorJoinpoint)jp).getConstructor();
/*  69 */       String txType = (String)advisor.getConstructorMetaData().getConstructorMetaData(con, "transaction", "trans-attribute");
/*  70 */       if (txType != null) return txType;
/*     */ 
/*  72 */       txType = (String)advisor.getDefaultMetaData().getMetaData("transaction", "trans-attribute");
/*  73 */       if (txType != null) return txType;
/*     */ 
/*  75 */       Tx tx = (Tx)advisor.resolveAnnotation(con, Tx.class);
/*  76 */       if (tx == null)
/*     */       {
/*  78 */         tx = (Tx)advisor.resolveAnnotation(Tx.class);
/*     */       }
/*  80 */       if (tx == null) return "REQUIRED";
/*  81 */       return tx.value().name();
/*     */     }
/*  83 */     if ((jp instanceof MethodJoinpoint))
/*     */     {
/*  85 */       Method con = ((MethodJoinpoint)jp).getMethod();
/*  86 */       String txType = (String)advisor.getMethodMetaData().getMethodMetaData(con, "transaction", "trans-attribute");
/*  87 */       if (txType != null) return txType;
/*     */ 
/*  89 */       txType = (String)advisor.getDefaultMetaData().getMetaData("transaction", "trans-attribute");
/*  90 */       if (txType != null) return txType;
/*     */ 
/*  92 */       Tx tx = (Tx)advisor.resolveAnnotation(con, Tx.class);
/*  93 */       if (tx == null)
/*     */       {
/*  95 */         tx = (Tx)advisor.resolveAnnotation(Tx.class);
/*     */       }
/*  97 */       if (tx == null) return "REQUIRED";
/*  98 */       return tx.value().name();
/*     */     }
/*     */ 
/* 102 */     Field con = ((FieldJoinpoint)jp).getField();
/* 103 */     String txType = (String)advisor.getFieldMetaData().getFieldMetaData(con, "transaction", "trans-attribute");
/* 104 */     if (txType != null) return txType;
/*     */ 
/* 106 */     txType = (String)advisor.getDefaultMetaData().getMetaData("transaction", "trans-attribute");
/* 107 */     if (txType != null) return txType;
/*     */ 
/* 109 */     Tx tx = (Tx)advisor.resolveAnnotation(con, Tx.class);
/* 110 */     if (tx == null)
/*     */     {
/* 112 */       tx = (Tx)advisor.resolveAnnotation(Tx.class);
/*     */     }
/* 114 */     if (tx == null) return "REQUIRED";
/* 115 */     return tx.value().name();
/*     */   }
/*     */ 
/*     */   public Object createPerJoinpoint(Advisor advisor, Joinpoint jp)
/*     */   {
/* 122 */     initialize();
/* 123 */     String txType = resolveTxType(advisor, jp);
/* 124 */     Object rtn = this.nameMap.get(txType.toUpperCase());
/* 125 */     if (rtn == null) throw new RuntimeException("TX TYPE was null for: " + txType);
/* 126 */     return rtn;
/*     */   }
/*     */ 
/*     */   public Object createPerVM()
/*     */   {
/* 131 */     throw new IllegalStateException("Scope not allowed");
/*     */   }
/*     */ 
/*     */   public Object createPerClass(Advisor advisor)
/*     */   {
/* 136 */     throw new IllegalStateException("Scope not allowed");
/*     */   }
/*     */ 
/*     */   public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor)
/*     */   {
/* 141 */     throw new IllegalStateException("Scope not allowed");
/*     */   }
/*     */ 
/*     */   public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp)
/*     */   {
/* 146 */     throw new IllegalStateException("Scope not allowed");
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 151 */     return getClass().getName();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.tx.TxInterceptorFactory
 * JD-Core Version:    0.6.0
 */