/*     */ package org.jboss.aspects.security;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.bytecode.MethodInfo;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.metadata.ClassMetaDataBinding;
/*     */ import org.jboss.aop.metadata.ClassMetaDataLoader;
/*     */ import org.jboss.aop.metadata.ConstructorMetaData;
/*     */ import org.jboss.aop.metadata.FieldMetaData;
/*     */ import org.jboss.aop.metadata.MethodMetaData;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.aop.util.XmlHelper;
/*     */ import org.jboss.security.AnybodyPrincipal;
/*     */ import org.jboss.security.NobodyPrincipal;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class SecurityClassMetaDataLoader
/*     */   implements ClassMetaDataLoader
/*     */ {
/*     */   public ClassMetaDataBinding importMetaData(Element element, String name, String group, String classExpr)
/*     */     throws Exception
/*     */   {
/*  60 */     SecurityClassMetaDataBinding data = new SecurityClassMetaDataBinding(this, name, group, classExpr);
/*  61 */     ArrayList securityRoles = loadSecurityRoles(element);
/*  62 */     ArrayList methodPermissions = loadMethodPermissions(element);
/*  63 */     ArrayList methodExcludeList = loadMethodExcludeList(element);
/*  64 */     HashMap fieldPermissions = loadFieldPermissions(element);
/*  65 */     ArrayList fieldExcludeList = loadFieldExcludeList(element);
/*  66 */     ArrayList constructorPermissions = loadConstructorPermissions(element);
/*  67 */     ArrayList constructorExcludeList = loadConstructorExcludeList(element);
/*  68 */     String runAs = loadRunAs(element);
/*     */ 
/*  70 */     String securityDomain = XmlHelper.getOptionalChildContent(element, "security-domain");
/*  71 */     if (securityDomain == null) throw new RuntimeException("you must define a security-domain");
/*  72 */     data.setSecurityDomain(securityDomain);
/*  73 */     data.setSecurityRoles(securityRoles);
/*  74 */     data.setMethodPermissions(methodPermissions);
/*  75 */     data.setMethodExcludeList(methodExcludeList);
/*  76 */     data.setFieldPermissions(fieldPermissions);
/*  77 */     data.setFieldExcludeList(fieldExcludeList);
/*  78 */     data.setConstructorPermissions(constructorPermissions);
/*  79 */     data.setConstructorExcludeList(constructorExcludeList);
/*  80 */     data.setRunAs(runAs);
/*  81 */     return data;
/*     */   }
/*     */ 
/*     */   public void bind(Advisor advisor, ClassMetaDataBinding data, Method[] methods, Field[] fields, Constructor[] constructors) throws Exception
/*     */   {
/*  86 */     SecurityClassMetaDataBinding meta = (SecurityClassMetaDataBinding)data;
/*     */     try
/*     */     {
/*  89 */       String securityDomain = "java:/jaas/" + meta.getSecurityDomain();
/*  90 */       Object domain = new InitialContext().lookup(securityDomain);
/*  91 */       advisor.getDefaultMetaData().addMetaData("security", "authentication-manager", domain, PayloadKey.TRANSIENT);
/*  92 */       advisor.getDefaultMetaData().addMetaData("security", "realm-mapping", domain, PayloadKey.TRANSIENT);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  96 */       throw new RuntimeException("failed to load security domain: " + meta.getSecurityDomain(), ex);
/*     */     }
/*     */ 
/*  99 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 101 */       Set permissions = getMethodPermissions(methods[i], meta);
/* 102 */       if (permissions == null)
/*     */         continue;
/* 104 */       advisor.getMethodMetaData().addMethodMetaData(methods[i], "security", "roles", permissions, PayloadKey.TRANSIENT);
/*     */     }
/*     */ 
/* 108 */     for (int i = 0; i < fields.length; i++)
/*     */     {
/* 110 */       Set permissions = getFieldPermissions(fields[i], meta);
/* 111 */       if (permissions == null)
/*     */         continue;
/* 113 */       advisor.getFieldMetaData().addFieldMetaData(fields[i], "security", "roles", permissions, PayloadKey.TRANSIENT);
/*     */     }
/*     */ 
/* 117 */     for (int i = 0; i < constructors.length; i++)
/*     */     {
/* 119 */       Set permissions = getConstructorPermissions(constructors[i], meta);
/* 120 */       if (permissions == null)
/*     */         continue;
/* 122 */       advisor.getConstructorMetaData().addConstructorMetaData(constructors[i], "security", "roles", permissions, PayloadKey.TRANSIENT);
/*     */     }
/*     */ 
/* 126 */     if (meta.getRunAs() != null)
/*     */     {
/* 128 */       advisor.getDefaultMetaData().addMetaData("security", "run-as", new RunAsIdentity(meta.getRunAs(), null), PayloadKey.TRANSIENT);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Set getMethodPermissions(Method method, SecurityClassMetaDataBinding meta)
/*     */   {
/* 134 */     Set result = new HashSet();
/*     */ 
/* 137 */     Iterator iterator = meta.getMethodExcludeList().iterator();
/* 138 */     while (iterator.hasNext())
/*     */     {
/* 140 */       SecurityMethodConfig m = (SecurityMethodConfig)iterator.next();
/* 141 */       if (m.patternMatches(method))
/*     */       {
/* 148 */         result.add(NobodyPrincipal.NOBODY_PRINCIPAL);
/* 149 */         return result;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 154 */     iterator = meta.getMethodPermissions().iterator();
/* 155 */     while (iterator.hasNext())
/*     */     {
/* 157 */       SecurityMethodConfig m = (SecurityMethodConfig)iterator.next();
/* 158 */       if (m.patternMatches(method))
/*     */       {
/* 163 */         if (m.isUnchecked())
/*     */         {
/* 165 */           result.clear();
/* 166 */           result.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
/* 167 */           break;
/*     */         }
/*     */ 
/* 172 */         Iterator rolesIterator = m.getRoles().iterator();
/* 173 */         while (rolesIterator.hasNext())
/*     */         {
/* 175 */           String roleName = (String)rolesIterator.next();
/* 176 */           result.add(new SimplePrincipal(roleName));
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 184 */     if (result.isEmpty())
/*     */     {
/* 186 */       result = null;
/*     */     }
/*     */ 
/* 189 */     return result;
/*     */   }
/*     */ 
/*     */   public Set getFieldPermissions(Field field, SecurityClassMetaDataBinding meta)
/*     */   {
/* 195 */     String fieldName = field.getName();
/* 196 */     Set result = new HashSet();
/*     */ 
/* 199 */     Iterator iterator = meta.getFieldExcludeList().iterator();
/* 200 */     while (iterator.hasNext())
/*     */     {
/* 202 */       String expr = (String)iterator.next();
/* 203 */       if ((expr.equals("*")) || (expr.equals(fieldName)))
/*     */       {
/* 210 */         result.add(NobodyPrincipal.NOBODY_PRINCIPAL);
/* 211 */         return result;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 216 */     iterator = meta.getFieldPermissions().keySet().iterator();
/* 217 */     while (iterator.hasNext())
/*     */     {
/* 219 */       String expr = (String)iterator.next();
/*     */ 
/* 221 */       if ((expr.equals("*")) || (expr.equals(fieldName)))
/*     */       {
/* 223 */         Object permission = meta.getFieldPermissions().get(expr);
/*     */ 
/* 227 */         if ((permission instanceof Boolean))
/*     */         {
/* 229 */           result.clear();
/* 230 */           result.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
/* 231 */           break;
/*     */         }
/*     */ 
/* 236 */         Set roles = (Set)permission;
/* 237 */         Iterator rolesIterator = roles.iterator();
/* 238 */         while (rolesIterator.hasNext())
/*     */         {
/* 240 */           String roleName = (String)rolesIterator.next();
/* 241 */           result.add(new SimplePrincipal(roleName));
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 249 */     if (result.isEmpty())
/*     */     {
/* 251 */       result = null;
/*     */     }
/*     */ 
/* 254 */     return result;
/*     */   }
/*     */ 
/*     */   protected String loadRunAs(Element element)
/*     */     throws Exception
/*     */   {
/* 261 */     Element securityIdentityElement = XmlHelper.getOptionalChild(element, "security-identity");
/*     */ 
/* 263 */     if (securityIdentityElement == null) return null;
/* 264 */     Element callerIdent = XmlHelper.getOptionalChild(securityIdentityElement, "use-caller-identity");
/* 265 */     Element runAs = XmlHelper.getOptionalChild(securityIdentityElement, "run-as");
/* 266 */     if ((callerIdent == null) && (runAs == null))
/* 267 */       throw new RuntimeException("security-identity: either use-caller-identity or run-as must be specified");
/* 268 */     if ((callerIdent != null) && (runAs != null)) {
/* 269 */       throw new RuntimeException("security-identity: only one of use-caller-identity or run-as can be specified");
/*     */     }
/* 271 */     String runAsRoleName = null;
/* 272 */     if (runAs != null)
/*     */     {
/* 274 */       runAsRoleName = XmlHelper.getElementContent(XmlHelper.getUniqueChild(runAs, "role-name"));
/*     */     }
/* 276 */     return runAsRoleName;
/*     */   }
/*     */ 
/*     */   protected ArrayList loadSecurityRoles(Element assemblyDescriptor)
/*     */     throws Exception
/*     */   {
/* 282 */     ArrayList securityRoles = new ArrayList();
/*     */ 
/* 284 */     Iterator iterator = XmlHelper.getChildrenByTagName(assemblyDescriptor, "security-role");
/* 285 */     while (iterator.hasNext())
/*     */     {
/* 287 */       Element securityRole = (Element)iterator.next();
/*     */       try
/*     */       {
/* 290 */         String role = XmlHelper.getUniqueChildContent(securityRole, "role-name");
/* 291 */         securityRoles.add(role);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 295 */         throw new RuntimeException("Error in metadata for security-role: ", e);
/*     */       }
/*     */     }
/*     */ 
/* 299 */     return securityRoles;
/*     */   }
/*     */ 
/*     */   protected ArrayList loadMethodPermissions(Element assemblyDescriptor) throws Exception
/*     */   {
/* 304 */     ArrayList permissionMethods = new ArrayList();
/*     */ 
/* 306 */     Iterator iterator = XmlHelper.getChildrenByTagName(assemblyDescriptor, "method-permission");
/*     */ 
/* 308 */     while (iterator.hasNext())
/*     */     {
/* 310 */       Element methodPermission = (Element)iterator.next();
/*     */ 
/* 312 */       Element unchecked = XmlHelper.getOptionalChild(methodPermission, "unchecked");
/*     */ 
/* 315 */       boolean isUnchecked = false;
/* 316 */       Set roles = null;
/* 317 */       if (unchecked != null)
/*     */       {
/* 319 */         isUnchecked = true;
/*     */       }
/*     */       else
/*     */       {
/* 324 */         roles = new HashSet();
/* 325 */         Iterator rolesIterator = XmlHelper.getChildrenByTagName(methodPermission, "role-name");
/* 326 */         while (rolesIterator.hasNext())
/*     */         {
/* 328 */           roles.add(XmlHelper.getElementContent((Element)rolesIterator.next()));
/*     */         }
/* 330 */         if (roles.size() == 0) {
/* 331 */           throw new RuntimeException("An unchecked element in security metadata or one or more role-name elements must be specified in method-permission");
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 337 */       Iterator methods = XmlHelper.getChildrenByTagName(methodPermission, "method");
/*     */ 
/* 339 */       while (methods.hasNext())
/*     */       {
/* 342 */         SecurityMethodConfig method = new SecurityMethodConfig();
/* 343 */         method.importXml((Element)methods.next());
/* 344 */         if (isUnchecked)
/*     */         {
/* 346 */           method.setUnchecked();
/* 347 */           permissionMethods.add(0, method);
/*     */         }
/*     */         else
/*     */         {
/* 351 */           method.setRoles(roles);
/* 352 */           permissionMethods.add(method);
/*     */         }
/*     */       }
/*     */     }
/* 356 */     return permissionMethods;
/*     */   }
/*     */ 
/*     */   protected ArrayList loadMethodExcludeList(Element assemblyDescriptor) throws Exception
/*     */   {
/* 361 */     ArrayList excluded = new ArrayList();
/*     */ 
/* 363 */     Element excludeList = XmlHelper.getOptionalChild(assemblyDescriptor, "exclude-list");
/*     */ 
/* 365 */     if (excludeList != null)
/*     */     {
/* 367 */       Iterator iterator = XmlHelper.getChildrenByTagName(excludeList, "method");
/* 368 */       while (iterator.hasNext())
/*     */       {
/* 370 */         Element methodInf = (Element)iterator.next();
/*     */ 
/* 372 */         SecurityMethodConfig method = new SecurityMethodConfig();
/* 373 */         method.importXml(methodInf);
/* 374 */         method.setExcluded();
/* 375 */         excluded.add(method);
/*     */       }
/*     */     }
/* 378 */     return excluded;
/*     */   }
/*     */ 
/*     */   protected HashMap loadFieldPermissions(Element assemblyDescriptor) throws Exception
/*     */   {
/* 383 */     HashMap permissionFields = new HashMap();
/*     */ 
/* 385 */     Iterator iterator = XmlHelper.getChildrenByTagName(assemblyDescriptor, "field-permission");
/*     */ 
/* 387 */     while (iterator.hasNext())
/*     */     {
/* 389 */       Element fieldPermission = (Element)iterator.next();
/*     */ 
/* 391 */       Element unchecked = XmlHelper.getOptionalChild(fieldPermission, "unchecked");
/*     */ 
/* 394 */       boolean isUnchecked = false;
/* 395 */       Set roles = null;
/* 396 */       if (unchecked != null)
/*     */       {
/* 398 */         isUnchecked = true;
/*     */       }
/*     */       else
/*     */       {
/* 403 */         roles = new HashSet();
/* 404 */         Iterator rolesIterator = XmlHelper.getChildrenByTagName(fieldPermission, "role-name");
/* 405 */         while (rolesIterator.hasNext())
/*     */         {
/* 407 */           roles.add(XmlHelper.getElementContent((Element)rolesIterator.next()));
/*     */         }
/* 409 */         if (roles.size() == 0) {
/* 410 */           throw new RuntimeException("An unchecked element in security metadata or one or more role-name elements must be specified in field-permission");
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 416 */       Iterator fields = XmlHelper.getChildrenByTagName(fieldPermission, "field");
/*     */ 
/* 418 */       while (fields.hasNext())
/*     */       {
/* 421 */         Element field = (Element)fields.next();
/* 422 */         String fieldName = XmlHelper.getElementContent(XmlHelper.getUniqueChild(field, "field-name"));
/*     */ 
/* 424 */         if (isUnchecked)
/*     */         {
/* 426 */           permissionFields.put(fieldName, Boolean.TRUE);
/*     */         }
/*     */         else
/*     */         {
/* 431 */           Object permission = permissionFields.get(fieldName);
/* 432 */           if ((permission != null) && ((permission instanceof Boolean)))
/*     */           {
/*     */             continue;
/*     */           }
/* 436 */           if (permission != null)
/*     */           {
/* 438 */             Set curr = (Set)permission;
/* 439 */             curr.addAll(roles);
/*     */           }
/*     */           else
/*     */           {
/* 443 */             permissionFields.put(fieldName, new HashSet(roles));
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 448 */     return permissionFields;
/*     */   }
/*     */ 
/*     */   protected ArrayList loadFieldExcludeList(Element assemblyDescriptor) throws Exception
/*     */   {
/* 453 */     ArrayList excluded = new ArrayList();
/*     */ 
/* 455 */     Element excludeList = XmlHelper.getOptionalChild(assemblyDescriptor, "exclude-list");
/*     */ 
/* 457 */     if (excludeList != null)
/*     */     {
/* 459 */       Iterator iterator = XmlHelper.getChildrenByTagName(excludeList, "field");
/* 460 */       while (iterator.hasNext())
/*     */       {
/* 462 */         Element fieldInf = (Element)iterator.next();
/* 463 */         String fieldName = XmlHelper.getElementContent(XmlHelper.getUniqueChild(fieldInf, "field-name"));
/* 464 */         excluded.add(fieldName);
/*     */       }
/*     */     }
/* 467 */     return excluded;
/*     */   }
/*     */ 
/*     */   protected ArrayList loadConstructorPermissions(Element assemblyDescriptor) throws Exception
/*     */   {
/* 472 */     ArrayList permissionConstructors = new ArrayList();
/*     */ 
/* 474 */     Iterator iterator = XmlHelper.getChildrenByTagName(assemblyDescriptor, "constructor-permission");
/*     */ 
/* 476 */     while (iterator.hasNext())
/*     */     {
/* 478 */       Element constructorPermission = (Element)iterator.next();
/*     */ 
/* 480 */       Element unchecked = XmlHelper.getOptionalChild(constructorPermission, "unchecked");
/*     */ 
/* 483 */       boolean isUnchecked = false;
/* 484 */       Set roles = null;
/* 485 */       if (unchecked != null)
/*     */       {
/* 487 */         isUnchecked = true;
/*     */       }
/*     */       else
/*     */       {
/* 492 */         roles = new HashSet();
/* 493 */         Iterator rolesIterator = XmlHelper.getChildrenByTagName(constructorPermission, "role-name");
/* 494 */         while (rolesIterator.hasNext())
/*     */         {
/* 496 */           roles.add(XmlHelper.getElementContent((Element)rolesIterator.next()));
/*     */         }
/* 498 */         if (roles.size() == 0) {
/* 499 */           throw new RuntimeException("An unchecked element in security metadata or one or more role-name elements must be specified in constructor-permission");
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 505 */       Iterator constructors = XmlHelper.getChildrenByTagName(constructorPermission, "constructor");
/*     */ 
/* 507 */       while (constructors.hasNext())
/*     */       {
/* 510 */         SecurityConstructorConfig constructor = new SecurityConstructorConfig();
/* 511 */         constructor.importXml((Element)constructors.next());
/* 512 */         if (isUnchecked)
/*     */         {
/* 514 */           constructor.setUnchecked();
/* 515 */           permissionConstructors.add(0, constructor);
/*     */         }
/*     */         else
/*     */         {
/* 519 */           constructor.setRoles(roles);
/* 520 */           permissionConstructors.add(constructor);
/*     */         }
/*     */       }
/*     */     }
/* 524 */     return permissionConstructors;
/*     */   }
/*     */ 
/*     */   protected ArrayList loadConstructorExcludeList(Element assemblyDescriptor) throws Exception
/*     */   {
/* 529 */     ArrayList excluded = new ArrayList();
/*     */ 
/* 531 */     Element excludeList = XmlHelper.getOptionalChild(assemblyDescriptor, "exclude-list");
/*     */ 
/* 533 */     if (excludeList != null)
/*     */     {
/* 535 */       Iterator iterator = XmlHelper.getChildrenByTagName(excludeList, "constructor");
/* 536 */       while (iterator.hasNext())
/*     */       {
/* 538 */         Element constructorInf = (Element)iterator.next();
/*     */ 
/* 540 */         SecurityConstructorConfig constructor = new SecurityConstructorConfig();
/* 541 */         constructor.importXml(constructorInf);
/* 542 */         constructor.setExcluded();
/* 543 */         excluded.add(constructor);
/*     */       }
/*     */     }
/* 546 */     return excluded;
/*     */   }
/*     */ 
/*     */   public Set getConstructorPermissions(Constructor constructor, SecurityClassMetaDataBinding meta)
/*     */   {
/* 551 */     Set result = new HashSet();
/*     */ 
/* 554 */     Iterator iterator = meta.getConstructorExcludeList().iterator();
/* 555 */     while (iterator.hasNext())
/*     */     {
/* 557 */       SecurityConstructorConfig m = (SecurityConstructorConfig)iterator.next();
/* 558 */       if (m.patternMatches(constructor))
/*     */       {
/* 565 */         result.add(NobodyPrincipal.NOBODY_PRINCIPAL);
/* 566 */         return result;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 571 */     iterator = meta.getConstructorPermissions().iterator();
/* 572 */     while (iterator.hasNext())
/*     */     {
/* 574 */       SecurityConstructorConfig m = (SecurityConstructorConfig)iterator.next();
/* 575 */       if (m.patternMatches(constructor))
/*     */       {
/* 580 */         if (m.isUnchecked())
/*     */         {
/* 582 */           result.clear();
/* 583 */           result.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
/* 584 */           break;
/*     */         }
/*     */ 
/* 589 */         Iterator rolesIterator = m.getRoles().iterator();
/* 590 */         while (rolesIterator.hasNext())
/*     */         {
/* 592 */           String roleName = (String)rolesIterator.next();
/* 593 */           result.add(new SimplePrincipal(roleName));
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 601 */     if (result.isEmpty())
/*     */     {
/* 603 */       result = null;
/*     */     }
/*     */ 
/* 606 */     return result;
/*     */   }
/*     */ 
/*     */   public void bind(Advisor advisor, ClassMetaDataBinding data, CtMethod[] methods, CtField[] fields, CtConstructor[] constructors)
/*     */     throws Exception
/*     */   {
/* 623 */     SecurityClassMetaDataBinding meta = (SecurityClassMetaDataBinding)data;
/* 624 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 626 */       boolean permissions = getMethodPermissions(methods[i], meta);
/* 627 */       if (!permissions)
/*     */         continue;
/* 629 */       advisor.getMethodMetaData().addMethodMetaData(methods[i], "security", "roles", Boolean.TRUE, PayloadKey.TRANSIENT);
/*     */     }
/*     */ 
/* 633 */     for (int i = 0; i < fields.length; i++)
/*     */     {
/* 635 */       boolean permissions = getFieldPermissions(fields[i], meta);
/* 636 */       if (!permissions)
/*     */         continue;
/* 638 */       advisor.getFieldMetaData().addFieldMetaData(fields[i].getName(), "security", "roles", Boolean.TRUE, PayloadKey.TRANSIENT);
/*     */     }
/*     */ 
/* 642 */     for (int i = 0; i < constructors.length; i++)
/*     */     {
/* 644 */       boolean permissions = getConstructorPermissions(constructors[i], meta);
/* 645 */       if (!permissions) {
/*     */         continue;
/*     */       }
/* 648 */       advisor.getConstructorMetaData().addConstructorMetaData(constructors[i].getMethodInfo2().getDescriptor(), "security", "roles", Boolean.TRUE, PayloadKey.TRANSIENT);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean getMethodPermissions(CtMethod method, SecurityClassMetaDataBinding meta)
/*     */     throws Exception
/*     */   {
/* 665 */     Iterator iterator = meta.getMethodExcludeList().iterator();
/* 666 */     while (iterator.hasNext())
/*     */     {
/* 668 */       SecurityMethodConfig m = (SecurityMethodConfig)iterator.next();
/* 669 */       if (m.patternMatches(method))
/*     */       {
/* 671 */         return true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 676 */     iterator = meta.getMethodPermissions().iterator();
/* 677 */     while (iterator.hasNext())
/*     */     {
/* 679 */       SecurityMethodConfig m = (SecurityMethodConfig)iterator.next();
/* 680 */       if (m.patternMatches(method))
/*     */       {
/* 682 */         return true;
/*     */       }
/*     */     }
/*     */ 
/* 686 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean getFieldPermissions(CtField field, SecurityClassMetaDataBinding meta)
/*     */   {
/* 692 */     String fieldName = field.getName();
/*     */ 
/* 695 */     Iterator iterator = meta.getFieldExcludeList().iterator();
/* 696 */     while (iterator.hasNext())
/*     */     {
/* 698 */       String expr = (String)iterator.next();
/* 699 */       if ((expr.equals("*")) || (expr.equals(fieldName)))
/*     */       {
/* 701 */         return true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 706 */     iterator = meta.getFieldPermissions().keySet().iterator();
/* 707 */     while (iterator.hasNext())
/*     */     {
/* 709 */       String expr = (String)iterator.next();
/*     */ 
/* 711 */       if ((expr.equals("*")) || (expr.equals(fieldName)))
/*     */       {
/* 713 */         return true;
/*     */       }
/*     */     }
/*     */ 
/* 717 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean getConstructorPermissions(CtConstructor constructor, SecurityClassMetaDataBinding meta)
/*     */     throws NotFoundException
/*     */   {
/* 725 */     Iterator iterator = meta.getConstructorExcludeList().iterator();
/* 726 */     while (iterator.hasNext())
/*     */     {
/* 728 */       SecurityConstructorConfig m = (SecurityConstructorConfig)iterator.next();
/* 729 */       if (m.patternMatches(constructor))
/*     */       {
/* 731 */         return true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 736 */     iterator = meta.getConstructorPermissions().iterator();
/* 737 */     while (iterator.hasNext())
/*     */     {
/* 739 */       SecurityConstructorConfig m = (SecurityConstructorConfig)iterator.next();
/* 740 */       if (m.patternMatches(constructor))
/*     */       {
/* 742 */         return true;
/*     */       }
/*     */     }
/*     */ 
/* 746 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.security.SecurityClassMetaDataLoader
 * JD-Core Version:    0.6.0
 */