/*     */ package org.jboss.aspects.security;
/*     */ 
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.jacc.PolicyContext;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextFactory;
/*     */ import org.jboss.security.plugins.SecurityContextAssociation;
/*     */ 
/*     */ class SecurityActions
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(SecurityActions.class);
/*     */ 
/*     */   static ClassLoader getContextClassLoader()
/*     */   {
/* 338 */     return SecurityActions.TCLAction.UTIL.getContextClassLoader();
/*     */   }
/*     */ 
/*     */   static void setContextClassLoader(ClassLoader loader)
/*     */   {
/* 343 */     SecurityActions.TCLAction.UTIL.setContextClassLoader(loader);
/*     */   }
/*     */ 
/*     */   static Principal getCallerPrincipal()
/*     */   {
/* 348 */     if (System.getSecurityManager() == null)
/*     */     {
/* 350 */       return PrincipalInfoAction.NON_PRIVILEGED.getCallerPrincipal();
/*     */     }
/*     */ 
/* 354 */     return PrincipalInfoAction.PRIVILEGED.getCallerPrincipal();
/*     */   }
/*     */ 
/*     */   static Principal getPrincipal()
/*     */   {
/* 360 */     if (System.getSecurityManager() == null)
/*     */     {
/* 362 */       return PrincipalInfoAction.NON_PRIVILEGED.getPrincipal();
/*     */     }
/*     */ 
/* 366 */     return PrincipalInfoAction.PRIVILEGED.getPrincipal();
/*     */   }
/*     */ 
/*     */   static void setPrincipal(Principal principal)
/*     */   {
/* 372 */     if (System.getSecurityManager() == null)
/*     */     {
/* 374 */       PrincipalInfoAction.NON_PRIVILEGED.setPrincipal(principal);
/*     */     }
/*     */     else
/*     */     {
/* 378 */       PrincipalInfoAction.PRIVILEGED.setPrincipal(principal);
/*     */     }
/*     */   }
/*     */ 
/*     */   static Object getCredential()
/*     */   {
/* 384 */     if (System.getSecurityManager() == null)
/*     */     {
/* 386 */       return PrincipalInfoAction.NON_PRIVILEGED.getCredential();
/*     */     }
/*     */ 
/* 390 */     return PrincipalInfoAction.PRIVILEGED.getCredential();
/*     */   }
/*     */ 
/*     */   static void setCredential(Object credential)
/*     */   {
/* 396 */     if (System.getSecurityManager() == null)
/*     */     {
/* 398 */       PrincipalInfoAction.NON_PRIVILEGED.setCredential(credential);
/*     */     }
/*     */     else
/*     */     {
/* 402 */       PrincipalInfoAction.PRIVILEGED.setCredential(credential);
/*     */     }
/*     */   }
/*     */ 
/*     */   static void pushSubjectContext(Principal principal, Object credential, Subject subject)
/*     */   {
/* 409 */     if (System.getSecurityManager() == null)
/*     */     {
/* 411 */       PrincipalInfoAction.NON_PRIVILEGED.push(principal, credential, subject);
/*     */     }
/*     */     else
/*     */     {
/* 415 */       PrincipalInfoAction.PRIVILEGED.push(principal, credential, subject);
/*     */     }
/*     */   }
/*     */ 
/*     */   static void popSubjectContext() {
/* 420 */     if (System.getSecurityManager() == null)
/*     */     {
/* 422 */       PrincipalInfoAction.NON_PRIVILEGED.pop();
/*     */     }
/*     */     else
/*     */     {
/* 426 */       PrincipalInfoAction.PRIVILEGED.pop();
/*     */     }
/*     */   }
/*     */ 
/*     */   static RunAsIdentity peekRunAsIdentity()
/*     */   {
/* 432 */     if (System.getSecurityManager() == null)
/*     */     {
/* 434 */       return RunAsIdentityActions.NON_PRIVILEGED.peek();
/*     */     }
/*     */ 
/* 438 */     return RunAsIdentityActions.PRIVILEGED.peek();
/*     */   }
/*     */ 
/*     */   static void pushRunAsIdentity(RunAsIdentity principal)
/*     */   {
/* 444 */     if (System.getSecurityManager() == null)
/*     */     {
/* 446 */       RunAsIdentityActions.NON_PRIVILEGED.push(principal);
/*     */     }
/*     */     else
/*     */     {
/* 450 */       RunAsIdentityActions.PRIVILEGED.push(principal);
/*     */     }
/*     */   }
/*     */ 
/*     */   static RunAsIdentity popRunAsIdentity()
/*     */   {
/* 456 */     if (System.getSecurityManager() == null)
/*     */     {
/* 458 */       return RunAsIdentityActions.NON_PRIVILEGED.pop();
/*     */     }
/*     */ 
/* 462 */     return RunAsIdentityActions.PRIVILEGED.pop();
/*     */   }
/*     */ 
/*     */   static Exception getContextException()
/*     */   {
/* 468 */     if (System.getSecurityManager() == null)
/*     */     {
/* 470 */       return ContextInfoActions.NON_PRIVILEGED.getContextException();
/*     */     }
/*     */ 
/* 474 */     return ContextInfoActions.PRIVILEGED.getContextException();
/*     */   }
/*     */ 
/*     */   static Subject getContextSubject()
/*     */     throws PolicyContextException
/*     */   {
/* 481 */     if (System.getSecurityManager() == null)
/*     */     {
/* 483 */       return PolicyContextActions.NON_PRIVILEGED.getContextSubject();
/*     */     }
/*     */ 
/* 487 */     return PolicyContextActions.PRIVILEGED.getContextSubject();
/*     */   }
/*     */ 
/*     */   static void clearSecurityContext()
/*     */   {
/* 654 */     ClearSecurityContextAction action = new ClearSecurityContextAction();
/* 655 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   static SecurityContext createSecurityContext() throws PrivilegedActionException
/*     */   {
/* 660 */     return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction()
/*     */     {
/*     */       public Object run()
/*     */         throws Exception
/*     */       {
/* 665 */         return SecurityContextFactory.createSecurityContext("CLIENT");
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static SecurityContext getSecurityContext() {
/* 672 */     GetSecurityContextAction action = new GetSecurityContextAction();
/* 673 */     return (SecurityContext)AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   static void setSecurityContext(SecurityContext sc)
/*     */   {
/* 678 */     SetSecurityContextAction action = new SetSecurityContextAction(sc);
/* 679 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   static void establishSecurityContext(String domain, Principal p, Object cred, Subject subject)
/*     */     throws Exception
/*     */   {
/* 685 */     SecurityContext sc = SecurityContextFactory.createSecurityContext(p, cred, subject, domain);
/*     */ 
/* 687 */     setSecurityContext(sc);
/*     */   }
/*     */ 
/*     */   private static class ClearSecurityContextAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     public Object run()
/*     */     {
/* 647 */       SecurityContextAssociation.clearSecurityContext();
/* 648 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class SetSecurityContextAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     private SecurityContext securityContext;
/*     */ 
/*     */     SetSecurityContextAction(SecurityContext sc)
/*     */     {
/* 630 */       this.securityContext = sc;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/* 635 */       SecurityContextAssociation.setSecurityContext(this.securityContext);
/* 636 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class GetSecurityContextAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     public Object run()
/*     */     {
/* 621 */       return SecurityContextAssociation.getSecurityContext();
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface TCLAction
/*     */   {
/* 526 */     public static final TCLAction NON_PRIVILEGED = new TCLAction()
/*     */     {
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 530 */         return Thread.currentThread().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 535 */         return thread.getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 540 */         Thread.currentThread().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 545 */         thread.setContextClassLoader(cl);
/*     */       }
/* 526 */     };
/*     */ 
/* 549 */     public static final TCLAction PRIVILEGED = new TCLAction()
/*     */     {
/* 551 */       private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 555 */           return Thread.currentThread().getContextClassLoader();
/*     */         }
/* 551 */       };
/*     */ 
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 561 */         return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 566 */         return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(thread)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 570 */             return this.val$thread.getContextClassLoader();
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl) {
/* 577 */         AccessController.doPrivileged(new PrivilegedAction(cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 582 */             Thread.currentThread().setContextClassLoader(this.val$cl);
/* 583 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 591 */         AccessController.doPrivileged(new PrivilegedAction(thread, cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 596 */             this.val$thread.setContextClassLoader(this.val$cl);
/* 597 */             return null;
/*     */           }
/*     */         });
/*     */       }
/* 549 */     };
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader();
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader(Thread paramThread);
/*     */ 
/*     */     public abstract void setContextClassLoader(ClassLoader paramClassLoader);
/*     */ 
/*     */     public abstract void setContextClassLoader(Thread paramThread, ClassLoader paramClassLoader);
/*     */ 
/*     */     public static class UTIL
/*     */     {
/*     */       static SecurityActions.TCLAction getTCLAction()
/*     */       {
/* 502 */         return System.getSecurityManager() == null ? SecurityActions.TCLAction.NON_PRIVILEGED : SecurityActions.TCLAction.PRIVILEGED;
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader()
/*     */       {
/* 507 */         return getTCLAction().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 512 */         return getTCLAction().getContextClassLoader(thread);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 517 */         getTCLAction().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 522 */         getTCLAction().setContextClassLoader(thread, cl);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface PolicyContextActions
/*     */   {
/*     */     public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
/* 296 */     public static final PolicyContextActions PRIVILEGED = new PolicyContextActions()
/*     */     {
/* 298 */       private final PrivilegedExceptionAction exAction = new PrivilegedExceptionAction()
/*     */       {
/*     */         public Object run() throws Exception
/*     */         {
/* 302 */           return (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
/*     */         }
/* 298 */       };
/*     */ 
/*     */       public Subject getContextSubject()
/*     */         throws PolicyContextException
/*     */       {
/*     */         Exception ex;
/*     */         try
/*     */         {
/* 310 */           return (Subject)AccessController.doPrivileged(this.exAction);
/*     */         }
/*     */         catch (PrivilegedActionException e)
/*     */         {
/* 314 */           ex = e.getException();
/* 315 */           if ((ex instanceof PolicyContextException))
/* 316 */             throw ((PolicyContextException)ex);
/*     */         }
/* 318 */         throw new UndeclaredThrowableException(ex);
/*     */       }
/* 296 */     };
/*     */ 
/* 323 */     public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions()
/*     */     {
/*     */       public Subject getContextSubject()
/*     */         throws PolicyContextException
/*     */       {
/* 328 */         return (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
/*     */       }
/* 323 */     };
/*     */ 
/*     */     public abstract Subject getContextSubject()
/*     */       throws PolicyContextException;
/*     */   }
/*     */ 
/*     */   static abstract interface ContextInfoActions
/*     */   {
/*     */     public static final String EX_KEY = "org.jboss.security.exception";
/* 266 */     public static final ContextInfoActions PRIVILEGED = new ContextInfoActions()
/*     */     {
/* 268 */       private final PrivilegedAction exAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 272 */           return SecurityAssociation.getContextInfo("org.jboss.security.exception");
/*     */         }
/* 268 */       };
/*     */ 
/*     */       public Exception getContextException()
/*     */       {
/* 277 */         return (Exception)AccessController.doPrivileged(this.exAction);
/*     */       }
/* 266 */     };
/*     */ 
/* 281 */     public static final ContextInfoActions NON_PRIVILEGED = new ContextInfoActions()
/*     */     {
/*     */       public Exception getContextException()
/*     */       {
/* 285 */         return (Exception)SecurityAssociation.getContextInfo("org.jboss.security.exception");
/*     */       }
/* 281 */     };
/*     */ 
/*     */     public abstract Exception getContextException();
/*     */   }
/*     */ 
/*     */   static abstract interface RunAsIdentityActions
/*     */   {
/* 195 */     public static final RunAsIdentityActions PRIVILEGED = new RunAsIdentityActions()
/*     */     {
/* 197 */       private final PrivilegedAction peekAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 201 */           return SecurityAssociation.peekRunAsIdentity();
/*     */         }
/* 197 */       };
/*     */ 
/* 205 */       private final PrivilegedAction popAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 209 */           return SecurityAssociation.popRunAsIdentity();
/*     */         }
/* 205 */       };
/*     */ 
/*     */       public RunAsIdentity peek()
/*     */       {
/* 215 */         return (RunAsIdentity)AccessController.doPrivileged(this.peekAction);
/*     */       }
/*     */ 
/*     */       public void push(RunAsIdentity id)
/*     */       {
/* 220 */         AccessController.doPrivileged(new PrivilegedAction(id)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 225 */             SecurityAssociation.pushRunAsIdentity(this.val$id);
/* 226 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public RunAsIdentity pop()
/*     */       {
/* 234 */         return (RunAsIdentity)AccessController.doPrivileged(this.popAction);
/*     */       }
/* 195 */     };
/*     */ 
/* 238 */     public static final RunAsIdentityActions NON_PRIVILEGED = new RunAsIdentityActions()
/*     */     {
/*     */       public RunAsIdentity peek()
/*     */       {
/* 242 */         return SecurityAssociation.peekRunAsIdentity();
/*     */       }
/*     */ 
/*     */       public void push(RunAsIdentity id)
/*     */       {
/* 247 */         SecurityAssociation.pushRunAsIdentity(id);
/*     */       }
/*     */ 
/*     */       public RunAsIdentity pop()
/*     */       {
/* 252 */         return SecurityAssociation.popRunAsIdentity();
/*     */       }
/* 238 */     };
/*     */ 
/*     */     public abstract RunAsIdentity peek();
/*     */ 
/*     */     public abstract void push(RunAsIdentity paramRunAsIdentity);
/*     */ 
/*     */     public abstract RunAsIdentity pop();
/*     */   }
/*     */ 
/*     */   static abstract interface PrincipalInfoAction
/*     */   {
/*  53 */     public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction()
/*     */     {
/*     */       public void push(Principal principal, Object credential, Subject subject)
/*     */       {
/*  58 */         AccessController.doPrivileged(new PrivilegedAction(subject, principal, credential)
/*     */         {
/*     */           public Object run()
/*     */           {
/*  63 */             SecurityAssociation.pushSubjectContext(this.val$subject, this.val$principal, this.val$credential);
/*  64 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void pop() {
/*  71 */         AccessController.doPrivileged(new PrivilegedAction()
/*     */         {
/*     */           public Object run()
/*     */           {
/*  76 */             SecurityAssociation.popSubjectContext();
/*  77 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public Principal getPrincipal()
/*     */       {
/*  85 */         return (Principal)AccessController.doPrivileged(new PrivilegedAction()
/*     */         {
/*     */           public Object run()
/*     */           {
/*  90 */             return SecurityAssociation.getPrincipal();
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setPrincipal(Principal principal)
/*     */       {
/*  98 */         AccessController.doPrivileged(new PrivilegedAction(principal)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 103 */             SecurityAssociation.setPrincipal(this.val$principal);
/* 104 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public Principal getCallerPrincipal()
/*     */       {
/* 112 */         return (Principal)AccessController.doPrivileged(new PrivilegedAction()
/*     */         {
/*     */           public Object run()
/*     */           {
/* 117 */             return SecurityAssociation.getCallerPrincipal();
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public Object getCredential()
/*     */       {
/* 125 */         return AccessController.doPrivileged(new PrivilegedAction()
/*     */         {
/*     */           public Object run()
/*     */           {
/* 130 */             return SecurityAssociation.getCredential();
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setCredential(Object credential)
/*     */       {
/* 138 */         AccessController.doPrivileged(new PrivilegedAction(credential)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 143 */             SecurityAssociation.setCredential(this.val$credential);
/* 144 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*  53 */     };
/*     */ 
/* 151 */     public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction()
/*     */     {
/*     */       public void push(Principal principal, Object credential, Subject subject)
/*     */       {
/* 155 */         SecurityAssociation.pushSubjectContext(subject, principal, credential);
/*     */       }
/*     */ 
/*     */       public void pop() {
/* 159 */         SecurityAssociation.popSubjectContext();
/*     */       }
/*     */ 
/*     */       public Principal getPrincipal() {
/* 163 */         return SecurityAssociation.getPrincipal();
/*     */       }
/*     */ 
/*     */       public void setPrincipal(Principal principal) {
/* 167 */         SecurityAssociation.setPrincipal(principal);
/*     */       }
/*     */ 
/*     */       public Principal getCallerPrincipal() {
/* 171 */         return SecurityAssociation.getPrincipal();
/*     */       }
/*     */ 
/*     */       public Object getCredential() {
/* 175 */         return SecurityAssociation.getCredential();
/*     */       }
/*     */ 
/*     */       public void setCredential(Object credential) {
/* 179 */         SecurityAssociation.setCredential(credential);
/*     */       }
/* 151 */     };
/*     */ 
/*     */     public abstract void push(Principal paramPrincipal, Object paramObject, Subject paramSubject);
/*     */ 
/*     */     public abstract void pop();
/*     */ 
/*     */     public abstract Principal getPrincipal();
/*     */ 
/*     */     public abstract void setPrincipal(Principal paramPrincipal);
/*     */ 
/*     */     public abstract Principal getCallerPrincipal();
/*     */ 
/*     */     public abstract Object getCredential();
/*     */ 
/*     */     public abstract void setCredential(Object paramObject);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.security.SecurityActions
 * JD-Core Version:    0.6.0
 */