/*    */ package org.jboss.aspects.security;
/*    */ 
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.NamingException;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.InstanceAdvisor;
/*    */ import org.jboss.aop.advice.AspectFactory;
/*    */ import org.jboss.aop.joinpoint.Joinpoint;
/*    */ import org.jboss.aop.metadata.SimpleMetaData;
/*    */ import org.jboss.security.AuthenticationManager;
/*    */ import org.jboss.security.RealmMapping;
/*    */ 
/*    */ public class RunAsSecurityInterceptorFactory
/*    */   implements AspectFactory
/*    */ {
/*    */   public Object createPerVM()
/*    */   {
/* 45 */     throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
/*    */   }
/*    */ 
/*    */   public Object createPerClass(Advisor advisor)
/*    */   {
/* 50 */     AuthenticationManager manager = (AuthenticationManager)advisor.getDefaultMetaData().getMetaData("security", "authentication-manager");
/* 51 */     RealmMapping mapping = (RealmMapping)advisor.getDefaultMetaData().getMetaData("security", "realm-mapping");
/* 52 */     if (manager == null)
/*    */     {
/* 54 */       SecurityDomain domain = (SecurityDomain)advisor.resolveAnnotation(SecurityDomain.class);
/* 55 */       if (domain == null) throw new RuntimeException("Unable to determine security domain");
/*    */       try
/*    */       {
/* 58 */         manager = (AuthenticationManager)new InitialContext().lookup("java:/jaas/" + domain.value());
/*    */       }
/*    */       catch (NamingException e)
/*    */       {
/* 62 */         throw new RuntimeException(e);
/*    */       }
/* 64 */       mapping = (RealmMapping)manager;
/*    */     }
/* 66 */     if (manager == null) throw new RuntimeException("Unable to find Security Domain");
/* 67 */     return new RunAsSecurityInterceptor(manager, mapping);
/*    */   }
/*    */ 
/*    */   public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor)
/*    */   {
/* 72 */     throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
/*    */   }
/*    */ 
/*    */   public Object createPerJoinpoint(Advisor advisor, Joinpoint jp)
/*    */   {
/* 77 */     throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
/*    */   }
/*    */ 
/*    */   public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp)
/*    */   {
/* 82 */     throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 87 */     return getClass().getName();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.security.RunAsSecurityInterceptorFactory
 * JD-Core Version:    0.6.0
 */